/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.models;

import com.adobe.cq.wcm.core.components.models.Component;

public interface TableOfContents
extends Component {
    public static final String PN_LIST_TYPE = "listType";
    public static final String PN_START_LEVEL = "startLevel";
    public static final String PN_STOP_LEVEL = "stopLevel";
    public static final String PN_RESTRICT_LIST_TYPE = "restrictListType";
    public static final String PN_RESTRICT_START_LEVEL = "restrictStartLevel";
    public static final String PN_RESTRICT_STOP_LEVEL = "restrictStopLevel";
    public static final String PN_INCLUDE_CLASSES = "includeClasses";
    public static final String PN_IGNORE_CLASSES = "ignoreClasses";
    public static final String TOC_CONTENT_CLASS = "cmp-toc__content";
    public static final String TOC_PLACEHOLDER_CLASS = "cmp-toc__placeholder";
    public static final String TOC_TEMPLATE_PLACEHOLDER_CLASS = "cmp-toc__template-placeholder";
    public static final String TOC_DATA_ATTR_LIST_TYPE = "data-cmp-toc-list-type";
    public static final String TOC_DATA_ATTR_START_LEVEL = "data-cmp-toc-start-level";
    public static final String TOC_DATA_ATTR_STOP_LEVEL = "data-cmp-toc-stop-level";
    public static final String TOC_DATA_ATTR_INCLUDE_CLASSES = "data-cmp-toc-include-classes";
    public static final String TOC_DATA_ATTR_IGNORE_CLASSES = "data-cmp-toc-ignore-classes";

    default public ListType getListType() {
        return ListType.bulleted;
    }

    default public HeadingLevel getStartLevel() {
        return HeadingLevel.h1;
    }

    default public HeadingLevel getStopLevel() {
        return HeadingLevel.h6;
    }

    default public String[] getIncludeClasses() {
        return null;
    }

    default public String[] getIgnoreClasses() {
        return null;
    }

    public static enum HeadingLevel {
        h1("h1"),
        h2("h2"),
        h3("h3"),
        h4("h4"),
        h5("h5"),
        h6("h6");

        private String value;

        private HeadingLevel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getIntValue() {
            return this.value.charAt(1) - 48;
        }

        public String getTagName() {
            return this.value;
        }

        public static HeadingLevel fromString(String value) {
            for (HeadingLevel type : HeadingLevel.values()) {
                if (!type.value.contentEquals(value)) continue;
                return type;
            }
            return null;
        }

        public static HeadingLevel fromStringOrDefault(String value, HeadingLevel defaultLevel) {
            HeadingLevel level = HeadingLevel.fromString(value);
            return level != null ? level : defaultLevel;
        }
    }

    public static enum ListType {
        bulleted("bulleted"),
        numbered("numbered");

        private String value;

        private ListType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getTagName() {
            return this == numbered ? "ol" : "ul";
        }

        public static ListType fromString(String value) {
            for (ListType type : ListType.values()) {
                if (!type.value.contentEquals(value)) continue;
                return type;
            }
            return bulleted;
        }
    }
}

