/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.Index;
import java.io.IOException;

class NameIndex
extends Index {
    public NameIndex(CFFByteArray data, int offset) throws IOException, InvalidFontException, UnsupportedFontException {
        super(data, offset);
    }

    public String getNthName(int n) throws InvalidFontException {
        if (n < 0 || this.entryCount < n) {
            return null;
        }
        int offset = this.offsetOf(n);
        int size = this.sizeOf(n);
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)this.data.getcard8(offset++);
        }
        return new String(chars);
    }

    public static void toBinary(CFFByteArray.CFFByteArrayBuilder bb, String s) {
        Index.Cursor cursor = NameIndex.startIndex(bb, 1);
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) == '\u0000') continue;
            bb.addCard8(s.charAt(j));
        }
        cursor = NameIndex.elementEntered(bb, cursor);
    }
}

