/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.connector.msft.core;

import com.adobe.granite.translation.connector.msft.core.MicrosoftTranslationCloudConfig;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftTranslationUtil {
    private static final Logger log = LoggerFactory.getLogger(MicrosoftTranslationUtil.class);
    private static String CLOUD_CONFIG_PROPERTY = "cq:cloudserviceconfigs";

    public static boolean isMicrosoftConfiguration(Resource translationConfigResource) {
        log.trace("In function: isMicrosoftConfiguration(Resource translationConfigResource)");
        Resource content = null;
        content = "jcr:content".equals(translationConfigResource.getName()) ? translationConfigResource : translationConfigResource.getChild("jcr:content");
        if (content != null) {
            return content.getResourceType().equals("cq/translation/components/msft/msft-cloudconfig");
        }
        return false;
    }

    public static MicrosoftTranslationCloudConfig getAppliedMicrosoftTranslationCloudConfigs(Resource resource) {
        if (resource == null) {
            return null;
        }
        log.trace("In Function: getAppliedMicrosoftTranslationCloudConfigs({})", (Object)resource.getPath());
        String[] appliedCloudConfigs = null;
        ResourceResolver resolver = resource.getResourceResolver();
        boolean isContentNode = ResourceUtil.getName(resource.getPath()).equals("jcr:content");
        Resource content = !isContentNode ? resolver.getResource(resource, "jcr:content") : resource;
        if (content != null) {
            block9: {
                if (log.isTraceEnabled()) {
                    log.trace("Resource: {}", (Object)resource.getPath());
                    log.trace("Content: {}", (Object)content.getPath());
                }
                try {
                    appliedCloudConfigs = (String[])ResourceUtil.getValueMap(content).get(CLOUD_CONFIG_PROPERTY);
                }
                catch (ClassCastException cce) {
                    log.trace("Trying to cast as String as String[] failed");
                    String singleValue = (String)ResourceUtil.getValueMap(content).get(CLOUD_CONFIG_PROPERTY);
                    if (singleValue == null || "".equals(singleValue)) break block9;
                    appliedCloudConfigs = new String[]{singleValue};
                }
            }
            if (appliedCloudConfigs != null) {
                MicrosoftTranslationCloudConfig mtcc = null;
                for (int i = 0; i < appliedCloudConfigs.length; ++i) {
                    Resource appliedConfig = resolver.getResource(appliedCloudConfigs[i]);
                    if (appliedConfig != null) {
                        mtcc = appliedConfig.adaptTo(MicrosoftTranslationCloudConfig.class);
                    }
                    if (mtcc != null) {
                        log.trace("Found our MicrosoftTranslationCloudConfig {}", (Object)appliedCloudConfigs[i]);
                        return mtcc;
                    }
                    log.trace("Applied Cloud Config {} was not a MicrosoftTranslationCloudConfig.", (Object)appliedCloudConfigs[i]);
                }
            }
        }
        return MicrosoftTranslationUtil.getParentAppliedMicrosoftTranslationCloudConfigs(resource);
    }

    private static MicrosoftTranslationCloudConfig getParentAppliedMicrosoftTranslationCloudConfigs(Resource resource) {
        if (resource == null) {
            return null;
        }
        log.trace("In Function: getParentAppliedMicrosoftTranslationCloudConfigs({})", (Object)resource.getPath());
        ResourceResolver resolver = resource.getResourceResolver();
        String parentPath = ResourceUtil.getParent(resource.getPath());
        if (null != parentPath) {
            Resource parent = resolver.getResource(parentPath);
            return MicrosoftTranslationUtil.getAppliedMicrosoftTranslationCloudConfigs(parent);
        }
        return null;
    }
}

