/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.ooxml.extractor.ExtractorFactory;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.apache.poi.xssf.extractor.XSSFBEventBasedExcelExtractor;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.microsoft.ooxml.POIXMLTextExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.SXSLFPowerPointExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.SXWPFWordExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSLFPowerPointExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSSFBExcelExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSSFExcelExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XWPFWordExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.xps.XPSExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.xps.XPSTextExtractor;
import org.apache.tika.parser.microsoft.ooxml.xslf.XSLFEventBasedPowerPointExtractor;
import org.apache.tika.parser.microsoft.ooxml.xwpf.XWPFEventBasedWordExtractor;
import org.apache.tika.parser.pkg.ZipContainerDetector;
import org.apache.tika.parser.utils.ZipSalvager;
import org.apache.tika.utils.RereadableInputStream;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OOXMLExtractorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OOXMLExtractorFactory.class);
    private static final int MAX_BUFFER_LENGTH = 1000000;

    public static void parse(InputStream stream, ContentHandler baseHandler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Locale locale = context.get(Locale.class, LocaleUtil.getUserLocale());
        ExtractorFactory.setThreadPrefersEventExtractors(true);
        File tmpRepairedCopy = null;
        OPCPackage pkg = null;
        try {
            PackageRelationshipCollection prc;
            AbstractOOXMLExtractor extractor = null;
            TikaInputStream tis = TikaInputStream.cast(stream);
            if (tis != null && tis.getOpenContainer() instanceof OPCPackage) {
                pkg = (OPCPackage)tis.getOpenContainer();
            } else if (tis != null && tis.hasFile()) {
                try {
                    pkg = OPCPackage.open(tis.getFile().getPath(), PackageAccess.READ);
                }
                catch (InvalidOperationException e) {
                    tmpRepairedCopy = File.createTempFile("tika-ooxml-repair-", "");
                    ZipSalvager.salvageCopy(tis.getFile(), tmpRepairedCopy);
                    pkg = OPCPackage.open(tmpRepairedCopy, PackageAccess.READ);
                }
                tis.setOpenContainer(pkg);
            } else {
                try (RereadableInputStream rereadableInputStream = new RereadableInputStream(stream, 1000000, true, false);){
                    try {
                        pkg = OPCPackage.open(rereadableInputStream);
                    }
                    catch (EOFException | UnsupportedZipFeatureException e) {
                        rereadableInputStream.rewind();
                        tmpRepairedCopy = File.createTempFile("tika-ooxml-repair-", "");
                        ZipSalvager.salvageCopy(rereadableInputStream, tmpRepairedCopy, false);
                        pkg = OPCPackage.open(tmpRepairedCopy, PackageAccess.READ);
                    }
                }
            }
            if (pkg != null && (prc = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin")) != null && prc.size() > 0) {
                metadata.set(TikaCoreProperties.HAS_SIGNATURE, "true");
            }
            MediaType type = null;
            String mediaTypeString = metadata.get("Content-Type");
            if (mediaTypeString != null) {
                type = MediaType.parse(mediaTypeString);
            }
            if (type != null && OOXMLParser.UNSUPPORTED_OOXML_TYPES.contains(type)) {
                EmptyParser.INSTANCE.parse(stream, baseHandler, metadata, context);
                return;
            }
            if (type == null || !OOXMLParser.SUPPORTED_TYPES.contains(type)) {
                type = ZipContainerDetector.detectOfficeOpenXML(pkg);
            }
            if (type == null || OOXMLParser.UNSUPPORTED_OOXML_TYPES.contains(type)) {
                EmptyParser.INSTANCE.parse(stream, baseHandler, metadata, context);
                return;
            }
            metadata.set("Content-Type", type.toString());
            POIXMLTextExtractor poiExtractor = null;
            OfficeParserConfig config = context.get(OfficeParserConfig.class);
            if (config.getUseSAXDocxExtractor()) {
                poiExtractor = OOXMLExtractorFactory.trySXWPF(pkg);
            }
            if (poiExtractor == null) {
                poiExtractor = OOXMLExtractorFactory.tryXSLF(pkg, config.getUseSAXPptxExtractor());
            }
            if (type.equals(OOXMLParser.XPS)) {
                poiExtractor = new XPSTextExtractor(pkg);
            }
            if (poiExtractor == null) {
                poiExtractor = (POIXMLTextExtractor)ExtractorFactory.createExtractor(pkg);
            }
            POIXMLDocument document = poiExtractor.getDocument();
            if (poiExtractor instanceof XSSFBEventBasedExcelExtractor) {
                extractor = new XSSFBExcelExtractorDecorator(context, poiExtractor, locale);
            } else if (poiExtractor instanceof XSSFEventBasedExcelExtractor) {
                extractor = new XSSFExcelExtractorDecorator(context, poiExtractor, locale);
            } else if (poiExtractor instanceof XWPFEventBasedWordExtractor) {
                extractor = new SXWPFWordExtractorDecorator(metadata, context, (XWPFEventBasedWordExtractor)poiExtractor);
                metadata.add("X-Parsed-By", XWPFEventBasedWordExtractor.class.getCanonicalName());
            } else if (poiExtractor instanceof XSLFEventBasedPowerPointExtractor) {
                extractor = new SXSLFPowerPointExtractorDecorator(metadata, context, (XSLFEventBasedPowerPointExtractor)poiExtractor);
                metadata.add("X-Parsed-By", XSLFEventBasedPowerPointExtractor.class.getCanonicalName());
            } else if (poiExtractor instanceof XPSTextExtractor) {
                extractor = new XPSExtractorDecorator(context, poiExtractor);
            } else {
                if (document == null) {
                    throw new TikaException("Expecting UserModel based POI OOXML extractor with a document, but none found. The extractor returned was a " + poiExtractor);
                }
                extractor = document instanceof XMLSlideShow ? new XSLFPowerPointExtractorDecorator(context, (XSLFPowerPointExtractor)poiExtractor) : (document instanceof XWPFDocument ? new XWPFWordExtractorDecorator(metadata, context, (XWPFWordExtractor)poiExtractor) : new POIXMLTextExtractorDecorator(context, poiExtractor));
            }
            extractor.getMetadataExtractor().extract(metadata);
            extractor.getXHTML(baseHandler, metadata, context);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("No supported documents found")) {
                throw new TikaException("TIKA-418: RuntimeException while getting content for thmx and xps file types", e);
            }
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (OpenXML4JException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (XmlException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
        finally {
            if (tmpRepairedCopy != null) {
                boolean deleted;
                if (pkg != null) {
                    try {
                        pkg.close();
                    }
                    catch (IOException e) {
                        LOG.warn("problem closing pkg file");
                    }
                }
                if (!(deleted = tmpRepairedCopy.delete())) {
                    LOG.warn("failed to delete tmp (repair) file: " + tmpRepairedCopy.getAbsolutePath());
                }
            }
        }
    }

    private static POIXMLTextExtractor trySXWPF(OPCPackage pkg) throws TikaException, XmlException, OpenXML4JException, IOException {
        PackageRelationshipCollection packageRelationshipCollection = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (packageRelationshipCollection.size() == 0) {
            packageRelationshipCollection = pkg.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument");
        }
        if (packageRelationshipCollection.size() == 0) {
            return null;
        }
        PackagePart corePart = pkg.getPart(packageRelationshipCollection.getRelationship(0));
        if (corePart == null) {
            throw new TikaException("Couldn't find core part.");
        }
        String targetContentType = corePart.getContentType();
        for (XWPFRelation relation : XWPFWordExtractor.SUPPORTED_TYPES) {
            if (!targetContentType.equals(relation.getContentType())) continue;
            return new XWPFEventBasedWordExtractor(pkg);
        }
        return null;
    }

    private static POIXMLTextExtractor tryXSLF(OPCPackage pkg, boolean eventBased) throws TikaException, XmlException, OpenXML4JException, IOException {
        PackageRelationshipCollection packageRelationshipCollection = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (packageRelationshipCollection.size() == 0) {
            packageRelationshipCollection = pkg.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument");
        }
        if (packageRelationshipCollection.size() == 0) {
            return null;
        }
        PackagePart corePart = pkg.getPart(packageRelationshipCollection.getRelationship(0));
        if (corePart == null) {
            throw new TikaException("Couldn't find core part");
        }
        String targetContentType = corePart.getContentType();
        XSLFRelation[] xslfRelations = XSLFPowerPointExtractor.SUPPORTED_TYPES;
        for (int i = 0; i < xslfRelations.length; ++i) {
            XSLFRelation xslfRelation = xslfRelations[i];
            if (!xslfRelation.getContentType().equals(targetContentType)) continue;
            if (eventBased) {
                return new XSLFEventBasedPowerPointExtractor(pkg);
            }
            return new XSLFPowerPointExtractor(new XSLFSlideShow(pkg));
        }
        if (XSLFRelation.THEME_MANAGER.getContentType().equals(targetContentType)) {
            if (eventBased) {
                return new XSLFEventBasedPowerPointExtractor(pkg);
            }
            return new XSLFPowerPointExtractor(new XSLFSlideShow(pkg));
        }
        return null;
    }
}

