/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.api;

import com.adobe.granite.comments.Comment;
import com.adobe.granite.comments.CommentCollection;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationMetadata;
import com.adobe.granite.translation.api.TranslationObject;
import com.adobe.granite.translation.api.TranslationResult;
import com.adobe.granite.translation.api.TranslationScope;
import com.adobe.granite.translation.api.TranslationState;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public interface TranslationService {
    public Map<String, String> supportedLanguages();

    public boolean isDirectionSupported(String var1, String var2) throws TranslationException;

    public String detectLanguage(String var1, TranslationConstants.ContentType var2) throws TranslationException;

    public TranslationResult translateString(String var1, String var2, String var3, TranslationConstants.ContentType var4, String var5) throws TranslationException;

    public TranslationResult[] translateArray(String[] var1, String var2, String var3, TranslationConstants.ContentType var4, String var5) throws TranslationException;

    public TranslationResult[] getAllStoredTranslations(String var1, String var2, String var3, TranslationConstants.ContentType var4, String var5, String var6, int var7) throws TranslationException;

    public void storeTranslation(String var1, String var2, String var3, String var4, TranslationConstants.ContentType var5, String var6, String var7, int var8, String var9) throws TranslationException;

    public void storeTranslation(String[] var1, String var2, String var3, String[] var4, TranslationConstants.ContentType var5, String var6, String var7, int var8, String var9) throws TranslationException;

    public String getDefaultCategory();

    public void setDefaultCategory(String var1);

    public TranslationServiceInfo getTranslationServiceInfo();

    public String createTranslationJob(String var1, String var2, String var3, String var4, Date var5, TranslationState var6, TranslationMetadata var7) throws TranslationException;

    public void updateTranslationJobMetadata(String var1, TranslationMetadata var2, TranslationConstants.TranslationMethod var3) throws TranslationException;

    public String uploadTranslationObject(String var1, TranslationObject var2) throws TranslationException;

    public TranslationScope getFinalScope(String var1) throws TranslationException;

    public TranslationConstants.TranslationStatus updateTranslationJobState(String var1, TranslationState var2) throws TranslationException;

    public TranslationConstants.TranslationStatus getTranslationJobStatus(String var1) throws TranslationException;

    public CommentCollection<Comment> getTranslationJobCommentCollection(String var1) throws TranslationException;

    public void addTranslationJobComment(String var1, Comment var2) throws TranslationException;

    public InputStream getTranslatedObject(String var1, TranslationObject var2) throws TranslationException;

    public TranslationConstants.TranslationStatus updateTranslationObjectState(String var1, TranslationObject var2, TranslationState var3) throws TranslationException;

    public TranslationConstants.TranslationStatus getTranslationObjectStatus(String var1, TranslationObject var2) throws TranslationException;

    public TranslationConstants.TranslationStatus[] updateTranslationObjectsState(String var1, TranslationObject[] var2, TranslationState[] var3) throws TranslationException;

    public TranslationConstants.TranslationStatus[] getTranslationObjectsStatus(String var1, TranslationObject[] var2) throws TranslationException;

    public CommentCollection<Comment> getTranslationObjectCommentCollection(String var1, TranslationObject var2) throws TranslationException;

    public void addTranslationObjectComment(String var1, TranslationObject var2, Comment var3) throws TranslationException;

    public void updateDueDate(String var1, Date var2) throws TranslationException;

    public static interface TranslationServiceInfo {
        public String getTranslationServiceAttribution();

        public String getTranslationServiceLabel();

        public String getTranslationServiceName();

        public TranslationConstants.TranslationMethod getSupportedTranslationMethod();

        public String getServiceCloudConfigRootPath();
    }
}

