/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.feed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;

public class StringResponseWrapper
extends SlingHttpServletResponseWrapper {
    private StringWriter sw;
    private PrintWriter pw;
    private ByteArrayOutputStream bos;
    private ServletOutputStream sos;

    public StringResponseWrapper(SlingHttpServletResponse slingHttpServletResponse) {
        super(slingHttpServletResponse);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.sos == null) {
            if (this.pw != null) {
                throw new IllegalStateException("Writer already obtained.");
            }
            this.bos = new ByteArrayOutputStream();
            this.sos = new AtomFeedOutputStream(this.bos);
        }
        return this.sos;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.pw == null) {
            if (this.sos != null) {
                throw new IllegalStateException("Output stream already obtained.");
            }
            this.sw = new StringWriter();
            this.pw = new PrintWriter(this.sw);
        }
        return this.pw;
    }

    public String getString() throws UnsupportedEncodingException {
        if (this.sw != null) {
            return this.sw.toString();
        }
        if (this.bos != null) {
            return this.bos.toString(super.getCharacterEncoding());
        }
        return "";
    }

    public class AtomFeedOutputStream
    extends ServletOutputStream {
        private final OutputStream out;

        public AtomFeedOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }
    }
}

