/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.api;

import com.day.cq.mcm.api.Experience;
import com.day.cq.mcm.api.MCMPlugin;
import com.day.cq.mcm.api.Touchpoint;
import com.day.cq.mcm.util.NormalizedResource;
import java.util.Collection;
import java.util.HashMap;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MCMPluginAdapter
implements MCMPlugin {
    private static final Logger log = LoggerFactory.getLogger(MCMPluginAdapter.class);
    private HashMap<String, Factory<Experience>> experienceFactoryMap = new HashMap();
    private HashMap<String, Factory<Touchpoint>> touchpointFactoryMap = new HashMap();

    @Override
    public Collection<String> getTouchpointRootComponents() {
        return this.touchpointFactoryMap.keySet();
    }

    @Override
    public Collection<String> getExperienceRootComponents() {
        return this.experienceFactoryMap.keySet();
    }

    protected void addExperienceComponent(String compType, Factory<Experience> fac) {
        if (fac == null) {
            throw new NullPointerException("Factory null");
        }
        this.experienceFactoryMap.put(compType, fac);
    }

    protected void addTouchpointComponent(String compType, Factory<Touchpoint> fac) {
        if (fac == null) {
            throw new NullPointerException("Factory null");
        }
        this.touchpointFactoryMap.put(compType, fac);
    }

    @Override
    public Experience makeExperience(Resource adaptable) {
        Experience retval = null;
        String compTypeToSearch = this.extractCompType(adaptable);
        if (compTypeToSearch == null) {
            throw new RuntimeException("Given resource doesn't have a resource type: " + adaptable.getPath());
        }
        if (!this.experienceFactoryMap.containsKey(compTypeToSearch)) {
            throw new RuntimeException("Unkown resourceType (misuse of the the class? We have: " + this.experienceFactoryMap.toString() + "): " + compTypeToSearch);
        }
        Factory<Experience> fac = this.experienceFactoryMap.get(compTypeToSearch);
        retval = fac.create(adaptable);
        return retval;
    }

    @Override
    public Touchpoint makeTouchpoint(Resource adaptable) {
        if (adaptable == null) {
            throw new NullPointerException("Null passed as Resource adaptable.");
        }
        Touchpoint retval = null;
        String compTypeToSearch = this.extractCompType(adaptable);
        if (compTypeToSearch == null) {
            throw new RuntimeException("Given resource doesn't have a resource type: " + adaptable.getPath());
        }
        if (!this.touchpointFactoryMap.containsKey(compTypeToSearch)) {
            throw new RuntimeException("Unkown resourceType (misuse of the the class? We have: " + this.touchpointFactoryMap.toString() + "): " + compTypeToSearch);
        }
        Factory<Touchpoint> fac = this.touchpointFactoryMap.get(compTypeToSearch);
        retval = fac.create(adaptable);
        return retval;
    }

    private String extractCompType(Resource adaptable) {
        NormalizedResource nr = new NormalizedResource();
        nr.setResource(adaptable);
        String retval = null;
        if (nr.getContentVals() != null) {
            retval = (String)((Object)nr.getContentVals().get("sling:resourceType", String.class));
        }
        if (retval == null) {
            log.warn("Cannot make an object because resource {} doesn't have content node or resourceType.", (Object)adaptable);
        }
        return retval;
    }

    public String toString() {
        return super.toString() + "/id:" + this.getPluginId();
    }

    public static interface Factory<T> {
        public T create(Resource var1);
    }
}

