/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.sort;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.oak.commons.FileIOUtils;
import org.apache.jackrabbit.oak.commons.sort.EscapeUtils;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringSort
implements Iterable<String>,
Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int BATCH_SIZE = 2048;
    private final int overflowToDiskThreshold;
    private final Comparator<String> comparator;
    private final List<String> ids = Lists.newArrayList();
    private long size;
    private final List<String> inMemBatch = Lists.newArrayList();
    private boolean useFile;
    private PersistentState persistentState;

    public StringSort(int overflowToDiskThreshold, Comparator<String> comparator) {
        this.overflowToDiskThreshold = overflowToDiskThreshold;
        this.comparator = comparator;
    }

    public void add(String id) throws IOException {
        if (this.useFile) {
            this.addToBatch(id);
        } else {
            this.ids.add(id);
            if (this.ids.size() >= this.overflowToDiskThreshold) {
                this.flushToFile(this.ids);
                this.useFile = true;
                this.log.debug("In memory buffer crossed the threshold of {}. Switching to filesystem [{}] to manage the state", (Object)this.overflowToDiskThreshold, (Object)this.persistentState);
            }
        }
        ++this.size;
    }

    public void sort() throws IOException {
        if (this.useFile) {
            this.flushToFile(this.inMemBatch);
            this.persistentState.sort();
        } else {
            Collections.sort(this.ids, this.comparator);
        }
    }

    public Iterator<String> getIds() throws IOException {
        if (this.useFile) {
            return this.persistentState.getIterator();
        }
        return this.ids.iterator();
    }

    public long getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public boolean usingFile() {
        return this.useFile;
    }

    @Override
    public void close() throws IOException {
        if (this.persistentState != null) {
            this.persistentState.close();
        }
    }

    @Override
    public Iterator<String> iterator() {
        try {
            return this.getIds();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addToBatch(String id) throws IOException {
        this.inMemBatch.add(id);
        if (this.inMemBatch.size() >= 2048) {
            this.flushToFile(this.inMemBatch);
        }
    }

    private void flushToFile(List<String> ids) throws IOException {
        BufferedWriter w = this.getPersistentState().getWriter();
        for (String id : ids) {
            w.write(EscapeUtils.escapeLineBreak(id));
            w.newLine();
        }
        ids.clear();
    }

    private PersistentState getPersistentState() {
        if (this.persistentState == null) {
            this.persistentState = new PersistentState(this.comparator);
        }
        return this.persistentState;
    }

    private static class CloseableIterator
    extends LineIterator
    implements Closeable {
        public CloseableIterator(Reader reader) throws IllegalArgumentException {
            super(reader);
        }

        @Override
        public String next() {
            return EscapeUtils.unescapeLineBreaks(super.next());
        }
    }

    private static class PersistentState
    implements Closeable {
        private static final int TEMP_DIR_ATTEMPTS = 10000;
        private final Charset charset = Charsets.UTF_8;
        private final File workDir;
        private final Comparator<String> comparator;
        private File idFile;
        private File sortedFile;
        private BufferedWriter writer;
        private List<CloseableIterator> openedIterators = Lists.newArrayList();

        public PersistentState(Comparator<String> comparator) {
            this(comparator, PersistentState.createTempDir("oak-sorter-"));
        }

        public PersistentState(Comparator<String> comparator, File workDir) {
            this.workDir = workDir;
            this.comparator = FileIOUtils.lineBreakAwareComparator(comparator);
        }

        public BufferedWriter getWriter() throws FileNotFoundException {
            if (this.idFile == null) {
                this.idFile = new File(this.workDir, "strings.txt");
                this.sortedFile = new File(this.workDir, "strings-sorted.txt");
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.idFile), this.charset));
            }
            return this.writer;
        }

        public void sort() throws IOException {
            this.closeWriter();
            List<File> sortedFiles = ExternalSort.sortInBatch(this.idFile, this.comparator, 1024, 0x800000L, this.charset, this.workDir, true);
            ExternalSort.mergeSortedFiles(sortedFiles, this.sortedFile, this.comparator, this.charset, true);
        }

        public Iterator<String> getIterator() throws IOException {
            CloseableIterator itr = new CloseableIterator(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.sortedFile), this.charset)));
            this.openedIterators.add(itr);
            return itr;
        }

        public String toString() {
            return "PersistentState : workDir=" + this.workDir.getAbsolutePath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ArrayList<Closeable> closer = new ArrayList<Closeable>();
            try {
                closer.add(0, new Closeable(){

                    @Override
                    public void close() throws IOException {
                        FileUtils.deleteDirectory(workDir);
                    }
                });
                closer.add(0, this.writer);
                for (CloseableIterator citr : this.openedIterators) {
                    closer.add(0, citr);
                }
            }
            finally {
                PersistentState.closeAll(closer);
            }
        }

        private void closeWriter() throws IOException {
            this.writer.close();
        }

        private static File createTempDir(String prefix) {
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            String baseName = System.currentTimeMillis() + "-";
            for (int counter = 0; counter < 10000; ++counter) {
                File tempDir = new File(baseDir, prefix + baseName + counter);
                if (!tempDir.mkdir()) continue;
                return tempDir;
            }
            throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + "9999)");
        }

        private static void closeAll(List<Closeable> closer) throws IOException {
            IOException ioex = null;
            for (Closeable c : closer) {
                block3: {
                    try {
                        c.close();
                    }
                    catch (IOException mostlyIgnored) {
                        if (ioex != null) break block3;
                        ioex = mostlyIgnored;
                    }
                }
                if (ioex == null) continue;
                throw ioex;
            }
        }
    }
}

