/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.plugins.version.ReadOnlyVersionManager;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.plugins.version.VersionExceptionCode;
import org.apache.jackrabbit.oak.plugins.version.VersionSelector;
import org.apache.jackrabbit.oak.plugins.version.VersionableState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteVersionManager
extends ReadOnlyVersionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteVersionManager.class);
    private final NodeBuilder versionStorageNode;
    private final NodeBuilder workspaceRoot;
    private final TypePredicate isVersion;
    private ReadOnlyNodeTypeManager ntMgr;

    public ReadWriteVersionManager(NodeBuilder versionStorageNode, NodeBuilder workspaceRoot) {
        this.versionStorageNode = Preconditions.checkNotNull(versionStorageNode);
        this.workspaceRoot = Preconditions.checkNotNull(workspaceRoot);
        this.isVersion = new TypePredicate(workspaceRoot.getNodeState(), "nt:version");
    }

    @Override
    @NotNull
    protected Tree getVersionStorage() {
        return TreeFactory.createReadOnlyTree(this.versionStorageNode.getNodeState());
    }

    @Override
    @NotNull
    protected Root getWorkspaceRoot() {
        return RootFactory.createReadOnlyRoot(this.workspaceRoot.getNodeState());
    }

    @Override
    @NotNull
    protected ReadOnlyNodeTypeManager getNodeTypeManager() {
        if (this.ntMgr == null) {
            this.ntMgr = ReadOnlyNodeTypeManager.getInstance(this.getWorkspaceRoot(), NamePathMapper.DEFAULT);
        }
        return this.ntMgr;
    }

    @NotNull
    public NodeBuilder getOrCreateVersionHistory(@NotNull NodeBuilder versionable, @NotNull Map<String, Object> infoMap) {
        Preconditions.checkNotNull(versionable);
        String vUUID = Utils.uuidFromNode(versionable);
        String relPath = this.getVersionHistoryPath(vUUID);
        NodeBuilder node = this.versionStorageNode;
        Iterator<String> it = PathUtils.elements(relPath).iterator();
        while (it.hasNext()) {
            String name = it.next();
            if ((node = node.child(name)).hasProperty("jcr:primaryType")) continue;
            String nt = it.hasNext() ? "rep:versionStorage" : "nt:versionHistory";
            node.setProperty("jcr:primaryType", nt, Type.NAME);
        }
        Object copiedFrom = infoMap.get("jcr:copiedFrom");
        if (copiedFrom != null) {
            node.setProperty("jcr:copiedFrom", copiedFrom.toString(), Type.WEAKREFERENCE);
        }
        if (!node.hasChildNode("jcr:rootVersion")) {
            node.setProperty("jcr:versionableUuid", vUUID, Type.STRING);
            node.setProperty("jcr:uuid", UUIDUtils.generateUUID(), Type.STRING);
            NodeBuilder vLabels = node.child("jcr:versionLabels");
            vLabels.setProperty("jcr:primaryType", "nt:versionLabels", Type.NAME);
            this.createRootVersion(node, versionable);
        } else if (!versionable.hasProperty("jcr:versionHistory")) {
            this.connectHistory(node.getChildNode("jcr:rootVersion"), Utils.uuidFromNode(node), versionable);
        }
        return node;
    }

    void removeVersion(String versionRelPath) throws CommitFailedException {
        PropertyBuilder<String> pb;
        String historyRelPath = PathUtils.getAncestorPath(versionRelPath, 1);
        String versionName = Text.getName(versionRelPath);
        NodeBuilder vh = this.resolve(this.versionStorageNode, historyRelPath);
        if ("jcr:rootVersion".equals(versionName)) {
            String msg = "Removal of root version not allowed.";
            throw new CommitFailedException("Version", VersionExceptionCode.ROOT_VERSION_REMOVAL.ordinal(), msg);
        }
        NodeBuilder versionNode = vh.getChildNode(versionName);
        String versionId = versionNode.getProperty("jcr:uuid").getValue(Type.STRING);
        for (String label : this.getVersionLabels(historyRelPath, versionId)) {
            this.removeVersionLabel(historyRelPath, label);
        }
        PropertyState successorIds = versionNode.getProperty("jcr:successors");
        PropertyState predecessorIds = versionNode.getProperty("jcr:predecessors");
        for (String succId : successorIds.getValue(Type.REFERENCES)) {
            NodeBuilder successor = this.getVersionById(vh, succId);
            if (successor == null) {
                LOG.info("removeVersion : successor not found with uuid: {}, historyRelPath: {}, versionNode: {}, versionHistory: {}", succId, historyRelPath, ReadWriteVersionManager.asLoggableString(versionNode), ReadWriteVersionManager.asLoggableString(vh));
                continue;
            }
            pb = PropertyBuilder.array(Type.REFERENCE);
            pb.setName("jcr:predecessors");
            PropertyState successorsPredecessors = successor.getProperty("jcr:predecessors");
            if (successorsPredecessors == null) {
                LOG.info("removeVersion : successor has no jcr:predecessors property, uuid: {}, historyRelPath: {}, versionNode: {}, successor: {}, versionHistory: {}", succId, historyRelPath, ReadWriteVersionManager.asLoggableString(versionNode), ReadWriteVersionManager.asLoggableString(successor), ReadWriteVersionManager.asLoggableString(vh));
            } else {
                pb.setValues(successorsPredecessors.getValue(Type.REFERENCES));
            }
            pb.removeValue(versionId);
            pb.addValues(predecessorIds.getValue(Type.REFERENCES));
            successor.setProperty(pb.getPropertyState());
        }
        for (String predId : predecessorIds.getValue(Type.REFERENCES)) {
            NodeBuilder predecessor = this.getVersionById(vh, predId);
            if (predecessor == null) {
                LOG.info("removeVersion : predecessor not found with uuid: {}, historyRelPath: {}, versionNode: {}, versionHistory: {}", predId, historyRelPath, ReadWriteVersionManager.asLoggableString(versionNode), ReadWriteVersionManager.asLoggableString(vh));
                continue;
            }
            pb = PropertyBuilder.array(Type.REFERENCE);
            pb.setName("jcr:successors");
            PropertyState predecessorsSuccessors = predecessor.getProperty("jcr:successors");
            if (predecessorsSuccessors == null) {
                LOG.info("removeVersion : predecessor has no jcr:successors property, uuid: {}, historyRelPath: {}, versionNode: {}, predecessor: {}, versionHistory: {}", predId, historyRelPath, ReadWriteVersionManager.asLoggableString(versionNode), ReadWriteVersionManager.asLoggableString(predecessor), ReadWriteVersionManager.asLoggableString(vh));
            } else {
                pb.setValues(predecessorsSuccessors.getValue(Type.REFERENCES));
            }
            pb.removeValue(versionId);
            pb.addValues(successorIds.getValue(Type.REFERENCES));
            predecessor.setProperty(pb.getPropertyState());
        }
        versionNode.remove();
    }

    private static String asLoggableString(NodeBuilder nb) {
        try {
            StringBuilder sb = new StringBuilder();
            boolean empty = true;
            for (PropertyState propertyState : nb.getProperties()) {
                if (empty) {
                    empty = false;
                } else {
                    sb.append(", ");
                }
                sb.append(propertyState);
            }
            return "{ " + sb + " }";
        }
        catch (Exception e) {
            return "{ exception: " + e + ", message: " + e.getMessage() + " }";
        }
    }

    public void checkout(NodeBuilder versionable) {
        versionable.setProperty("jcr:isCheckedOut", true, Type.BOOLEAN);
        PropertyState baseVersion = versionable.getProperty("jcr:baseVersion");
        List<String> predecessors = Collections.singletonList(baseVersion.getValue(Type.REFERENCE));
        versionable.setProperty("jcr:predecessors", predecessors, Type.REFERENCES);
    }

    public void checkin(@NotNull NodeBuilder versionable) throws CommitFailedException {
        NodeBuilder history = this.getOrCreateVersionHistory(versionable, Collections.emptyMap());
        this.createVersion(history, versionable);
    }

    public void restore(@NotNull NodeBuilder versionable, @NotNull String versionUUID, @Nullable VersionSelector selector) throws CommitFailedException {
        String versionName;
        String versionPath = this.getIdentifierManager().getPath(versionUUID);
        NodeBuilder history = this.getOrCreateVersionHistory(versionable, Collections.emptyMap());
        NodeBuilder version = null;
        if (versionPath != null && history.hasChildNode(versionName = PathUtils.getName(versionPath))) {
            version = history.getChildNode(versionName);
        }
        if (version == null) {
            throw new CommitFailedException("Version", VersionExceptionCode.NO_SUCH_VERSION.ordinal(), "The VersionHistory with UUID: " + Utils.uuidFromNode(versionable) + " does not have a Version with UUID: " + versionUUID);
        }
        VersionableState versionableState = VersionableState.forRestore(version, history, versionable, this, this.ntMgr);
        versionableState.restore(selector);
    }

    void restore(@NotNull String historyIdentifier, @NotNull VersionSelector selector, @NotNull NodeBuilder versionable) throws CommitFailedException, RepositoryException {
        String historyPath = this.getIdentifierManager().getPath(historyIdentifier);
        String historyRelPath = PathUtils.relativize("/jcr:system/jcr:versionStorage", historyPath);
        NodeBuilder history = this.resolve(this.versionStorageNode, historyRelPath);
        Preconditions.checkState(history.exists(), "Version history does not exist: " + historyPath);
        NodeBuilder version = selector.select(history);
        if (version == null) {
            throw new CommitFailedException("Version", VersionExceptionCode.NO_VERSION_TO_RESTORE.ordinal(), "VersionSelector did not select any version from history: " + historyPath);
        }
        String versionableUUUID = history.getProperty("jcr:versionableUuid").getValue(Type.STRING);
        versionable.setProperty("jcr:uuid", versionableUUUID, Type.STRING);
        this.restore(versionable, Utils.uuidFromNode(version), selector);
    }

    public void removeVersionLabel(@NotNull String historyRelPath, @NotNull String label) throws CommitFailedException {
        NodeBuilder labels = this.getVersionLabelsFor(Preconditions.checkNotNull(historyRelPath));
        if (!labels.hasProperty(Preconditions.checkNotNull(label))) {
            throw new CommitFailedException("Version", VersionExceptionCode.NO_SUCH_VERSION_LABEL.ordinal(), "Version label " + label + " does not exist on this version history");
        }
        labels.removeProperty(label);
    }

    void removeEmptyHistory(@NotNull NodeState versionable) {
        NodeBuilder history = this.getVersionHistory(versionable);
        if (this.isEmptyHistory(history.getNodeState())) {
            history.remove();
        }
    }

    @NotNull
    private NodeBuilder resolve(NodeBuilder node, String relPath) {
        Preconditions.checkArgument(!PathUtils.isAbsolute(relPath), "Not a relative path");
        for (String name : PathUtils.elements(relPath)) {
            node = node.getChildNode(name);
        }
        return node;
    }

    private void createRootVersion(@NotNull NodeBuilder vHistory, @NotNull NodeBuilder versionable) {
        String versionUUID = UUIDUtils.generateUUID();
        NodeBuilder version = vHistory.child("jcr:rootVersion");
        version.setProperty("jcr:uuid", versionUUID, Type.STRING);
        version.setProperty("jcr:primaryType", "nt:version", Type.NAME);
        version.setProperty("jcr:created", ISO8601.format(Calendar.getInstance()), Type.DATE);
        version.setProperty("jcr:predecessors", Collections.emptyList(), Type.REFERENCES);
        version.setProperty("jcr:successors", Collections.emptyList(), Type.REFERENCES);
        VersionableState.fromVersion(version, vHistory, versionable, this, this.getNodeTypeManager());
        versionable.setProperty("jcr:isCheckedOut", true, Type.BOOLEAN);
        versionable.setProperty("jcr:versionHistory", Utils.uuidFromNode(vHistory), Type.REFERENCE);
        versionable.setProperty("jcr:baseVersion", versionUUID, Type.REFERENCE);
        versionable.setProperty("jcr:predecessors", Collections.singletonList(versionUUID), Type.REFERENCES);
    }

    private void createVersion(@NotNull NodeBuilder vHistory, @NotNull NodeBuilder versionable) throws IllegalArgumentException, CommitFailedException {
        if (!vHistory.hasChildNode("jcr:rootVersion")) {
            this.createRootVersion(vHistory, versionable);
            return;
        }
        Preconditions.checkState(versionable.hasProperty("jcr:predecessors"));
        PropertyState state = versionable.getProperty("jcr:predecessors");
        ImmutableList<String> predecessors = ImmutableList.copyOf(state.getValue(Type.REFERENCES));
        NodeBuilder version = vHistory.child(this.calculateVersion(vHistory, versionable));
        String versionUUID = UUIDUtils.generateUUID();
        version.setProperty("jcr:uuid", versionUUID, Type.STRING);
        version.setProperty("jcr:primaryType", "nt:version", Type.NAME);
        version.setProperty("jcr:created", ISO8601.format(Calendar.getInstance()), Type.DATE);
        version.setProperty("jcr:predecessors", predecessors, Type.REFERENCES);
        version.setProperty("jcr:successors", Collections.emptyList(), Type.REFERENCES);
        for (String id : predecessors) {
            String name = PathUtils.getName(this.getIdentifierManager().getPath(id));
            NodeBuilder predecessor = vHistory.getChildNode(name);
            state = predecessor.getProperty("jcr:successors");
            if (state == null) {
                throw new IllegalStateException("Missing jcr:successors property on " + predecessor);
            }
            HashSet<String> refs = Sets.newHashSet(state.getValue(Type.REFERENCES));
            refs.add(versionUUID);
            predecessor.setProperty("jcr:successors", refs, Type.REFERENCES);
        }
        VersionableState versionableState = VersionableState.fromVersion(version, vHistory, versionable, this, this.getNodeTypeManager());
        versionableState.create();
        versionable.setProperty("jcr:isCheckedOut", false, Type.BOOLEAN);
        versionable.setProperty("jcr:versionHistory", Utils.uuidFromNode(vHistory), Type.REFERENCE);
        versionable.setProperty("jcr:baseVersion", versionUUID, Type.REFERENCE);
        versionable.setProperty("jcr:predecessors", Collections.emptyList(), Type.REFERENCES);
    }

    private void connectHistory(@NotNull NodeBuilder rootVersion, @NotNull String vHistoryUUID, @NotNull NodeBuilder versionable) {
        String rootVersionUUID = Utils.uuidFromNode(rootVersion);
        versionable.setProperty("jcr:isCheckedOut", true, Type.BOOLEAN);
        versionable.setProperty("jcr:versionHistory", vHistoryUUID, Type.REFERENCE);
        versionable.setProperty("jcr:baseVersion", rootVersionUUID, Type.REFERENCE);
        versionable.setProperty("jcr:predecessors", Collections.singleton(rootVersionUUID), Type.REFERENCES);
    }

    protected String calculateVersion(@NotNull NodeBuilder history, @NotNull NodeBuilder versionable) throws IllegalStateException {
        PropertyState predecessors = versionable.getProperty("jcr:predecessors");
        if (predecessors == null || predecessors.count() == 0) {
            String message = predecessors == null ? "Mandatory jcr:predecessors property missing on node " + Utils.uuidFromNode(versionable) : "Mandatory jcr:predecessors property is empty on node " + Utils.uuidFromNode(versionable);
            throw new IllegalStateException(message);
        }
        String best = null;
        for (String id : predecessors.getValue(Type.REFERENCES)) {
            String name = PathUtils.getName(this.getIdentifierManager().getPath(id));
            if (best != null && name.length() >= best.length()) continue;
            best = name;
        }
        if (best == null) {
            String message = "Could not find 'best' predecessor node for " + Utils.uuidFromNode(versionable);
            throw new IllegalStateException(message);
        }
        Object versionName = best;
        int pos = ((String)versionName).lastIndexOf(46);
        if (pos > 0) {
            Object newVersionName = ((String)versionName).substring(0, pos + 1) + (Integer.parseInt(((String)versionName).substring(pos + 1)) + 1);
            while (history.hasChildNode((String)newVersionName)) {
                newVersionName = versionName = (String)versionName + ".0";
            }
            return newVersionName;
        }
        Preconditions.checkState(history.hasChildNode("jcr:rootVersion"));
        NodeBuilder v = history.getChildNode("jcr:rootVersion");
        return String.valueOf(v.getProperty("jcr:successors").count() + 1) + ".0";
    }

    private NodeBuilder getVersionLabelsFor(String historyRelPath) throws CommitFailedException {
        NodeBuilder history = this.resolve(this.versionStorageNode, historyRelPath);
        if (!history.exists()) {
            throw new CommitFailedException("Version", VersionExceptionCode.UNEXPECTED_REPOSITORY_EXCEPTION.ordinal(), "Version history does not exist: " + PathUtils.concat("/jcr:system/jcr:versionStorage", historyRelPath));
        }
        return history.child("jcr:versionLabels");
    }

    @NotNull
    private Iterable<String> getVersionLabels(@NotNull String historyRelPath, @NotNull String versionId) throws CommitFailedException {
        ArrayList<String> labels = new ArrayList<String>();
        NodeBuilder labelNode = this.getVersionLabelsFor(historyRelPath);
        for (PropertyState propertyState : labelNode.getProperties()) {
            if (Type.REFERENCE != propertyState.getType() || !versionId.equals(propertyState.getValue(Type.REFERENCE))) continue;
            labels.add(propertyState.getName());
        }
        return labels;
    }

    @Nullable
    private NodeBuilder getVersionById(@NotNull NodeBuilder vhBuilder, @NotNull String versionId) {
        for (String childName : vhBuilder.getChildNodeNames()) {
            NodeBuilder nb = vhBuilder.getChildNode(childName);
            PropertyState uuid = nb.getProperty("jcr:uuid");
            if (uuid == null || !versionId.equals(uuid.getValue(Type.STRING))) continue;
            return nb;
        }
        return null;
    }

    @NotNull
    private NodeBuilder getVersionHistory(@NotNull NodeState versionable) {
        Preconditions.checkNotNull(versionable);
        String vUUID = Utils.uuidFromNode(versionable);
        String relPath = this.getVersionHistoryPath(vUUID);
        NodeBuilder node = this.versionStorageNode;
        for (String name : PathUtils.elements(relPath)) {
            if ((node = node.getChildNode(name)).exists()) continue;
            throw new IllegalArgumentException("No version history for this node");
        }
        return node;
    }

    private boolean isEmptyHistory(NodeState versionHistory) {
        for (ChildNodeEntry childNodeEntry : versionHistory.getChildNodeEntries()) {
            String string = childNodeEntry.getName();
            NodeState node = childNodeEntry.getNodeState();
            if ("jcr:rootVersion".equals(string) || !this.isVersion.test(node)) continue;
            return false;
        }
        NodeState labels = versionHistory.getChildNode("jcr:versionLabels");
        for (PropertyState propertyState : labels.getProperties()) {
            if (propertyState.getType() != Type.REFERENCE) continue;
            return false;
        }
        return true;
    }
}

