/*
 *
 *	File: TokenType.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.postscript;

/**
 * An enum representing the type of tokens recognized by the Tokenizer class.
 *
 * <h4>Synchronization</h4>
 * 
 * This class is immutable after contruction and contains no mutable
 * static data. It is therefore threadsafe.
 */
final public class TokenType {
    private TokenType(String description) {s = description;}
    
    private String s;
    
    public static final TokenType kOPERATOR = new TokenType("operator");
    public static final TokenType kINTEGER = new TokenType("integer");
    public static final TokenType kREAL = new TokenType("real");
    public static final TokenType kLITERAL = new TokenType("literal");
    public static final TokenType kIMMEDIATE = new TokenType("immediate");
    public static final TokenType kSTRING = new TokenType("string");
    public static final TokenType kHEXSTRING = new TokenType("hexstring");
    public static final TokenType kASCII85 = new TokenType("ascii85");
    public static final TokenType kDICTIONARY = new TokenType("dictionary");
    public static final TokenType kARRAY = new TokenType("array");
    public static final TokenType kPROCEDURE = new TokenType("procedure");
    
    /**
     * @return a String describing this object
     */
    public String toString() { return s;}
    
}