/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.granite.socketio;

import java.io.IOException;

import javax.annotation.Nonnull;

import org.apache.sling.commons.json.JSONArray;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Socket.IO ack is used to signal the {@link com.adobe.granite.socketio.SocketIOSocketListener} when the client
 * requests and ack packet.
 */
@ProviderType
public interface SocketIOAck {

    /**
     * Checks if this ack is already handled.
     * @return {@code true} if ack was sent, {@code false} otherwise.
     */
    boolean isAcknowledged();

    /**
     * Sends the ack data back to the client.
     *
     * @param arguments ack data.
     * @throws java.io.IOException if an error occurs
     */
    void send(@Nonnull Object ... arguments) throws IOException;

    /**
     * Sends the ack data back to the client.
     *
     * @param arguments ack data.
     * @throws java.io.IOException if an error occurs
     */
    void send(@Nonnull JSONArray arguments) throws IOException;


}