/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.taskmanagement;

/**
 * TaskNotFoundException represents an error condition where a task could not
 * be located for a specific task ID.
 */
public class TaskNotFoundException extends TaskManagerException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = -7205622205320640903L;

    /**
     * Creates a new instance of TaskNotFoundException.
     * @param aTaskId String containing the id of the task which could not be located.
     */
    public TaskNotFoundException(final String aTaskId) {
        super("Task not found");
        this.setTaskId(aTaskId);
    }
}
