/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow;

import com.adobe.granite.workflow.exec.Workflow;

import java.util.List;

/**
 * The <code>PayloadMap</code> is listening to workflow events (started,
 * terminated, completed and manages a payload map (only JCR_PATH payloads)
 * in order to enable quick lookup for nodes/resources which might be subject
 * of a workflow.
 */
public interface PayloadMap {
    String TYPE_JCR_PATH = "JCR_PATH";
    String TYPE_JCR_UUID = "JCR_UUID";

    /**
     * Checks whether a <code>JCR_PATH</code>based path is subject of a running <code>
     * {@link com.adobe.granite.workflow.exec.Workflow} instance</code>.
     *
     * @param path path to check
     * @param excludeSystemWorkflows set to <code>true</code> to exclude system
     *        workflows from the evaluation
     *
     * @return <code>true</code> if <code>JCR_PATH</code>based path is subject of a
     * running workflow
     */
    boolean isInWorkflow(String path, boolean excludeSystemWorkflows);

    /**
     * All <code>{@link com.adobe.granite.workflow.exec.Workflow} instances</code> are
     * returned.
     *
     * @param path node path
     * @param excludeSystemWorkflows set to <code>true</code> to exclude system
     *        workflows from the evaluation
     *
     * @return the list of <code>{@link com.adobe.granite.workflow.exec.Workflow} instances</code>
     * or an empty list is returned
     */
    public List<Workflow> getWorkflowInstances(String path, boolean excludeSystemWorkflows);
}
