/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.predicate;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.collections.Predicate;
import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.commons.predicate.AbstractNodePredicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

/**
 * Predicate used to filter Hierarchy nodes BUT not nt:file nodes.
 */
@Component(metatype = false)
@Service(Predicate.class)
@Properties({
        @Property(name = "predicate.name", value = "hierarchyNotFile")
})
public class HierarchyNotFilePredicate extends AbstractNodePredicate implements Predicate {

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is nt:hierarchyNode but not nt:file
     */
    public boolean evaluate(Node node) throws RepositoryException {
        return node.isNodeType(JcrConstants.NT_HIERARCHYNODE)
                && !node.isNodeType(JcrConstants.NT_FILE);
    }

}

