/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.job;

import com.day.cq.workflow.exec.WorkItem;

/**
 * The <code>AbsoluteTimeoutHandler</code> is kind of a marker interface for
 * absolute timeouts (timeout is happening at a specific date)
 */
public interface AbsoluteTimeoutHandler {
    /**
     * metadata name for the absolute timeout time
     */
    static final String ABS_TIME = "absoluteTime";

    /**
     * Returns the timeout time in ms.
     *
     * @param item workitem
     *
     * @return timeout time/date in ms in case the time/date is set
     * otherwise <code>-1</code>
     */
    long getTimeoutDate(WorkItem item);
}
