/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <code>MutableMediaLink</code>...
 */
@ProviderType
public interface MutableMediaLink extends MediaLink {

    MutableMediaLink setURL(String url);

    MutableMediaLink setWidth(int width);

    MutableMediaLink setHeight(int height);

    MutableMediaLink setDuration(int duration);

    /**
     * Sets the property with the give name and value.
     * @param name name of the property
     * @param value value of the property
     * @return this object for chaining.
     * @since 0.0.10
     */
    MutableMediaLink setProperty(String name, Object value);

}