/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api.description;


import org.osgi.annotation.versioning.ProviderType;

import com.adobe.granite.haf.api.ModelPathMapper;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/**
 * A description of all collected metadata about a model.
 */
@ProviderType
public interface ModelDescription {
    /**
     * Gets the ModelPathMapper used by the model.
     * @return The ModelPathMapper.
     */
    @Nonnull
    ModelPathMapper getMapper();

    /**
     * Gets the model's category.
     * @return The model category.
     */
    @Nonnull
    String getCategory();

    /**
     * Gets the model object.
     * @return The model
     */
    Object getModel();

    /**
     * Get the model types, as defined by the type property on the ApiModel annotation.
     * @return The array of model types.
     */
    @Nonnull
    String[] getModelTypes();

    /**
     * Get the value to use as the next offset for paginated requests.  This value will be null until after the
     * getEntities method is called since entities are loaded lazily.
     * @return The next offset value.
     */
    @CheckForNull
    String getNextOffsetValue();

    /**
     * Get the count of entities to be serialized into the response.  This value will be 0 until after the getEntities
     * method is called since entities are loaded lazily.
     * @return The entity count.
     */
    int getEntityCount();

    /**
     * Get the descriptions of the actions defined in the model.
     * @return The action descriptions
     */
    @Nonnull
    Iterable<ActionDescription> getActions();

    /**
     * Get the descriptions of the links defined in the model.
     * @return The link descriptions.
     */
    @Nonnull
    Iterable<LinkDescription> getLinks();

    /**
     * Get the descriptions of the entities defined in the model.
     * @return The entity descriptions.
     */
    @Nonnull
    Iterable<EntityDescription> getEntities();

    /**
     * Get the descriptions of properties defined in the model.
     * @return The property descriptions.
     */
    @Nonnull
    Iterable<PropertyDescription> getProperties();

    /**
     * Get the description for a specific property defined in the model by name.
     * @param name The property name.
     * @return The property description.
     */
    @CheckForNull
    PropertyDescription getProperty(String name);

    /**
     * Get the descriptions of the headers defined in the model.
     * @return The header descriptions.
     */
    @Nonnull
    Iterable<HeaderDescription> getHeaders();
}
