package com.adobe.internal.io;

import java.util.ArrayList;

/**
 * A {@link com.adobe.internal.io.ByteReader ByteReader} that wraps an
 * array of bytes.
 *
 * This class is <b>not</b> threadsafe.  It is not safe to pass an instance of this class
 * to multiple threads.  It is not safe to pass an instance of this class to multiple users even
 * if in the same thread.
 */
public class ByteArrayByteReader extends ByteReaderWrapperImpl
{
	/**
	 * Create a new ByteArrayByteReader with the given byte array.
	 * The buffer is not copied.
	 * @param buffer the byte array to use.
	 */
	public ByteArrayByteReader(byte[] buffer)
	{
		this(buffer, 0, buffer.length);
	}
	
	/**
	 * Create a new ByteArrayByteReader with the given byte array.
	 * The buffer is not copied and only bytes beginning at the <code>offset</code> and
	 * within <code>length</code> bytes of the <code>offset</code> can be accessed.
	 * @param buffer the byte to use.
	 * @param offset the offset in the buffer to read the first byte from.
	 * @param length the maximum number of bytes to read from this buffer.
	 */
	public ByteArrayByteReader(byte[] buffer, int offset, int length)
	{
		super(new ByteArrayByteWriter(buffer, offset, length));
	}
	
	/**
	 * Create a new ByteArrayByteReader with the given buffer array.
	 * The data is not copied.
	 * @param bufferArray ArrayList of byte[] buffers to use.
	 * @param length the TOTAL length of all buffers in use.
	 */
	public ByteArrayByteReader(ArrayList bufferArray, int length)
	{
		super(new ByteArrayByteWriter(bufferArray, length));
	}	
}
