/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2006, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be coveredby   */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.msg;

/**
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public final class NCInt extends NCNumber
{
	// --------------------------------------------------------------------------- Private Variables

	/** int value */
	private final int value;

	// -------------------------------------------------------------------------- Public Constructor

	/**
	 * Public constructor
	 * 
	 * @param value integer value
	 */
	public NCInt(int value)
	{
		this.value = value;
	}

	// ------------------------------------------------------------------------------ Public Methods

	@Override
	public double doubleValue()
	{
		return value;
	}

	@Override
	public int intValue()
	{
		return value;
	}

	@Override
	public long longValue()
	{
		return value;
	}

	@Override
	public int getType()
	{
		return NCType.TYPE_INTEGER;
	}

	@Override
	public int hashCode()
	{
		return value;
	}

	@Override
	public String toString()
	{
		return "NCInt <" + value + ">";
	}
}