/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


import com.adobe.xfa.ut.FindBugsSuppress;


/*
 * Using the 'namespace' keyword is a much
 * better way to accomplish this, but that C++ keyword is not supported across
 * all platforms.
 *
 * <br/>
 * Application developers will frequently write code which compares class names
 * to strings in this namespace.  If we performed a full string comparison
 * every time, there could be performance problems.  Rather, the application
 * developer should be aware that some strings can be compared for [in]equality
 * by checking to see if they share the same data.
 * The application developer should
 * assume that strings returned by the Node.getClassName() are the same
 * strings which are stored in this namespace. So, rather than write code which
 * would compare these strings, developers should write code such as:
 * <pre>
 * Node n = x.getNodes()[1];
 * if (n.getClassName().SharesImpl(XFA::fontTag()))
 * ...
 * </pre>
 * There is a convenience method in <code>Obj</code> that
 * allows users to reduce this syntax to:
 * <pre>
 * Node n = x.getNodes()[1];
 * if (n.isSameClass(XFA::fontTag()))
 * ...
 * </pre>
 * or this version which takes another <code>Obj</code> as a parameter:
 * <pre>
 * NodeList nodes = x.getNodes();
 * if (nodes[1].isSameClass(nodes[2]))
 * ...
 * </pre>
 * Note that it is not valid to use SharesImpl() to compare class names with
 * strings which don't originate in the XFA namespace. e.g.
 * <pre>
 * if (nodes[1].isSameClass(jfString(font")))
 * </pre>
 * will <b>not</b> work.
 *
 */

/**
 * A class to define the namespace for all XFA elements and attributes.
 */
public final class XFA {

	/**
	 * The #text node atom.
	 */
	public static final String TEXTNODE = "#text";
	/**
	 * The #xHTML (previously named htmlText) node atom.
	 */
	public static final String RICHTEXTNODE = "#xHTML";
	/**
	 * The #xml node atom.
	 */
	public static final String XMLMULTISELECTNODE = "#xml";
	/**
	 * The CR node atom.
	 */
	public static final String CR = "CR";
	/**
	 * The ESC node atom.
	 */
	public static final String ESC = "ESC";
	/**
	 * The FF node atom.
	 */
	public static final String FF = "FF";
	/**
	 * The LF node atom.
	 */
	public static final String LF = "LF";
	/**
	 * The accessibleContent element atom.
	 */
	public static final String ACCESSIBLECONTENT = "accessibleContent";
	/**
	 * The acrobat element atom.
	 */
	public static final String ACROBAT = "acrobat";
	/**
	 * The acrobat7 element atom.
	 */
	public static final String ACROBAT7 = "acrobat7";
	/**
	 * The addFont element atom.
	 */
	public static final String ADDFONT = "addFont";
	/**
	 * The addSilentPrint element atom.
	 */
	public static final String ADDSILENTPRINT = "addSilentPrint";
	/**
	 * The addViewerPreferences element atom.
	 */
	public static final String ADDVIEWERPREFERENCES = "addViewerPreferences";
	/**
	 * The adjustData element atom.
	 */
	public static final String ADJUSTDATA = "adjustData";
	/**
	 * The adobe element atom.
	 */
	public static final String ADOBE = "adobe";
	/**
	 * The adobeExtensionLevel element atom.
	 */
	public static final String ADOBEEXTENSIONLEVEL = "adobeExtensionLevel";
	/**
	 * The agent element atom.
	 */
	public static final String AGENT = "agent";
	/**
	 * The alwaysEmbed element atom.
	 */
	public static final String ALWAYSEMBED = "alwaysEmbed";
	/**
	 * The amd element atom.
	 */
	public static final String AMD = "amd";
	/**
	 * The appearanceFilter element atom.
	 */
	public static final String APPEARANCEFILTER = "appearanceFilter";
	/**
	 * The arc element atom.
	 */
	public static final String ARC = "arc";
	/**
	 * The area element atom.
	 */
	public static final String AREA = "area";
	/**
	 * The assist element atom.
	 */
	public static final String ASSIST = "assist";
	/**
	 * The association element atom.
	 */
	public static final String ASSOCIATION = "association";
	/**
	 * The attributes element atom.
	 */
	public static final String ATTRIBUTES = "attributes";
	/**
	 * The barcode element atom.
	 */
	public static final String BARCODE = "barcode";
	/**
	 * The barcodeDefinition element atom.
	 */
	public static final String BARCODEDEFINITION = "barcodeDefinition";
	/**
	 * The barcodes element atom.
	 */
	public static final String BARCODES = "barcodes";
	/**
	 * The base element atom.
	 */
	public static final String BASE = "base";
	/**
	 * The batchOutput element atom.
	 */
	public static final String BATCHOUTPUT = "batchOutput";
	/**
	 * The behaviorOverride element atom.
	 */
	public static final String BEHAVIOROVERRIDE = "behaviorOverride";
	/**
	 * The binary element atom.
	 */
	public static final String BINARY = "binary";
	/**
	 * The bindItems element atom.
	 */
	public static final String BINDITEMS = "bindItems";
	/**
	 * The boolean element atom.
	 */
	public static final String BOOLEAN = "boolean";
	/**
	 * The border element atom.
	 */
	public static final String BORDER = "border";
	/**
	 * The button element atom.
	 */
	public static final String BUTTON = "button";
	/**
	 * The cache element atom.
	 */
	public static final String CACHE = "cache";
	/**
	 * The calculate element atom.
	 */
	public static final String CALCULATE = "calculate";
	/**
	 * The calendarSymbols element atom.
	 */
	public static final String CALENDARSYMBOLS = "calendarSymbols";// localeset
	/**
	 * The callXpr element atom.
	 */
	public static final String CALLXPR = "callXpr";
	/**
	 * The callback element atom.
	 */
	public static final String CALLBACK = "callback";
	/**
	 * The callout element atom.
	 */
	public static final String CALLOUT = "callout";
	/**
	 * The caption element atom.
	 */
	public static final String CAPTION = "caption";
	/**
	 * The catch element atom.
	 */
	public static final String CATCH = "catch";
	/**
	 * The certificate element atom.
	 */
	public static final String CERTIFICATE = "certificate";
	/**
	 * The certificates element atom.
	 */
	public static final String CERTIFICATES = "certificates";
	/**
	 * The charWidths element atom.
	 */
	public static final String CHARWIDTH = "charWidths";
	/**
	 * The checkButton element atom.
	 */
	public static final String CHECKBUTTON = "checkButton";
	/**
	 * The choiceList element atom.
	 */
	public static final String CHOICELIST = "choiceList";
	/**
	 * The color element atom.
	 */
	public static final String COLOR = "color";
	/**
	 * The comb element atom.
	 */
	public static final String COMB = "comb";
	/**
	 * The command element atom.
	 */
	public static final String COMMAND = "command";// datasource and xpr
	/**
	 * The common element atom.
	 */
	public static final String COMMON = "common";
	/**
	 * The compress element atom.
	 */
	public static final String COMPRESS = "compress";
	/**
	 * The compressObjectStream element atom.
	 */
	public static final String COMPRESSOBJECTSTREAM = "compressObjectStream";
	/**
	 * The compressLogicalStructure element atom.
	 */
	public static final String COMPRESSLOGICALSTRUCTURE = "compressLogicalStructure";
	/**
	 * The compression element atom.
	 */
	public static final String COMPRESSION = "compression";
	/**
	 * The config element atom.
	 */
	public static final String CONFIG = "config";
	/**
	 * The configurationKey element atom.
	 */
	public static final String CONFIGURATIONKEY = "configurationKey";
	/**
	 * The configurationValue element atom.
	 */
	public static final String CONFIGURATIONVALUE = "configurationValue";
	/**
	 * The conformance element atom.
	 */
	public static final String CONFORMANCE = "conformance";
	/**
	 * The connect element atom.
	 */
	public static final String CONNECT = "connect";// datasource
	/**
	 * The connectString element atom.
	 */
	public static final String CONNECTSTRING = "connectString";// datasource
	/**
	 * The connectionData element atom.
	 */
	public static final String CONNECTIONDATA = "connectionData";
	/**
	 * The connectionSet element atom.
	 */
	public static final String CONNECTIONSET = "connectionSet";
	/**
	 * The contentArea element atom.
	 */
	public static final String CONTENTAREA = "contentArea";
	/**
	 * The contentCopy element atom.
	 */
	public static final String CONTENTCOPY = "contentCopy";
	/**
	 * The controlCode element atom.
	 */
	public static final String CONTROLCODE = "controlCode";
	/**
	 * The copies element atom.
	 */
	public static final String COPIES = "copies";
	/**
	 * The copy element atom.
	 */
	public static final String COPY = "copy";
	/**
	 * The copyFrom element atom.
	 */
	public static final String COPYFROM = "copyFrom";
	/**
	 * The copyTo element atom.
	 */
	public static final String COPYTO = "copyTo";
	/**
	 * The corner element atom.
	 */
	public static final String CORNER = "corner";
	/**
	 * The creator element atom.
	 */
	public static final String CREATOR = "creator";
	/**
	 * The currencySymbol element atom.
	 */
	public static final String CURRENCYSYMBOL = "currencySymbol";// localeset
	/**
	 * The currencySymbols element atom.
	 */
	public static final String CURRENCYSYMBOLS = "currencySymbols";// localeset
	/**
	 * The currentPage element atom.
	 */
	public static final String CURRENTPAGE = "currentPage";
	/**
	 * The dSigData element atom.
	 */
	public static final String DSIGDATA = "dSigData";
	/**
	 * The dataGroup element atom.
	 */
	public static final String DATAGROUP = "dataGroup";
	/**
	 * The dataModel element atom.
	 */
	public static final String DATAMODEL = "dataModel";
	/**
	 * The dataSetCatch element atom.
	 */
	public static final String DATASETCATCH = "dataSetCatch";
	/**
	 * The dataSetIn element atom.
	 */
	public static final String DATASETIN = "dataSetIn";
	/**
	 * The dataSetOut element atom.
	 */
	public static final String DATASETOUT = "dataSetOut";
	/**
	 * The dataValue element atom.
	 */
	public static final String DATAVALUE = "dataValue";
	/**
	 * The date element atom.
	 */
	public static final String DATE = "date";
	/**
	 * The datePattern element atom.
	 */
	public static final String DATEPATTERN = "datePattern";// localeset
	/**
	 * The datePatterns element atom.
	 */
	public static final String DATEPATTERNS = "datePatterns";// localeset
	/**
	 * The dateTime element atom.
	 */
	public static final String DATETIME = "dateTime";
	/**
	 * The dateTimeEdit element atom.
	 */
	public static final String DATETIMEEDIT = "dateTimeEdit";
	/**
	 * The dateTimeSymbols element atom.
	 */
	public static final String DATETIMESYMBOLS = "dateTimeSymbols";// localeset
	/**
	 * The day element atom.
	 */
	public static final String DAY = "day";// localeset
	/**
	 * The dayNames element atom.
	 */
	public static final String DAYNAMES = "dayNames";// localeset
	/**
	 * The debug element atom.
	 */
	public static final String DEBUG = "debug";
	/**
	 * The decimal element atom.
	 */
	public static final String DECIMAL = "decimal";
	/**
	 * The defaultTypeface element atom.
	 */
	public static final String DEFAULTTYPEFACE = "defaultTypeface";
	/**
	 * The defaultUi element atom.
	 */
	public static final String DEFAULTUI = "defaultUi";
	/**
	 * The delete element atom.
	 */
	public static final String DELETE = "delete";// datasource
	/**
	 * The destination element atom.
	 */
	public static final String DESTINATION = "destination";
	/**
	 * The deviceInfo element atom.
	 */
	public static final String DEVICEINFO = "deviceInfo";
	/**
	 * The deviceUnits element atom.
	 */
	public static final String DEVICEUNITS = "deviceUnits";
	/**
	 * The digestMethod element atom.
	 */
	public static final String DIGESTMETHOD = "digestMethod";
	/**
	 * The digestMethods element atom.
	 */
	public static final String DIGESTMETHODS = "digestMethods";
	/**
	 * The documentAssembly element atom.
	 */
	public static final String DOCUMENTASSEMBLY = "documentAssembly";
	/**
	 * The draw element atom.
	 */
	public static final String DRAW = "draw";
	/**
	 * The driver element atom.
	 */
	public static final String DRIVER = "driver";
	/**
	 * The duplexOption element atom.
	 */
	public static final String DUPLEXOPTION = "duplexOption";
	/**
	 * The dynamicRender element atom.
	 */
	public static final String DYNAMICRENDER = "dynamicRender";
	/**
	 * The edge element atom.
	 */
	public static final String EDGE = "edge";
	/**
	 * The effectiveInputPolicy element atom.
	 */
	public static final String EFFECTIVEINPUTPOLICY = "effectiveInputPolicy";
	/**
	 * The effectiveOutputPolicy element atom.
	 */
	public static final String EFFECTIVEOUTPUTPOLICY = "effectiveOutputPolicy";
	/**
	 * The else element atom.
	 */
	public static final String ELSE = "else";
	/**
	 * The elseIf element atom.
	 */
	public static final String ELSEIF = "elseIf";
	/**
	 * The embed element atom.
	 */
	public static final String EMBED = "embed";
	/**
	 * The embedRenderedOutput element atom.
	 */
	public static final String EMBEDRENDEREDOUTPUT = "embedRenderedOutput";
	/**
	 * The encodings element atom.
	 */
	public static final String ENCODINGS = "encodings";
	/**
	 * The encrypt element atom.
	 */
	public static final String ENCRYPT = "encrypt";
	/**
	 * The encryption element atom.
	 */
	public static final String ENCRYPTION = "encryption";
	/**
	 * The encryptionLevel element atom.
	 */
	public static final String ENCRYPTIONLEVEL = "encryptionLevel";
	/**
	 * The enforce element atom.
	 */
	public static final String ENFORCE = "enforce";
	/**
	 * The equate element atom.
	 */
	public static final String EQUATE = "equate";
	/**
	 * The equateRange element atom.
	 */
	public static final String EQUATERANGE = "equateRange";
	/**
	 * The era element atom.
	 */
	public static final String ERA = "era";// localeset
	/**
	 * The eraNames element atom.
	 */
	public static final String ERANAMES = "eraNames";// localeset
	/**
	 * The error element atom.
	 */
	public static final String ERROR = "error";
	/**
	 * The errorInfo element atom.
	 */
	public static final String ERRORINFO = "errorInfo";
	/**
	 * The event element atom.
	 */
	public static final String EVENT = "event";
	/**
	 * The exData element atom.
	 */
	public static final String EXDATA = "exData";
	/**
	 * The exObject element atom.
	 */
	public static final String EXOBJECT = "exObject";
	/**
	 * The exclGroup element atom.
	 */
	public static final String EXCLGROUP = "exclGroup";
	/**
	 * The exclude element atom.
	 */
	public static final String EXCLUDE = "exclude";
	/**
	 * The excludeNS element atom.
	 */
	public static final String EXCLUDENS = "excludeNS";
	/**
	 * The execute element atom.
	 */
	public static final String EXECUTE = "execute";
	/**
	 * The exitStatus element atom.
	 */
	public static final String EXITSTATUS = "exitStatus";
	/**
	 * The extras element atom.
	 */
	public static final String EXTRAS = "extras";
	/**
	 * The field element atom.
	 */
	public static final String FIELD = "field";
	/**
	 * The fill element atom.
	 */
	public static final String FILL = "fill";
	/**
	 * The filter element atom.
	 */
	public static final String FILTER = "filter";
	/**
	 * The flipLabel element atom.
	 */
	public static final String FLIPLABEL = "flipLabel";
	/**
	 * The float element atom.
	 */
	public static final String FLOAT = "float";
	/**
	 * The font element atom.
	 */
	public static final String FONT = "font";
	/**
	 * The fontIndex element atom.
	 */
	public static final String FONTINDEX = "fontIndex";
	/**
	 * The fontInfo element atom.
	 */
	public static final String FONTINFO = "fontInfo";
	/**
	 * The fontResource element atom.
	 */
	public static final String FONTRESOURCE = "fontResource";
	/**
	 * The fontSelect element atom.
	 */
	public static final String FONTSELECT = "fontSelect";
	/**
	 * The for element atom.
	 */
	public static final String FOR = "for";
	/**
	 * The form element atom.
	 */
	public static final String FORM = "form";
	/**
	 * The formFieldFilling element atom.
	 */
	public static final String FORMFIELDFILLING = "formFieldFilling";
	/**
	 * The group element atom.
	 */
	public static final String GROUP = "group";
	/**
	 * The groupParent element atom.
	 */
	public static final String GROUPPARENT = "groupParent";
	/**
	 * The handler element atom.
	 */
	public static final String HANDLER = "handler";
	/**
	 * The htmlMerge element atom.
	 */
	public static final String HTMLMERGE = "htmlMerge";
	/**
	 * The hyphenation element atom.
	 */
	public static final String HYPHENATION = "hyphenation";
	/**
	 * The if element atom.
	 */
	public static final String IF = "if";
	/**
	 * The ifEmpty element atom.
	 */
	public static final String IFEMPTY = "ifEmpty";
	/**
	 * The image element atom.
	 */
	public static final String IMAGE = "image";
	/**
	 * The imageEdit element atom.
	 */
	public static final String IMAGEEDIT = "imageEdit";
	/**
	 * The in element atom.
	 */
	public static final String IN = "in";
	/**
	 * The includeXDPContent element atom.
	 */
	public static final String INCLUDEXDPCONTENT = "includeXDPContent";
	/**
	 * The incrementalLoad element atom.
	 */
	public static final String INCREMENTALLOAD = "incrementalLoad";
	/**
	 * The incrementalMerge element atom.
	 */
	public static final String INCREMENTALMERGE = "incrementalMerge";
	/**
	 * The ini element atom.
	 */
	public static final String INI = "ini";
	/**
	 * The initVar element atom.
	 */
	public static final String INITVAR = "initVar";
	/**
	 * The inputTrays element atom.
	 */
	public static final String INPUTTRAYS = "inputTrays";
	/**
	 * The insert element atom.
	 */
	public static final String INSERT = "insert";// datasource
	/**
	 * The instanceManager element atom.
	 */
	public static final String INSTANCEMANAGER = "instanceManager";
	/**
	 * The integer element atom.
	 */
	public static final String INTEGER = "integer";
	/**
	 * The interactive element atom.
	 */
	public static final String INTERACTIVE = "interactive";
	/**
	 * The issuers element atom.
	 */
	public static final String ISSUERS = "issuers";
	/**
	 * The items element atom.
	 */
	public static final String ITEMS = "items";
	/**
	 * The jog element atom.
	 */
	public static final String JOG = "jog";
	/**
	 * The keep element atom.
	 */
	public static final String KEEP = "keep";
	/**
	 * The keyUsage element atom.
	 */
	public static final String KEYUSAGE = "keyUsage";
	/**
	 * The line element atom.
	 */
	public static final String LINE = "line";
	/**
	 * The lineStyle element atom.
	 */
	public static final String LINESTYLE = "lineStyle";
	/**
	 * The linear element atom.
	 */
	public static final String LINEAR = "linear";
	/**
	 * The linearized element atom.
	 */
	public static final String LINEARIZED = "linearized";
	/**
	 * The listFont element atom.
	 */
	public static final String LISTFONT = "listFont";
	/**
	 * The local element atom.
	 */
	public static final String LOCAL = "local";
	/**
	 * The localeSet element atom.
	 */
	public static final String LOCALESET = "localeSet";// localeset
	/**
	 * The lockDocument element atom.
	 */
	public static final String LOCKDOCUMENT = "lockDocument";
	/**
	 * The log element atom.
	 */
	public static final String LOG = "log";
	/**
	 * The macro element atom.
	 */
	public static final String MACRO = "macro";
	/**
	 * The macroCache element atom.
	 */
	public static final String MACROCACHE = "macroCache";
	/**
	 * The manifest element atom.
	 */
	public static final String MANIFEST = "manifest";
	/**
	 * The map element atom.
	 */
	public static final String MAP = "map";
	/**
	 * The margin element atom.
	 */
	public static final String MARGIN = "margin";
	/**
	 * The masterPassword element atom.
	 */
	public static final String MASTERPASSWORD = "masterPassword";
	/**
	 * The mdp element atom.
	 */
	public static final String MDP = "mdp";
	/**
	 * The medium element atom.
	 */
	public static final String MEDIUM = "medium";
	/**
	 * The mediumInfo element atom.
	 */
	public static final String MEDIUMINFO = "mediumInfo";
	/**
	 * The meridiem element atom.
	 */
	public static final String MERIDIEM = "meridiem";// localeset
	/**
	 * The meridiemNames element atom.
	 */
	public static final String MERIDIEMNAMES = "meridiemNames";// localeset
	/**
	 * The messaging element atom.
	 */
	public static final String MESSAGING = "messaging";
	/**
	 * The metrics element atom.
	 */
	public static final String METRICS = "metrics";
	/**
	 * The modifyAnnots element atom.
	 */
	public static final String MODIFYANNOTS = "modifyAnnots";
	/**
	 * The month element atom.
	 */
	public static final String MONTH = "month";// localeset
	/**
	 * The monthNames element atom.
	 */
	public static final String MONTHNAMES = "monthNames";// localeset
	/**
	 * The msgId element atom.
	 */
	public static final String MSGID = "msgId";
	/**
	 * The nameAttr element atom.
	 */
	public static final String NAMEATTR = "nameAttr";
	/**
	 * The network element atom.
	 */
	public static final String NETWORK = "network";
	/**
	 * The neverEmbed element atom.
	 */
	public static final String NEVEREMBED = "neverEmbed";
	/**
	 * The node element atom.
	 */
	public static final String NODE = "node";
	/**
	 * The null element atom.
	 */
	public static final String NULL = "null";
	/**
	 * The numberOfCopies element atom.
	 */
	public static final String NUMBEROFCOPIES = "numberOfCopies";
	/**
	 * The numberPattern element atom.
	 */
	public static final String NUMBERPATTERN = "numberPattern";// localeset
	/**
	 * The numberPatterns element atom.
	 */
	public static final String NUMBERPATTERNS = "numberPatterns";// localeset
	/**
	 * The numberSymbol element atom.
	 */
	public static final String NUMBERSYMBOL = "numberSymbol";// localeset
	/**
	 * The numberSymbols element atom.
	 */
	public static final String NUMBERSYMBOLS = "numberSymbols";// localeset
	/**
	 * The numericEdit element atom.
	 */
	public static final String NUMERICEDIT = "numericEdit";
	/**
	 * The occur element atom.
	 */
	public static final String OCCUR = "occur";
	/**
	 * The oid element atom.
	 */
	public static final String OID = "oid";
	/**
	 * The oids element atom.
	 */
	public static final String OIDS = "oids";
	/**
	 * The onError element atom.
	 */
	public static final String ONERROR = "onError";
	/**
	 * The openAction element atom.
	 */
	public static final String OPENACTION = "openAction";
	/**
	 * The option element atom.
	 */
	public static final String OPTION = "option";
	/**
	 * The out element atom.
	 */
	public static final String OUT = "out";
	/**
	 * The outputBin element atom.
	 */
	public static final String OUTPUTBIN = "outputBin";
	/**
	 * The outputTrayDefinition element atom.
	 */
	public static final String OUTPUTTRAYDEFINITION = "outputTrayDefinition";
	/**
	 * The outputTrays element atom.
	 */
	public static final String OUTPUTTRAYS = "outputTrays";
	/**
	 * The outputXSL element atom.
	 */
	public static final String OUTPUTXSL = "outputXSL";
	/**
	 * The overprint element atom.
	 */
	public static final String OVERPRINT = "overprint";
	/**
	 * The packet element atom.
	 */
	public static final String PACKET = "packet";// "packet" doesn't appear in a grammar, but is a class.
	/**
	 * The packets element atom.
	 */
	public static final String PACKETS = "packets";
	/**
	 * The pageArea element atom.
	 */
	public static final String PAGEAREA = "pageArea";
	/**
	 * The pageOffset element atom.
	 */
	public static final String PAGEOFFSET = "pageOffset";
	/**
	 * The pageRange element atom.
	 */
	public static final String PAGERANGE = "pageRange";
	/**
	 * The pageSet element atom.
	 */
	public static final String PAGESET = "pageSet";
	/**
	 * The pagination element atom.
	 */
	public static final String PAGINATION = "pagination";
	/**
	 * The paginationOverride element atom.
	 */
	public static final String PAGINATIONOVERRIDE = "paginationOverride";
	/**
	 * The para element atom.
	 */
	public static final String PARA = "para";
	/**
	 * The param element atom.
	 */
	public static final String PARAM = "param";
	/**
	 * The parameter element atom.
	 */
	public static final String PARAMETER = "parameter";
	/**
	 * The part element atom.
	 */
	public static final String PART = "part";
	/**
	 * The password element atom.
	 */
	public static final String PASSWORD = "password";// datasource
	/**
	 * The passwordEdit element atom.
	 */
	public static final String PASSWORDEDIT = "passwordEdit";
	/**
	 * The path element atom.
	 */
	public static final String PATH = "path";
	/**
	 * The pattern element atom.
	 */
	public static final String PATTERN = "pattern";
	/**
	 * The pcl element atom.
	 */
	public static final String PCL = "pcl";
	/**
	 * The pdf element atom.
	 */
	public static final String PDF = "pdf";
	/**
	 * The pdfa element atom.
	 */
	public static final String PDFA = "pdfa";
	/**
	 * The pdfMerge element atom.
	 */
	public static final String PDFMERGE = "pdfMerge";
	/**
	 * The pdl element atom.
	 */
	public static final String PDL = "pdl";
	/**
	 * The pickTrayByPDFSize element atom.
	 */
	public static final String PICKTRAYBYPDFSIZE = "pickTrayByPDFSize";
	/**
	 * The picture element atom.
	 */
	public static final String PICTURE = "picture";
	/**
	 * The plaintextMetadata element atom.
	 */
	public static final String PLAINTEXTMETADATA = "plaintextMetadata";
	/**
	 * The preambleFile element atom.
	 */
	public static final String PREAMBLEFILE = "preambleFile";
	/**
	 * The present element atom.
	 */
	public static final String PRESENT = "present";// present
	/**
	 * The print element atom.
	 */
	public static final String PRINT = "print";
	/**
	 * The printerName element atom.
	 */
	public static final String PRINTERNAME = "printerName";
	/**
	 * The printHighQuality element atom.
	 */
	public static final String PRINTHIGHQUALITY = "printHighQuality";
	/**
	 * The printScaling element atom.
	 */
	public static final String PRINTSCALING = "printScaling";
	/**
	 * The producer element atom.
	 */
	public static final String PRODUCER = "producer";
	/**
	 * The proto element atom.
	 */
	public static final String PROTO = "proto";
	/**
	 * The ps element atom.
	 */
	public static final String PS = "ps";
	/**
	 * The psMap element atom.
	 */
	public static final String PSMAP = "psMap";
	/**
	 * The query element atom.
	 */
	public static final String QUERY = "query";// datasource
	/**
	 * The radial element atom.
	 */
	public static final String RADIAL = "radial";
	/**
	 * The range element atom.
	 */
	public static final String RANGE = "range";
	/**
	 * The reason element atom.
	 */
	public static final String REASON = "reason";
	/**
	 * The reasons element atom.
	 */
	public static final String REASONS = "reasons";
	/**
	 * The record element atom.
	 */
	public static final String RECORD = "record";
	/**
	 * The recordSet element atom.
	 */
	public static final String RECORDSET = "recordSet";// datasource
	/**
	 * The rectangle element atom.
	 */
	public static final String RECTANGLE = "rectangle";
	/**
	 * The recursive element atom.
	 */
	public static final String RECURSIVE = "recursive";
	/**
	 * The removeFont element atom.
	 */
	public static final String REMOVEFONT = "removeFont";
	/**
	 * The rename element atom.
	 */
	public static final String RENAME = "rename";
	/**
	 * The renderAs element atom.
	 */
	public static final String RENDERAS = "renderAs";
	/**
	 * The renderCache element atom.
	 */
	public static final String RENDERCACHE = "renderCache";
	/**
	 * The renderLib element atom.
	 */
	public static final String RENDERLIB = "renderLib";
	/**
	 * The renderPolicy element atom.
	 */
	public static final String RENDERPOLICY = "renderPolicy";
	/**
	 * The resolveFont element atom.
	 */
	public static final String RESOLVEFONT = "resolveFont";
	/**
	 * The respond element atom.
	 */
	public static final String RESPOND = "respond";
	/**
	 * The result element atom.
	 */
	public static final String RESULT = "result";
	/**
	 * The rootElement element atom.
	 */
	public static final String ROOTELEMENT = "rootElement";
	/**
	 * The runScripts element atom.
	 */
	public static final String RUNSCRIPTS = "runScripts";
	/**
	 * The scriptModel element atom.
	 */
	public static final String SCRIPTMODEL = "scriptModel";
	/**
	 * The searchFont element atom.
	 */
	public static final String SEARCHFONT = "searchFont";
	/**
	 * The seq element atom.
	 */
	public static final String SEQ = "seq";
	/**
	 * The set element atom.
	 */
	public static final String SET = "set";
	/**
	 * The setProperty element atom.
	 */
	public static final String SETPROPERTY = "setProperty";
	/**
	 * The severity element atom.
	 */
	public static final String SEVERITY = "severity";
	/**
	 * The signData element atom.
	 */
	public static final String SIGNDATA = "signData";
	/**
	 * The signature element atom.
	 */
	public static final String SIGNATURE = "signature";
	/**
	 * The signing element atom.
	 */
	public static final String SIGNING = "signing";
	/**
	 * The silentPrint element atom.
	 */
	public static final String SILENTPRINT = "silentPrint";
	/**
	 * The soapAction element atom.
	 */
	public static final String SOAPACTION = "soapAction";// sourceset
	/**
	 * The soapAddress element atom.
	 */
	public static final String SOAPADDRESS = "soapAddress";// sourceset
	/**
	 * The solid element atom.
	 */
	public static final String SOLID = "solid";
	/**
	 * The sourceSet element atom.
	 */
	public static final String SOURCESET = "sourceSet";// datasource
	/**
	 * The speak element atom.
	 */
	public static final String SPEAK = "speak";
	/**
	 * The staple element atom.
	 */
	public static final String STAPLE = "staple";
	/**
	 * The startNode element atom.
	 */
	public static final String STARTNODE = "startNode";
	/**
	 * The startPage element atom.
	 */
	public static final String STARTPAGE = "startPage";
	/**
	 * The status element atom.
	 */
	public static final String STATUS = "status";
	/**
	 * The stderr element atom.
	 */
	public static final String STDERR = "stderr";
	/**
	 * The stdin element atom.
	 */
	public static final String STDIN = "stdin";
	/**
	 * The stdout element atom.
	 */
	public static final String STDOUT = "stdout";
	/**
	 * The stipple element atom.
	 */
	public static final String STIPPLE = "stipple";
	/**
	 * The subform element atom.
	 */
	public static final String SUBFORM = "subform";
	/**
	 * The subformSet element atom.
	 */
	public static final String SUBFORMSET = "subformSet";
	/**
	 * The subjectDN element atom.
	 */
	public static final String SUBJECTDN = "subjectDN";
	/**
	 * The subjectDNs element atom.
	 */
	public static final String SUBJECTDNS = "subjectDNs";
	/**
	 * The submit element atom.
	 */
	public static final String SUBMIT = "submit";
	/**
	 * The submitFormat element atom.
	 */
	public static final String SUBMITFORMAT = "submitFormat";
	/**
	 * The submitUrl element atom.
	 */
	public static final String SUBMITURL = "submitUrl";
	/**
	 * The subsetBelow element atom.
	 */
	public static final String SUBSETBELOW = "subsetBelow";
	/**
	 * The supportedEncodings element atom.
	 */
	public static final String SUPPORTEDENCODINGS = "supportedEncodings";
	/**
	 * The supportedTechnologies element atom.
	 */
	public static final String SUPPORTEDTECHNOLOGIES = "supportedTechnologies";
	/**
	 * The suppressBanner element atom.
	 */
	public static final String SUPPRESSBANNER = "suppressBanner";
	/**
	 * The system element atom.
	 */
	public static final String SYSTEM = "system";
	/**
	 * The tagged element atom.
	 */
	public static final String TAGGED = "tagged";
	/**
	 * The taggedMode element atom.
	 */
	public static final String TAGGEDMODE = "taggedMode";
	/**
	 * The technology element atom.
	 */
	public static final String TECHNOLOGY = "technology";
	/**
	 * The temp element atom.
	 */
	public static final String TEMP = "temp";
	/**
	 * The template element atom.
	 */
	public static final String TEMPLATE = "template";
	/**
	 * The templateCache element atom.
	 */
	public static final String TEMPLATECACHE = "templateCache";
	/**
	 * The textEdit element atom.
	 */
	public static final String TEXTEDIT = "textEdit";
	/**
	 * The then element atom.
	 */
	public static final String THEN = "then";
	/**
	 * The time element atom.
	 */
	public static final String TIME = "time";
	/**
	 * The timePattern element atom.
	 */
	public static final String TIMEPATTERN = "timePattern";// localeset
	/**
	 * The timePatterns element atom.
	 */
	public static final String TIMEPATTERNS = "timePatterns";// localeset
	/**
	 * The toolTip element atom.
	 */
	public static final String TOOLTIP = "toolTip";
	/**
	 * The tp element atom.
	 */
	public static final String TRANSACTIONPROCESSOR = "tp";// tp
	/**
	 * The trace element atom.
	 */
	public static final String TRACE = "trace";
	/**
	 * The traceDom element atom.
	 */
	public static final String TRACEDOM = "traceDom";
	/**
	 * The traceFile element atom.
	 */
	public static final String TRACEFILE = "traceFile";
	/**
	 * The traceTo element atom.
	 */
	public static final String TRACETO = "traceTo";
	/**
	 * The transform element atom.
	 */
	public static final String TRANSFORM = "transform";
	/**
	 * The traversal element atom.
	 */
	public static final String TRAVERSAL = "traversal";
	/**
	 * The traverse element atom.
	 */
	public static final String TRAVERSE = "traverse";
	/**
	 * The typefaces element atom.
	 */
	public static final String TYPEFACES = "typefaces";
	/**
	 * The inputTrayDefinition element atom.
	 */
	public static final String INPUTTRAYDEFINITION = "inputTrayDefinition";
	/**
	 * The ui element atom.
	 */
	public static final String UI = "ui";
	/**
	 * The update element atom.
	 */
	public static final String UPDATE = "update";
	/**
	 * The updateXDC element atom.
	 */
	public static final String UPDATEXDC = "updateXDC";
	/**
	 * The uri element atom.
	 */
	public static final String URI = "uri";
	/**
	 * The user element atom.
	 */
	public static final String USER = "user";// datasource
	/**
	 * The userPassword element atom.
	 */
	public static final String USERPASSWORD = "userPassword";
	/**
	 * The validateApprovalSignatures element atom.
	 */
	public static final String VALIDATEAPPROVALSIGNATURES = "validateApprovalSignatures";
	/**
	 * The validationMessaging element atom.
	 */
	public static final String VALIDATIONMESSAGING = "validationMessaging";
	/**
	 * The var element atom.
	 */
	public static final String VAR = "var";
	/**
	 * The variables element atom.
	 */
	public static final String VARIABLES = "variables";
	/**
	 * The versionControl element atom.
	 */
	public static final String VERSIONCONTROL = "versionControl";
	/**
	 * The viewerPreferences element atom.
	 */
	public static final String VIEWERPREFERENCES = "viewerPreferences";
	/**
	 * The webClient element atom.
	 */
	public static final String WEBCLIENT = "webClient";
	/**
	 * The while element atom.
	 */
	public static final String WHILE = "while";
	/**
	 * The whitespace element atom.
	 */
	public static final String WHITESPACE = "whitespace";
	/**
	 * The window element atom.
	 */
	public static final String WINDOW = "window";
	/**
	 * The wsdlAddress element atom.
	 */
	public static final String WSDLADDRESS = "wsdlAddress";// sourceset
	/**
	 * The wsdlConnection element atom.
	 */
	public static final String WSDLCONNECTION = "wsdlConnection";
	/**
	 * The xci element atom.
	 */
	public static final String XCI = "xci";
	/**
	 * The xdc element atom.
	 */
	public static final String XDC = "xdc";
	/**
	 * The xdcFontAgent element atom.
	 */
	public static final String XDCFONTAGENT = "xdcFontAgent";
	/**
	 * The xdp element atom.
	 */
	public static final String XDP = "xdp";
	/**
	 * The xfa element atom.
	 */
	public static final String XFA = "xfa";
	/**
	 * The xft element atom.
	 */
	public static final String XFT = "xft";
	/**
	 * The xmlConnection element atom.
	 */
	public static final String XMLCONNECTION = "xmlConnection";
	/**
	 * The xpr element atom.
	 */
	public static final String XPR = "xpr";
	/**
	 * The xprModel element atom.
	 */
	public static final String XPRMODEL = "xprModel";
	/**
	 * The xprSource element atom.
	 */
	public static final String XPRSOURCE = "xprSource";
	/**
	 * The xsdConnection element atom.
	 */
	public static final String XSDCONNECTION = "xsdConnection";
	/**
	 * The xsl element atom.
	 */
	public static final String XSL = "xsl";
	/**
	 * The zpl element atom.
	 */
	public static final String ZPL = "zpl";
	/**
	 * The schema defaults atom.
	 */
	public static final String SCHEMA_DEFAULT = "";
	/**
	 * The accept element or attribute atom.
	 */
	public static final String ACCEPT = "accept";
	/**
	 * The bind element or attribute atom.
	 */
	public static final String BIND = "bind";// datasource attr and element
	/**
	 * The bookend element or attribute atom.
	 */
	public static final String BOOKEND = "bookend";
	/**
	 * The break element or attribute atom.
	 */
	public static final String BREAK = "break";// subform and border
	/**
	 * The breakAfter element or attribute atom.
	 */
	public static final String BREAKAFTER = "breakAfter";
	/**
	 * The breakBefore element or attribute atom.
	 */
	public static final String BREAKBEFORE = "breakBefore";
	/**
	 * The cSpace element or attribute atom.
	 */
	public static final String CSPACE = "cSpace";
	/**
	 * The change element or attribute atom.
	 */
	public static final String CHANGE = "change";
	/**
	 * The connection element or attribute atom.
	 */
	public static final String CONNECTION = "connection";
	/**
	 * The data element or attribute atom.
	 */
	public static final String DATA = "data";
	/**
	 * The dataDescription element or attribute atom.
	 */
	public static final String DATADESCRIPTION = "dataDescription";
	/**
	 * The desc element or attribute atom.
	 */
	public static final String DESC = "desc";
	/**
	 * The encoding element or attribute atom.
	 */
	public static final String ENCODING = "encoding";
	/**
	 * The file element or attribute atom.
	 */
	public static final String FILE = "file";
	/**
	 * The format element or attribute atom.
	 */
	public static final String FORMAT = "format";// field element and submit attr
	/**
	 * The input element or attribute atom.
	 */
	public static final String INPUT = "input";
	/**
	 * The layout element or attribute atom.
	 */
	public static final String LAYOUT = "layout";
	/**
	 * The level element or attribute atom.
	 */
	public static final String LEVEL = "level";
	/**
	 * The link element or attribute atom.
	 */
	public static final String LINK = "link";
	/**
	 * The locale element or attribute atom.
	 */
	public static final String LOCALE = "locale";// localeset, field locale
	/**
	 * The lock element or attribute atom.
	 */
	public static final String LOCK = "lock";// datasource attr
	/**
	 * The message element or attribute atom.
	 */
	public static final String MESSAGE = "message";
	/**
	 * The metaData element or attribute atom.
	 */
	public static final String METADATA = "metaData";
	/**
	 * The mode element or attribute atom.
	 */
	public static final String MODE = "mode";// datasource attr, log element
	/**
	 * The operation element or attribute atom.
	 */
	public static final String OPERATION = "operation";
	/**
	 * The output element or attribute atom.
	 */
	public static final String OUTPUT = "output";
	/**
	 * The overflow element or attribute atom.
	 */
	public static final String OVERFLOW = "overflow";
	/**
	 * The permissions element or attribute atom.
	 */
	public static final String PERMISSIONS = "permissions";
	/**
	 * The presence element or attribute atom.
	 */
	public static final String PRESENCE = "presence";
	/**
	 * The ref element or attribute atom.
	 */
	public static final String REF = "ref";// datasource attr
	/**
	 * The relevant element or attribute atom.
	 */
	public static final String RELEVANT = "relevant";
	/**
	 * The script element or attribute atom.
	 */
	public static final String SCRIPT = "script";
	/**
	 * The select element or attribute atom.
	 */
	public static final String SELECT = "select";// datasource element, font attr
	/**
	 * The source element or attribute atom.
	 */
	public static final String SOURCE = "source";// datasource element, metrics attr, // configuration
	/**
	 * The step element or attribute atom.
	 */
	public static final String STEP = "step";
	/**
	 * The text element or attribute atom.
	 */
	public static final String TEXT = "text";
	/**
	 * The threshold element or attribute atom.
	 */
	public static final String THRESHOLD = "threshold";
	/**
	 * The timeStamp element or attribute atom.
	 */
	public static final String TIMESTAMP = "timeStamp";
	/**
	 * The to element or attribute atom.
	 */
	public static final String TO = "to";
	/**
	 * The type element or attribute atom.
	 */
	public static final String TYPE = "type";
	/**
	 * The typeface element or attribute atom.
	 */
	public static final String TYPEFACE = "typeface";
	/**
	 * The validate element or attribute atom.
	 */
	public static final String VALIDATE = "validate";
	/**
	 * The value element or attribute atom.
	 */
	public static final String VALUE = "value";
	/**
	 * The version element or attribute atom.
	 */
	public static final String VERSION = "version";
	/**
	 * The APIVersion attribute atom.
	 */
	public static final String APIVERSION = "APIVersion";
	/**
	 * The abbr attribute atom.
	 */
	public static final String ABBR = "abbr";// localeset
	/**
	 * The access attribute atom.
	 */
	public static final String ACCESS = "access";
	/**
	 * The accessKey attribute atom.
	 */
	public static final String ACCESSKEY = "accessKey";
	/**
	 * The action attribute atom.
	 */
	public static final String ACTION = "action";
	/**
	 * The activity attribute atom.
	 */
	public static final String ACTIVITY = "activity";
	/**
	 * The add attribute atom.
	 */
	public static final String ADD = "add";
	/**
	 * The addRevocationInfo attribute atom.
	 */
	public static final String ADDREVOCATIONINFO = "addRevocationInfo";
	/**
	 * The after attribute atom.
	 */
	public static final String AFTER = "after";
	/**
	 * The afterTarget attribute atom.
	 */
	public static final String AFTERTARGET = "afterTarget";
	/**
	 * The allowMacro attribute atom.
	 */
	public static final String ALLOWMACRO = "allowMacro";
	/**
	 * The allowNeutral attribute atom.
	 */
	public static final String ALLOWNEUTRAL = "allowNeutral";
	/**
	 * The allowRichText attribute atom.
	 */
	public static final String ALLOWRICHTEXT = "allowRichText";
	/**
	 * The anchorType attribute atom.
	 */
	public static final String ANCHORTYPE = "anchorType";
	/**
	 * The applicationData attribute atom.
	 */
	public static final String APPLICATIONDATA = "applicationData";
	/**
	 * The applicationDataPrefix attribute atom.
	 */
	public static final String APPLICATIONDATAPREFIX = "applicationDataPrefix";
	/**
	 * The archive attribute atom.
	 */
	public static final String ARCHIVE = "archive";
	/**
	 * The ascent attribute atom.
	 */
	public static final String ASCENT = "ascent";
	/**
	 * The aspect attribute atom.
	 */
	public static final String ASPECT = "aspect";
	/**
	 * The backfeedSpeed attribute atom.
	 */
	public static final String BACKFEEDSPEED = "backfeedSpeed";
	/**
	 * The bBox attribute atom.
	 */
	public static final String BBOX = "bBox";
	/**
	 * The baseMode attribute atom.
	 */
	public static final String BASEMODE = "baseMode";
	/**
	 * The baseName attribute atom.
	 */
	public static final String BASENAME = "baseName";
	/**
	 * The baseProfile attribute atom.
	 */
	public static final String BASEPROFILE = "baseProfile";
	/**
	 * The baselineShift attribute atom.
	 */
	public static final String BASELINESHIFT = "baselineShift";
	/**
	 * The before attribute atom.
	 */
	public static final String BEFORE = "before";
	/**
	 * The beforeTarget attribute atom.
	 */
	public static final String BEFORETARGET = "beforeTarget";
	/**
	 * The bin attribute atom.
	 */
	public static final String BIN = "bin";
	/**
	 * The binding attribute atom.
	 */
	public static final String BINDING = "binding";
	/**
	 * The blankOrNotBlank attribute atom.
	 */
	public static final String BLANKORNOTBLANK = "blankOrNotBlank";
	/**
	 * The bofAction attribute atom.
	 */
	public static final String BOFACTION = "bofAction";
	/**
	 * The bookendLeader attribute atom.
	 */
	public static final String BOOKENDLEADER = "bookendLeader";
	/**
	 * The bookendTrailer attribute atom.
	 */
	public static final String BOOKENDTRAILER = "bookendTrailer";
	/**
	 * The bottomInset attribute atom.
	 */
	public static final String BOTTOMINSET = "bottomInset";
	/**
	 * The cacheLib attribute atom.
	 */
	public static final String CACHELIB = "cacheLib";
	/**
	 * The cap attribute atom.
	 */
	public static final String CAP = "cap";
	/**
	 * The capHeight attribute atom.
	 */
	public static final String CAPHEIGHT = "capHeight";
	/**
	 * The charEncoding attribute atom.
	 */
	public static final String CHARENCODING = "charEncoding";
	/**
	 * The charSet attribute atom.
	 */
	public static final String CHARSET = "charSet";
	/**
	 * The checksum attribute atom.
	 */
	public static final String CHECKSUM = "checksum";// barcode
	/**
	 * The circular attribute atom.
	 */
	public static final String CIRCULAR = "circular";
	/**
	 * The class attribute atom.
	 */
	public static final String CLASS = "class";
	/**
	 * The classId attribute atom.
	 */
	public static final String CLASSID = "classId";
	/**
	 * The codeBase attribute atom.
	 */
	public static final String CODEBASE = "codeBase";
	/**
	 * The codeType attribute atom.
	 */
	public static final String CODETYPE = "codeType";
	/**
	 * The colSpan attribute atom.
	 */
	public static final String COLSPAN = "colSpan";
	/**
	 * The columnWidths attribute atom.
	 */
	public static final String COLUMNWIDTHS = "columnWidths";
	/**
	 * The commandType attribute atom.
	 */
	public static final String COMMANDTYPE = "commandType";
	/**
	 * The commitOn attribute atom.
	 */
	public static final String COMMITON = "commitOn";
	/**
	 * The condition attribute atom.
	 */
	public static final String CONDITION = "condition";
	/**
	 * The contentType attribute atom.
	 */
	public static final String CONTENTTYPE = "contentType";
	/**
	 * The counter attribute atom.
	 */
	public static final String COUNTER = "counter";
	/**
	 * The credentialServerPolicy attribute atom.
	 */
	public static final String CREDENTIALSERVERPOLICY = "credentialServerPolicy";
	/**
	 * The crlSign attribute atom.
	 */
	public static final String CRLSIGN = "crlSign";
	/**
	 * The cursorLocation attribute atom.
	 */
	public static final String CURSORLOCATION = "cursorLocation";// datasource
	/**
	 * The cursorType attribute atom.
	 */
	public static final String CURSORTYPE = "cursorType";// datasource
	/**
	 * The dataColumnCount attribute atom.
	 */
	public static final String DATACOLUMNCOUNT = "dataColumnCount";// barcode
	/**
	 * The dataEncipherment attribute atom.
	 */
	public static final String DATAENCIPHERMENT = "dataEncipherment";
	/**
	 * The dataLength attribute atom.
	 */
	public static final String DATALENGTH = "dataLength";
	/**
	 * The dataMode attribute atom.
	 */
	public static final String DATAMODE = "dataMode";
	/**
	 * The dataNode attribute atom.
	 */
	public static final String DATANODE = "dataNode";
	/**
	 * The dataPrep attribute atom.
	 */
	public static final String DATAPREP = "dataPrep";
	/**
	 * The dataRowCount attribute atom.
	 */
	public static final String DATAROWCOUNT = "dataRowCount";// barcode
	/**
	 * The dataSetInfo attribute atom.
	 */
	public static final String DATASETINFO = "dataSetInfo";
	/**
	 * The db attribute atom.
	 */
	public static final String DB = "db";
	/**
	 * The decipherOnly attribute atom.
	 */
	public static final String DECIPHERONLY = "decipherOnly";
	/**
	 * The defaultCharWidth attribute atom.
	 */
	public static final String DEFAULTCHARWIDTH = "defaultCharWidth";
	/**
	 * The delayedOpen attribute atom.
	 */
	public static final String DELAYEDOPEN = "delayedOpen";// datasource
	/**
	 * The delegate attribute atom.
	 */
	public static final String DELEGATE = "delegate";
	/**
	 * The delimiter attribute atom.
	 */
	public static final String DELIMITER = "delimiter";
	/**
	 * The descent attribute atom.
	 */
	public static final String DESCENT = "descent";
	/**
	 * The dest attribute atom.
	 */
	public static final String DEST = "dest";
	/**
	 * The destOp attribute atom.
	 */
	public static final String DESTOP = "destOp";
	/**
	 * The destVar attribute atom.
	 */
	public static final String DESTVAR = "destVar";
	/**
	 * The digitalSignature attribute atom.
	 */
	public static final String DIGITALSIGNATURE = "digitalSignature";
	/**
	 * The disable attribute atom.
	 */
	public static final String DISABLE = "disable";
	/**
	 * The disableAll attribute atom.
	 */
	public static final String DISABLEALL = "disableAll";
	/**
	 * The domRef attribute atom.
	 */
	public static final String DOMREF = "domRef";
	/**
	 * The duplexImposition attribute atom.
	 */
	public static final String DUPLEXIMPOSITION = "duplexImposition";
	/**
	 * The embedPDF attribute atom.
	 */
	public static final String EMBEDPDF = "embedPDF";
	/**
	 * The emfContext attribute atom.
	 */
	public static final String EMFCONTEXT = "emfContext";
	/**
	 * The enable attribute atom.
	 */
	public static final String ENABLE = "enable";
	/**
	 * The encipherOnly attribute atom.
	 */
	public static final String ENCIPHERONLY = "encipherOnly";
	/**
	 * The endChar attribute atom.
	 */
	public static final String ENDCHAR = "endChar";// barcode
	/**
	 * The eofAction attribute atom.
	 */
	public static final String EOFACTION = "eofAction";
	/**
	 * The errorCorrectionLevel attribute atom.
	 */
	public static final String ERRORCORRECTIONLEVEL = "errorCorrectionLevel";// barcode
	/**
	 * The errorId attribute atom.
	 */
	public static final String ERRORID = "errorId";
	/**
	 * The eventContentType attribute atom.
	 */
	public static final String EVENTCONTENTTYPE = "eventContentType";
	/**
	 * The excludeAllCaps attribute atom.
	 */
	public static final String EXCLUDEALLCAPS = "excludeAllCaps";
	/**
	 * The excludeInitialCap attribute atom.
	 */
	public static final String EXCLUDEINITIALCAP = "excludeInitialCap";
	/**
	 * The executeIf attribute atom.
	 */
	public static final String EXECUTEIF = "executeIf";
	/**
	 * The executeType attribute atom.
	 */
	public static final String EXECUTETYPE = "executeType";
	/**
	 * The extendSize attribute atom.
	 */
	public static final String EXTENDSIZE = "extendSize";
	/**
	 * The extension attribute atom.
	 */
	public static final String EXTENSION = "extension";
	/**
	 * The final attribute atom.
	 */
	public static final String FINAL = "final";
	/**
	 * The flags attribute atom.
	 */
	public static final String FLAGS = "flags";
	/**
	 * The fontHorizontalScale attribute atom.
	 */
	public static final String FONTHORIZONTALSCALE = "fontHorizontalScale";
	/**
	 * The fontVerticalScale attribute atom.
	 */
	public static final String FONTVERTICALSCALE = "fontVerticalScale";
	/**
	 * The force attribute atom.
	 */
	public static final String FORCE = "force";
	/**
	 * The formats attribute atom.
	 */
	public static final String FORMATS = "formats";
	/**
	 * The formatTest attribute atom.
	 */
	public static final String FORMATTEST = "formatTest";
	/**
	 * The fracDigits attribute atom.
	 */
	public static final String FRACDIGITS = "fracDigits";
	/**
	 * The fraction attribute atom.
	 */
	public static final String FRACTION = "fraction";
	/**
	 * The from attribute atom.
	 */
	public static final String FROM = "from";
	/**
	 * The genericFamily attribute atom.
	 */
	public static final String GENERICFAMILY = "genericFamily";
	/**
	 * The h attribute atom.
	 */
	public static final String H = "h";
	/**
	 * The hAlign attribute atom.
	 */
	public static final String HALIGN = "hAlign";
	/**
	 * The highlight attribute atom.
	 */
	public static final String HIGHLIGHT = "highlight";
	/**
	 * The hScrollPolicy attribute atom.
	 */
	public static final String HSCROLLPOLICY = "hScrollPolicy";
	/**
	 * The hSize attribute atom.
	 */
	public static final String HSIZE = "hSize";
	/**
	 * The hand attribute atom.
	 */
	public static final String HAND = "hand";
	/**
	 * The handlerFor attribute atom.
	 */
	public static final String HANDLERFOR = "handlerFor";
	/**
	 * The href attribute atom.
	 */
	public static final String HREF = "href";
	/**
	 * The hyphenate attribute atom.
	 */
	public static final String HYPHENATE = "hyphenate";
	/**
	 * The id attribute atom.
	 */
	public static final String ID = "id";
	/**
	 * The imagingBBox attribute atom.
	 */
	public static final String IMAGINGBBOX = "imagingBBox";
	/**
	 * The initSize attribute atom.
	 */
	public static final String INITSIZE = "initSize";
	/**
	 * The initial attribute atom.
	 */
	public static final String INITIAL = "initial";
	/**
	 * The initialNumber attribute atom.
	 */
	public static final String INITIALNUMBER = "initialNumber";
	/**
	 * The intact attribute atom.
	 */
	public static final String INTACT = "intact";
	/**
	 * The intermediate attribute atom.
	 */
	public static final String INTERMEDIATE = "intermediate";
	/**
	 * The inverted attribute atom.
	 */
	public static final String INVERTED = "inverted";
	/**
	 * The italicAngle attribute atom.
	 */
	public static final String ITALICANGLE = "italicAngle";
	/**
	 * The iterate attribute atom.
	 */
	public static final String ITERATE = "iterate";
	/**
	 * The join attribute atom.
	 */
	public static final String JOIN = "join";
	/**
	 * The kerningMode attribute atom.
	 */
	public static final String KERNINGMODE = "kerningMode";
	/**
	 * The key attribute atom.
	 */
	public static final String KEY = "key";
	/**
	 * The keyAgreement attribute atom.
	 */
	public static final String KEYAGREEMENT = "keyAgreement";
	/**
	 * The keyCertSign attribute atom.
	 */
	public static final String KEYCERTSIGN = "keyCertSign";
	/**
	 * The keyEncipherment attribute atom.
	 */
	public static final String KEYENCIPHERMENT = "keyEncipherment";
	/**
	 * The labelRef attribute atom.
	 */
	public static final String LABELREF = "labelRef";
	/**
	 * The ladderCount attribute atom.
	 */
	public static final String LADDERCOUNT = "ladderCount";
	/**
	 * The leadDigits attribute atom.
	 */
	public static final String LEADDIGITS = "leadDigits";
	/**
	 * The leader attribute atom.
	 */
	public static final String LEADER = "leader";
	/**
	 * The leftInset attribute atom.
	 */
	public static final String LEFTINSET = "leftInset";
	/**
	 * The legacyConfig attribute atom.
	 */
	public static final String LEGACYCONFIG = "legacyConfig";
	/**
	 * The letterSpacing attribute atom.
	 */
	public static final String LETTERSPACING = "letterSpacing";
	/**
	 * The li attribute atom.
	 */
	public static final String LI = "li";
	/**
	 * The lineHeight attribute atom.
	 */
	public static final String LINEHEIGHT = "lineHeight";
	/**
	 * The lineThrough attribute atom.
	 */
	public static final String LINETHROUGH = "lineThrough";
	/**
	 * The lineThroughPeriod attribute atom.
	 */
	public static final String LINETHROUGHPERIOD = "lineThroughPeriod";
	/**
	 * The listen attribute atom.
	 */
	public static final String LISTEN = "listen";
	/**
	 * The lockType attribute atom.
	 */
	public static final String LOCKTYPE = "lockType";
	/**
	 * The long attribute atom.
	 */
	public static final String LONG = "long";
	/**
	 * The mappedBy attribute atom.
	 */
	public static final String MAPPEDBY = "mappedBy";
	/**
	 * The marginLeft attribute atom.
	 */
	public static final String MARGINLEFT = "marginLeft";
	/**
	 * The marginRight attribute atom.
	 */
	public static final String MARGINRIGHT = "marginRight";
	/**
	 * The mark attribute atom.
	 */
	public static final String MARK = "mark";
	/**
	 * The match attribute atom.
	 */
	public static final String MATCH = "match";
	/**
	 * The max attribute atom.
	 */
	public static final String MAX = "max";
	/**
	 * The maxChars attribute atom.
	 */
	public static final String MAXCHARS = "maxChars";
	/**
	 * The maxEntries attribute atom.
	 */
	public static final String MAXENTRIES = "maxEntries";
	/**
	 * The maxH attribute atom.
	 */
	public static final String MAXH = "maxH";
	/**
	 * The maxLength attribute atom.
	 */
	public static final String MAXLENGTH = "maxLength";
	/**
	 * The maxW attribute atom.
	 */
	public static final String MAXW = "maxW";
	/**
	 * The medium attribute atom.
	 */
	public static final String MEDIUMSTOCK = "medium";
	/**
	 * The member attribute atom.
	 */
	public static final String MEMBER = "member";
	/**
	 * The memberOf attribute atom.
	 */
	public static final String MEMBEROF = "memberOf";
	/**
	 * The merge attribute atom.
	 */
	public static final String MERGE = "merge";
	/**
	 * The mergeMode attribute atom.
	 */	
	public static final String MERGEMODE = "mergeMode";
	/**
	 * The min attribute atom.
	 */
	public static final String MIN = "min";
	/**
	 * The minH attribute atom.
	 */
	public static final String MINH = "minH";
	/**
	 * The minW attribute atom.
	 */
	public static final String MINW = "minW";
	/**
	 * The moduleHeight attribute atom.
	 */
	public static final String MODULEHEIGHT = "moduleHeight";// barcode
	/**
	 * The moduleHeightVariable attribute atom.
	 */
	public static final String MODULEHEIGHTVARIABLE = "moduleHeightVariable";// barcode
	/**
	 * The moduleWidth attribute atom.
	 */
	public static final String MODULEWIDTH = "moduleWidth";// barcode
	/**
	 * The moduleWidthVariable attribute atom.
	 */
	public static final String MODULEWIDTHVARIABLE = "moduleWidthVariable";// barcode
	/**
	 * The multiLine attribute atom.
	 */
	public static final String MULTILINE = "multiLine";
	/**
	 * The name attribute atom.
	 */
	public static final String NAME = "name";
	/**
	 * The next attribute atom.
	 */
	public static final String NEXT = "next";
	/**
	 * The nodeType attribute atom.
	 */
	public static final String NODETYPE = "nodeType";
	/**
	 * The nonRepudiation attribute atom.
	 */
	public static final String NONREPUDIATION = "nonRepudiation";
	/**
	 * The nullTest attribute atom.
	 */
	public static final String NULLTEST = "nullTest";
	/**
	 * The nullType attribute atom.
	 */
	public static final String NULLTYPE = "nullType";
	/**
	 * The numbered attribute atom.
	 */
	public static final String NUMBERED = "numbered";
	/**
	 * The numberOfCells attribute atom.
	 */
	public static final String NUMBEROFCELLS = "numberOfCells";
	/**
	 * The oddOrEven attribute atom.
	 */
	public static final String ODDOREVEN = "oddOrEven";
	/**
	 * The ol attribute atom.
	 */
	public static final String OL = "ol";
	/**
	 * The open attribute atom.
	 */
	public static final String OPEN = "open";
	/**
	 * The orientation attribute atom.
	 */
	public static final String ORIENTATION = "orientation";
	/**
	 * The orphans attribute atom.
	 */
	public static final String ORPHANS = "orphans";
	/**
	 * The outputBelow attribute atom.
	 */
	public static final String OUTPUTBELOW = "outputBelow";
	/**
	 * The overflowLeader attribute atom.
	 */
	public static final String OVERFLOWLEADER = "overflowLeader";
	/**
	 * The overflowTarget attribute atom.
	 */
	public static final String OVERFLOWTARGET = "overflowTarget";
	/**
	 * The overflowTrailer attribute atom.
	 */
	public static final String OVERFLOWTRAILER = "overflowTrailer";
	/**
	 * The overline attribute atom.
	 */
	public static final String OVERLINE = "overline";
	/**
	 * The overlinePeriod attribute atom.
	 */
	public static final String OVERLINEPERIOD = "overlinePeriod";
	/**
	 * The override attribute atom.
	 */
	public static final String OVERRIDE = "override";
	/**
	 * The padding attribute atom.
	 */
	public static final String PADDING = "padding";// barcode
	/**
	 * The pagePosition attribute atom.
	 */
	public static final String PAGEPOSITION = "pagePosition";
	/**
	 * The parity attribute atom.
	 */
	public static final String PARITY = "parity";// barcode
	/**
	 * The parse attribute atom.
	 */
	public static final String PARSE = "parse";
	/**
	 * The passThrough attribute atom.
	 */
	public static final String PASSTHROUGH = "passThrough";
	/**
	 * The passwordChar attribute atom.
	 */
	public static final String PASSWORDCHAR = "passwordChar";
	/**
	 * The picker attribute atom.
	 */
	public static final String PICKER = "picker";
	/**
	 * The pitch attribute atom.
	 */
	public static final String PITCH = "pitch";
	/**
	 * The placement attribute atom.
	 */
	public static final String PLACEMENT = "placement";
	/**
	 * The posture attribute atom.
	 */
	public static final String POSTURE = "posture";
	/**
	 * The prefix attribute atom.
	 */
	public static final String PREFIX = "prefix";
	/**
	 * The preserve attribute atom.
	 */
	public static final String PRESERVE = "preserve";
	/**
	 * The previous attribute atom.
	 */
	public static final String PREVIOUS = "previous";
	/**
	 * The previousSibling attribute atom.
	 */
	public static final String PREVIOUSSIBLING = "previousSibling";
	/**
	 * The primaryKey attribute atom.
	 */
	public static final String PRIMARYKEY = "primaryKey";
	/**
	 * The printCheckDigit attribute atom.
	 */
	public static final String PRINTCHECKDIGIT = "printCheckDigit";// barcode
	/**
	 * The printerType attribute atom.
	 */
	public static final String PRINTERTYPE = "printerType";
	/**
	 * The printSpeed attribute atom.
	 */
	public static final String PRINTSPEED = "printSpeed";
	/**
	 * The priority attribute atom.
	 */
	public static final String PRIORITY = "priority";
	/**
	 * The program attribute atom.
	 */
	public static final String PROGRAM = "program";
	/**
	 * The psName attribute atom.
	 */
	public static final String PSNAME = "psName";
	/**
	 * The pushCharacterCount attribute atom.
	 */
	public static final String PUSHCHARACTERCOUNT = "pushCharacterCount";
	/**
	 * The quietZone attribute atom.
	 */
	public static final String QUIETZONE = "quietZone";// barcode
	/**
	 * The radius attribute atom.
	 */
	public static final String RADIUS = "radius";
	/**
	 * The radixOffset attribute atom.
	 */
	public static final String RADIXOFFSET = "radixOffset";
	/**
	 * The rate attribute atom.
	 */
	public static final String RATE = "rate";
	/**
	 * The readOnly attribute atom.
	 */
	public static final String READONLY = "readOnly";
	/**
	 * The reflects attribute atom.
	 */
	public static final String REFLECTS = "reflects";	
	/**
	 * The relation attribute atom.
	 */
	public static final String RELATION = "relation";
	/**
	 * The remainCharacterCount attribute atom.
	 */
	public static final String REMAINCHARACTERCOUNT = "remainCharacterCount";
	/**
	 * The reserve attribute atom.
	 */
	public static final String RESERVE = "reserve";
	/**
	 * The reserveH attribute atom.
	 */
	public static final String RESERVEH = "reserveH";
	/**
	 * The restoreState attribute atom.
	 */
	public static final String RESTORESTATE = "restoreState";
	/**
	 * The retryCount attribute atom.
	 */
	public static final String RETRYCOUNT = "retryCount";
	/**
	 * The rid attribute atom.
	 */
	public static final String RID = "rid";
	/**
	 * The retryIn attribute atom.
	 */
	public static final String RETRYIN = "retryIn";
	/**
	 * The rightInset attribute atom.
	 */
	public static final String RIGHTINSET = "rightInset";
	/**
	 * The role attribute atom.
	 */
	public static final String ROLE = "role";
	/**
	 * The root attribute atom.
	 */
	public static final String ROOT = "root";
	/**
	 * The rotate attribute atom.
	 */
	public static final String ROTATE = "rotate";
	/**
	 * The round attribute atom.
	 */
	public static final String ROUND = "round";
	/**
	 * The rowColumnRatio attribute atom.
	 */
	public static final String ROWCOLUMNRATIO = "rowColumnRatio";// barcode
	/**
	 * The runAt attribute atom.
	 */
	public static final String RUNAT = "runAt";// script
	/**
	 * The save attribute atom.
	 */
	public static final String SAVE = "save";
	/**
	 * The scalable attribute atom.
	 */
	public static final String SCALABLE = "scalable";
	/**
	 * The scope attribute atom.
	 */
	public static final String SCOPE = "scope";
	/**
	 * The scriptTest attribute atom.
	 */
	public static final String SCRIPTTEST = "scriptTest";
	/**
	 * The serialize attribute atom.
	 */
	public static final String SERIALIZE = "serialize";// barcode
	/**
	 * The server attribute atom.
	 */
	public static final String SERVER = "server";
	/**
	 * The shape attribute atom.
	 */
	public static final String SHAPE = "shape";
	/**
	 * The shareDom attribute atom.
	 */
	public static final String SHAREDOM = "shareDom";
	/**
	 * The short attribute atom.
	 */
	public static final String SHORT = "short";
	/**
	 * The sign attribute atom.
	 */
	public static final String SIGN = "sign";
	/**
	 * The signatureType attribute atom.
	 */
	public static final String SIGNATURETYPE = "signatureType";
	/**
	 * The size attribute atom.
	 */
	public static final String SIZE = "size";
	/**
	 * The slewSpeed attribute atom.
	 */
	public static final String SLEWSPEED = "slewSpeed";
	/**
	 * The slope attribute atom.
	 */
	public static final String SLOPE = "slope";
	/**
	 * The som attribute atom.
	 */
	public static final String SOM = "som";
	/**
	 * The sourceAbove attribute atom.
	 */
	public static final String SOURCEABOVE = "sourceAbove";
	/**
	 * The sourceBelow attribute atom.
	 */
	public static final String SOURCEBELOW = "sourceBelow";
	/**
	 * The spaceAbove attribute atom.
	 */
	public static final String SPACEABOVE = "spaceAbove";
	/**
	 * The spaceBelow attribute atom.
	 */
	public static final String SPACEBELOW = "spaceBelow";
	/**
	 * The square attribute atom.
	 */
	public static final String SQUARE = "square";
	/**
	 * The startAngle attribute atom.
	 */
	public static final String STARTANGLE = "startAngle";
	/**
	 * The startChar attribute atom.
	 */
	public static final String STARTCHAR = "startChar";// barcode
	/**
	 * The startNew attribute atom.
	 */
	public static final String STARTNEW = "startNew";
	/**
	 * The stateless attribute atom.
	 */
	public static final String STATELESS = "stateless";
	/**
	 * The stdHW attribute atom.
	 */
	public static final String STDHW = "stdHW";
	/**
	 * The stdVW attribute atom.
	 */
	public static final String STDVW = "stdVW";
	/**
	 * The steps attribute atom.
	 */
	public static final String STEPS = "steps";
	/**
	 * The stock attribute atom.
	 */
	public static final String STOCK = "stock";
	/**
	 * The stroke attribute atom.
	 */
	public static final String STROKE = "stroke";
	/**
	 * The styleType attribute atom.
	 */
	public static final String STYLETYPE = "styleType";
	/**
	 * The suffix attribute atom.
	 */
	public static final String SUFFIX = "suffix";
	/**
	 * The support attribute atom.
	 */
	public static final String SUPPORT = "support";
	/**
	 * The sweepAngle attribute atom.
	 */
	public static final String SWEEPANGLE = "sweepAngle";
	/**
	 * The tabDefault attribute atom.
	 */
	public static final String TABSDEFAULT = "tabDefault";
	/**
	 * The tabStops attribute atom.
	 */
	public static final String TABSTOPS = "tabStops";
	/**
	 * The target attribute atom.
	 */
	public static final String TARGET = "target";
	/**
	 * The targetType attribute atom.
	 */
	public static final String TARGETTYPE = "targetType";
	/**
	 * The textEncoding attribute atom.
	 */
	public static final String TEXTENCODING = "textEncoding";
	/**
	 * The textEntry attribute atom.
	 */
	public static final String TEXTENTRY = "textEntry";
	/**
	 * The textIndent attribute atom.
	 */
	public static final String TEXTINDENT = "textIndent";
	/**
	 * The textLocation attribute atom.
	 */
	public static final String TEXTLOCATION = "textLocation";// barcode
	/**
	 * The thickness attribute atom.
	 */
	public static final String THICKNESS = "thickness";
	/**
	 * The timeOut attribute atom.
	 */
	public static final String TIMEOUT = "timeout";// datasource
	/**
	 * The topInset attribute atom.
	 */
	public static final String TOPINSET = "topInset";
	/**
	 * The traceInclude attribute atom.
	 */
	public static final String TRACEINCLUDE = "traceInclude";
	/**
	 * The trailer attribute atom.
	 */
	public static final String TRAILER = "trailer";
	/**
	 * The transferEncoding attribute atom.
	 */
	public static final String TRANSFERENCODING = "transferEncoding";
	/**
	 * The transient attribute atom.
	 */
	public static final String TRANSIENT = "transient";
	/**
	 * The trayIn attribute atom.
	 */
	public static final String TRAYIN = "trayIn";
	/**
	 * The trayNumber attribute atom.
	 */
	public static final String TRAYNUMBER = "trayNumber";
	/**
	 * The trayOut attribute atom.
	 */
	public static final String TRAYOUT = "trayOut";
	/**
	 * The trayType attribute atom.
	 */
	public static final String TRAYTYPE = "trayType";
	/**
	 * The truncate attribute atom.
	 */
	public static final String TRUNCATE = "truncate";// barcode
	/**
	 * The ul attribute atom.
	 */
	public static final String UL = "ul";
	/**
	 * The underline attribute atom.
	 */
	public static final String UNDERLINE = "underline";
	/**
	 * The underlinePeriod attribute atom.
	 */
	public static final String UNDERLINEPERIOD = "underlinePeriod";
	/**
	 * The unicodeRange attribute atom.
	 */
	public static final String UNICODERANGE = "unicodeRange";
	/**
	 * The unsigner attribute atom.
	 */
	public static final String UNSIGNER = "unsigner";
	/**
	 * The upsMode attribute atom.
	 */
	public static final String UPSMODE = "upsMode";
	/**
	 * The url attribute atom.
	 */
	public static final String URL = "url";
	/**
	 * The urlPolicy attribute atom.
	 */
	public static final String URLPOLICY = "urlPolicy";
	/**
	 * The usage attribute atom.
	 */
	public static final String USAGE = "usage";
	/**
	 * The use attribute atom.
	 */
	public static final String USE = "use";
	/**
	 * The usehref attribute atom.
	 */
	public static final String USEHREF = "usehref";
	/**
	 * The uuid attribute atom.
	 */
	public static final String UUID = "uuid";
	/**
	 * The vAlign attribute atom.
	 */
	public static final String VALIGN = "vAlign";
	/**
	 * The valueRef attribute atom.
	 */
	public static final String VALUEREF = "valueRef";
	/**
	 * The vScrollPolicy attribute atom.
	 */
	public static final String VSCROLLPOLICY = "vScrollPolicy";
	/**
	 * The vSize attribute atom.
	 */
	public static final String VSIZE = "vSize";
	/**
	 * The validDataChars attribute atom.
	 */
	public static final String VALIDDATACHARS = "validDataChars";
	/**
	 * The w attribute atom.
	 */
	public static final String W = "w";
	/**
	 * The weight attribute atom.
	 */
	public static final String WEIGHT = "weight";
	/**
	 * The wideNarrowRatio attribute atom.
	 */
	public static final String WIDENARROWRATIO = "wideNarrowRatio";// barcode
	/**
	 * The widows attribute atom.
	 */
	public static final String WIDOWS = "widows";
	/**
	 * The wordCharacterCount attribute atom.
	 */
	public static final String WORDCHARACTERCOUNT = "wordCharacterCount";
	/**
	 * The wordSpacingMaximum attribute atom.
	 */
	public static final String WORDSPACINGMAXIMUM = "wordSpacingMaximum";
	/**
	 * The wordSpacingMinimum attribute atom.
	 */
	public static final String WORDSPACINGMINIMUM = "wordSpacingMinimum";
	/**
	 * The wordSpacingOptimum attribute atom.
	 */
	public static final String WORDSPACINGOPTIMUM = "wordSpacingOptimum";
	/**
	 * The writingScript attribute atom.
	 */
	public static final String WRITINGSCRIPT = "writingScript";
	/**
	 * The x attribute atom.
	 */
	public static final String X = "x";
	/**
	 * The xHeight attribute atom.
	 */
	public static final String XHEIGHT = "xHeight";
	/**
	 * The xdpContent attribute atom.
	 */
	public static final String XDPCONTENT = "xdpContent";
	/**
	 * The xmlns attribute atom.
	 */
	public static final String XMLNS = "xmlns";
	/**
	 * The y attribute atom.
	 */
	public static final String Y = "y";


	static final String goXFAAtoms[] = {
		// ELEMENTS
		TEXTNODE,
		RICHTEXTNODE,
		XMLMULTISELECTNODE,
		CR,
		ESC,
		FF,
		LF,
		ACCESSIBLECONTENT,
		ACROBAT,
		ACROBAT7,
		ADDFONT,
		ADDSILENTPRINT,
		ADDVIEWERPREFERENCES,
		ADJUSTDATA,
		ADOBE,
		ADOBEEXTENSIONLEVEL,
		AGENT,
		ALWAYSEMBED,
		AMD,
		APPEARANCEFILTER,
		ARC,
		AREA,
		ASSIST,
		ATTRIBUTES,
		BARCODE,
		BARCODEDEFINITION,
		BARCODES,
		BASE,
		BATCHOUTPUT,
		BEHAVIOROVERRIDE,
		BINARY,
		BINDITEMS,
		BOOLEAN,
		BORDER,
		BUTTON,
		CACHE,
		CALCULATE,
		CALENDARSYMBOLS,
		CALLXPR,
		CALLBACK,
		CALLOUT,
		CAPTION,
		CATCH,
		CERTIFICATE,
		CERTIFICATES,
		CHARWIDTH,
		CHECKBUTTON,
		CHOICELIST,
		COLOR,
		COMB,
		COMMAND,
		COMMON,
		COMPRESS,
		COMPRESSOBJECTSTREAM,
		COMPRESSLOGICALSTRUCTURE,
		COMPRESSION,
		CONFIG,
		CONFIGURATIONKEY,
		CONFIGURATIONVALUE,
		CONFORMANCE,
		CONNECT,
		CONNECTSTRING,
		CONNECTIONDATA,
		CONNECTIONSET,
		CONTENTAREA,
		CONTENTCOPY,
		CONTROLCODE,
		COPIES,
		COPY,
		COPYFROM,
		COPYTO,
		CORNER,
		CREATOR,
		CURRENCYSYMBOL,
		CURRENCYSYMBOLS,
		CURRENTPAGE,
		DSIGDATA,
		DATAGROUP,
		DATAMODEL,
		DATASETCATCH,
		DATASETIN,
		DATASETOUT,
		DATAVALUE,
		DATE,
		DATEPATTERN,
		DATEPATTERNS,
		DATETIME,
		DATETIMEEDIT,
		DATETIMESYMBOLS,
		DAY,
		DAYNAMES,
		DEBUG,
		DECIMAL,
		DEFAULTTYPEFACE,
		DEFAULTUI,
		DELETE,
		DESTINATION,
		DEVICEINFO,
		DEVICEUNITS,
		DIGESTMETHOD,
		DIGESTMETHODS,
		DOCUMENTASSEMBLY,
		DRAW,
		DRIVER,
		DUPLEXOPTION,
		DYNAMICRENDER,
		EDGE,
		EFFECTIVEINPUTPOLICY,
		EFFECTIVEOUTPUTPOLICY,
		ELSE,
		ELSEIF,
		EMBED,
		EMBEDRENDEREDOUTPUT,
		ENCODINGS,
		ENCRYPT,
		ENCRYPTION,
		ENCRYPTIONLEVEL,
		ENFORCE,
		EQUATE,
		EQUATERANGE,
		ERA,
		ERANAMES,
		ERROR,
		ERRORINFO,
		EVENT,
		EXDATA,
		EXOBJECT,
		EXCLGROUP,
		EXCLUDE,
		EXCLUDENS,
		EXECUTE,
		EXITSTATUS,
		EXTRAS,
		FIELD,
		FILL,
		FILTER,
		FLIPLABEL,
		FLOAT,
		FONT,
		FONTINDEX,
		FONTINFO,
		FONTRESOURCE,
		FONTSELECT,
		FOR,
		FORM,
		FORMFIELDFILLING,
		GROUP,
		GROUPPARENT,
		HANDLER,
		HTMLMERGE,
		HYPHENATION,
		IF,
		IFEMPTY,
		IMAGE,
		IMAGEEDIT,
		IN,
		INCLUDEXDPCONTENT,
		INCREMENTALLOAD,
		INCREMENTALMERGE,
		INI,
		INITVAR,
		INPUTTRAYS,
		INSERT,
		INSTANCEMANAGER,
		INTEGER,
		INTERACTIVE,
		ISSUERS,
		ITEMS,
		JOG,
		KEEP,
		KEYUSAGE,
		LINE,
		LINESTYLE,
		LINEAR,
		LINEARIZED,
		LISTFONT,
		LOCAL,
		LOCALESET,
		LOCKDOCUMENT,
		LOG,
		MACRO,
		MACROCACHE,
		MANIFEST,
		MAP,
		MARGIN,
		MASTERPASSWORD,
		MDP,
		MEDIUM,
		MEDIUMINFO,
		MERIDIEM,
		MERIDIEMNAMES,
		MESSAGING,
		METRICS,
		MODIFYANNOTS,
		MONTH,
		MONTHNAMES,
		MSGID,
		NAMEATTR,
		NETWORK,
		NEVEREMBED,
		NODE,
		NULL,
		NUMBEROFCOPIES,
		NUMBERPATTERN,
		NUMBERPATTERNS,
		NUMBERSYMBOL,
		NUMBERSYMBOLS,
		NUMERICEDIT,
		OCCUR,
		OID,
		OIDS,
		ONERROR,
		OPENACTION,
		OPTION,
		OUT,
		OUTPUTBIN,
		OUTPUTTRAYDEFINITION,
		OUTPUTTRAYS,
		OUTPUTXSL,
		OVERPRINT,
		PACKET,
		PACKETS,
		PAGEAREA,
		PAGEOFFSET,
		PAGERANGE,
		PAGESET,
		PAGINATION,
		PAGINATIONOVERRIDE,
		PARA,
		PARAM,
		PARAMETER,
		PART,
		PASSWORD,
		PASSWORDEDIT,
		PATH,
		PATTERN,
		PCL,
		PDF,
		PDFA,
		PDFMERGE,
		PDL,
		PICKTRAYBYPDFSIZE,
		PICTURE,
		PLAINTEXTMETADATA,
		PREAMBLEFILE,
		PRESENT,
		PRINT,
		PRINTHIGHQUALITY,
		PRINTERNAME,
		PRINTSCALING,
		PRODUCER,
		PROTO,
		PS,
		PSMAP,
		QUERY,
		RADIAL,
		RANGE,
		REASON,
		REASONS,
		RECORD,
		RECORDSET,
		RECTANGLE,
		RECURSIVE,
		REMOVEFONT,
		RENAME,
		RENDERAS,
		RENDERCACHE,
		RENDERLIB,
		RENDERPOLICY,
		RESOLVEFONT,
		RESPOND,
		RESULT,
		ROOTELEMENT,
		RUNSCRIPTS,
		SCRIPTMODEL,
		SEARCHFONT,
		SEQ,
		SET,
		SETPROPERTY,
		SEVERITY,
		SIGNDATA,
		SIGNATURE,
		SIGNING,
		SILENTPRINT,
		SOAPACTION,
		SOAPADDRESS,
		SOLID,
		SOURCESET,
		SPEAK,
		STAPLE,
		STARTNODE,
		STARTPAGE,
		STATUS,
		STDERR,
		STDIN,
		STDOUT,
		STIPPLE,
		SUBFORM,
		SUBFORMSET,
		SUBJECTDN,
		SUBJECTDNS,
		SUBMIT,
		SUBMITFORMAT,
		SUBMITURL,
		SUBSETBELOW,
		SUPPORTEDENCODINGS,
		SUPPORTEDTECHNOLOGIES,
		SUPPRESSBANNER,
		SYSTEM,
		TAGGED,
		TAGGEDMODE,
		TECHNOLOGY,
		TEMP,
		TEMPLATE,
		TEMPLATECACHE,
		TEXTEDIT,
		THEN,
		TIME,
		TIMEPATTERN,
		TIMEPATTERNS,
		TOOLTIP,
		TRANSACTIONPROCESSOR,
		TRACE,
		TRACEDOM,
		TRACEFILE,
		TRACETO,
		TRANSFORM,
		TRAVERSAL,
		TRAVERSE,
		TYPEFACES,
		INPUTTRAYDEFINITION,
		UI,
		UPDATE,
		UPDATEXDC,
		URI,
		USER,
		USERPASSWORD,
		VALIDATEAPPROVALSIGNATURES,
		VALIDATIONMESSAGING,
		VAR,
		VARIABLES,
		VERSIONCONTROL,
		VIEWERPREFERENCES,
		WEBCLIENT,
		WHILE,
		WHITESPACE,
		WINDOW,
		WSDLADDRESS,
		WSDLCONNECTION,
		XCI,
		XDC,
		XDCFONTAGENT,
		XDP,
		XFA,
		XFT,
		XMLCONNECTION,
		XPR,
		XPRMODEL,
		XPRSOURCE,
		XSDCONNECTION,
		XSL,
		ZPL,
		SCHEMA_DEFAULT,
		// ELEMENTS AND ATTRIBUTES
		ACCEPT,
		BIND,
		BOOKEND,
		BREAK,
		BREAKAFTER,
		BREAKBEFORE,
		CSPACE,
		CHANGE,
		CONNECTION,
		DATA,
		DATADESCRIPTION,
		DESC,
		ENCODING,
		FILE,
		FORMAT,
		INPUT,
		LAYOUT,
		LEVEL,
		LINK,
		LOCALE,
		LOCK,
		MESSAGE,
		METADATA,
		MODE,
		OPERATION,
		OUTPUT,
		OVERFLOW,
		PERMISSIONS,
		PRESENCE,
		REF,
		RELEVANT,
		SCRIPT,
		SELECT,
		SOURCE,
		STEP,
		TEXT,
		THRESHOLD,
		TIMESTAMP,
		TO,
		TYPE,
		TYPEFACE,
		VALIDATE,
		VALUE,
		VERSION,
		// ATTRIBUTES
		APIVERSION,
		ABBR,
		ACCESS,
		ACCESSKEY,
		ACTION,
		ACTIVITY,
		ADD,
		ADDREVOCATIONINFO,
		AFTER,
		AFTERTARGET,
		ALLOWMACRO,
		ALLOWNEUTRAL,
		ALLOWRICHTEXT,
		ANCHORTYPE,
		APPLICATIONDATA,
		APPLICATIONDATAPREFIX,
		ARCHIVE,
		ASCENT,
		ASPECT,
		BACKFEEDSPEED,
		BBOX,
		BASEMODE,
		BASENAME,
		BASEPROFILE,
		BASELINESHIFT,
		BEFORE,
		BEFORETARGET,
		BIN,
		BINDING,
		BLANKORNOTBLANK,
		BOFACTION,
		BOOKENDLEADER,
		BOOKENDTRAILER,
		BOTTOMINSET,
		CACHELIB,
		CAP,
		CAPHEIGHT,
		CHARENCODING,
		CHARSET,
		CHECKSUM,
		CIRCULAR,
		CLASS,
		CLASSID,
		CODEBASE,
		CODETYPE,
		COLSPAN,
		COLUMNWIDTHS,
		COMMANDTYPE,
		COMMITON,
		CONDITION,
		CONTENTTYPE,
		COUNTER,
		CREDENTIALSERVERPOLICY,
		CRLSIGN,
		CURSORLOCATION,
		CURSORTYPE,
		DATACOLUMNCOUNT,
		DATAENCIPHERMENT,
		DATALENGTH,
		DATAMODE,
		DATANODE,
		DATAPREP,
		DATAROWCOUNT,
		DATASETINFO,
		DB,
		DECIPHERONLY,
		DEFAULTCHARWIDTH,
		DELAYEDOPEN,
		DELEGATE,
		DELIMITER,
		DESCENT,
		DEST,
		DESTOP,
		DESTVAR,
		DIGITALSIGNATURE,
		DISABLE,
		DISABLEALL,
		DOMREF,
		DUPLEXIMPOSITION,
		EMBEDPDF,
		EMFCONTEXT,
		ENABLE,
		ENCIPHERONLY,
		ENDCHAR,
		EOFACTION,
		ERRORCORRECTIONLEVEL,
		ERRORID,
		EVENTCONTENTTYPE,
		EXCLUDEALLCAPS,
		EXCLUDEINITIALCAP,
		EXECUTEIF,
		EXECUTETYPE,
		EXTENDSIZE,
		EXTENSION,
		FINAL,
		FLAGS,
		FONTHORIZONTALSCALE,
		FONTVERTICALSCALE,
		FORCE,
		FORMATS,
		FORMATTEST,
		FRACDIGITS,
		FRACTION,
		FROM,
		GENERICFAMILY,
		H,
		HALIGN,
		HIGHLIGHT,
		HSCROLLPOLICY,
		HSIZE,
		HAND,
		HANDLERFOR,
		HREF,
		HYPHENATE,
		ID,
		IMAGINGBBOX,
		INITSIZE,
		INITIAL,
		INITIALNUMBER,
		INTACT,
		INTERMEDIATE,
		INVERTED,
		ITALICANGLE,
		ITERATE,
		JOIN,
		KERNINGMODE,
		KEY,
		KEYAGREEMENT,
		KEYCERTSIGN,
		KEYENCIPHERMENT,
		LABELREF,
		LADDERCOUNT,
		LEADDIGITS,
		LEADER,
		LEFTINSET,
		LEGACYCONFIG,
		LETTERSPACING,
		LI,
		LINEHEIGHT,
		LINETHROUGH,
		LINETHROUGHPERIOD,
		LISTEN,
		LOCKTYPE,
		LONG,
		MARGINLEFT,
		MARGINRIGHT,
		MARK,
		MATCH,
		MAX,
		MAXCHARS,
		MAXENTRIES,
		MAXH,
		MAXLENGTH,
		MAXW,
		MEDIUMSTOCK,
		MEMBER,
		MEMBEROF,
		MERGE,
		MERGEMODE,
		MIN,
		MINH,
		MINW,
		MODULEHEIGHT,
		MODULEHEIGHTVARIABLE,
		MODULEWIDTH,
		MODULEWIDTHVARIABLE,
		MULTILINE,
		NAME,
		NEXT,
		NODETYPE,
		NONREPUDIATION,
		NULLTEST,
		NULLTYPE,
		NUMBERED,
		NUMBEROFCELLS,
		ODDOREVEN,
		OL,
		OPEN,
		ORIENTATION,
		ORPHANS,
		OUTPUTBELOW,
		OVERFLOWLEADER,
		OVERFLOWTARGET,
		OVERFLOWTRAILER,
		OVERLINE,
		OVERLINEPERIOD,
		OVERRIDE,
		PADDING,
		PAGEPOSITION,
		PARITY,
		PARSE,
		PASSTHROUGH,
		PASSWORDCHAR,
		PICKER,
		PITCH,
		PLACEMENT,
		POSTURE,
		PREFIX,
		PRESERVE,
		PREVIOUS,
		PREVIOUSSIBLING,
		PRINTCHECKDIGIT,
		PRINTERTYPE,
		PRINTSPEED,
		PRIORITY,
		PROGRAM,
		PSNAME,
		PUSHCHARACTERCOUNT,
		QUIETZONE,
		RADIUS,
		RADIXOFFSET,
		RATE,
		READONLY,
		RELATION,
		REMAINCHARACTERCOUNT,
		RESERVE,
		RESERVEH,
		RESTORESTATE,
		RETRYCOUNT,
		RETRYIN,
		RID,
		RIGHTINSET,
		ROLE,
		ROOT,
		ROTATE,
		ROUND,
		ROWCOLUMNRATIO,
		RUNAT,
		SAVE,
		SCALABLE,
		SCOPE,
		SCRIPTTEST,
		SERIALIZE,
		SERVER,
		SHAPE,
		SHAREDOM,
		SHORT,
		SIGN,
		SIGNATURETYPE,
		SIZE,
		SLEWSPEED,
		SLOPE,
		SOM,
		SOURCEABOVE,
		SOURCEBELOW,
		SPACEABOVE,
		SPACEBELOW,
		SQUARE,
		STARTANGLE,
		STARTCHAR,
		STARTNEW,
		STATELESS,
		STDHW,
		STDVW,
		STEPS,
		STOCK,
		STROKE,
		STYLETYPE,
		SUFFIX,
		SUPPORT,
		SWEEPANGLE,
		TABSDEFAULT,
		TABSTOPS,
		TARGET,
		TARGETTYPE,
		TEXTENCODING,
		TEXTENTRY,
		TEXTINDENT,
		TEXTLOCATION,
		THICKNESS,
		TIMEOUT,
		TOPINSET,
		TRACEINCLUDE,
		TRAILER,
		TRANSFERENCODING,
		TRANSIENT,
		TRAYIN,
		TRAYNUMBER,
		TRAYOUT,
		TRAYTYPE,
		TRUNCATE,
		UL,
		UNDERLINE,
		UNDERLINEPERIOD,
		UNICODERANGE,
		UNSIGNER,
		UPSMODE,
		URL,
		URLPOLICY,
		USAGE,
		USE,
		USEHREF,
		UUID,
		VALIGN,
		VALUEREF,
		VSCROLLPOLICY,
		VSIZE,
		VALIDDATACHARS,
		W,
		WEIGHT,
		WIDENARROWRATIO,
		WIDOWS,
		WORDCHARACTERCOUNT,
		WORDSPACINGMAXIMUM,
		WORDSPACINGMINIMUM,
		WORDSPACINGOPTIMUM,
		WRITINGSCRIPT,
		X,
		XHEIGHT,
		XDPCONTENT,
		XMLNS,
		Y
	};

//	TAG ENUM FOR ALL XFA NAMESPACED STRINGS
	/**
	 * Invalid tag.
	 */
    public static final int INVALID_ELEMENT = -1;
	/**
	 * The starting index of tags.
	 */
    public static final int XFA_START = 0;
	/**
	 * The #text node tag.
	 */
    public static final int TEXTNODETAG = XFA_START;
	/**
	 * The #xHTML node tag.
	 */
    public static final int RICHTEXTNODETAG = TEXTNODETAG +1;
	/**
	 * The #xml node tag.
	 */
    public static final int XMLMULTISELECTNODETAG = RICHTEXTNODETAG +1;
	/**
	 * The CR node tag.
	 */
    public static final int CRTAG = XMLMULTISELECTNODETAG +1;
    /**
     * The ESC node tag.
     */
    public static final int ESCTAG = CRTAG +1;
    /**
     * The FF node tag.
     */
    public static final int FFTAG = ESCTAG +1;
    /**
     * The LF node tag.
     */
    public static final int LFTAG = FFTAG +1;
    /**
     * The accessibleContent element tag.
     */
    public static final int ACCESSIBLECONTENTTAG = LFTAG +1;
    /**
     * The acrobat element tag.
     */
    public static final int ACROBATTAG = ACCESSIBLECONTENTTAG +1;
    /**
     * The acrobat7 element tag.
     */
    public static final int ACROBAT7TAG = ACROBATTAG +1;
    /**
     * The addFont element tag.
     */
    public static final int ADDFONTTAG = ACROBAT7TAG +1;
    /**
     * The addSilentPrint element tag.
     */
    public static final int ADDSILENTPRINTTAG = ADDFONTTAG +1;
    /**
     * The addViewerPreferences element tag.
     */
    public static final int ADDVIEWERPREFERENCESTAG = ADDSILENTPRINTTAG +1;
    /**
     * The adjustData element tag.
     */
    public static final int ADJUSTDATATAG = ADDVIEWERPREFERENCESTAG +1;
    /**
     * The adobe element tag.
     */
    public static final int ADOBETAG = ADJUSTDATATAG +1;
    /**
     * The adobeExtensionLevel element tag.
     */
    public static final int ADOBEEXTENSIONLEVELTAG = ADOBETAG +1;
    /**
     * The agent element tag.
     */
    public static final int AGENTTAG = ADOBEEXTENSIONLEVELTAG +1;
    /**
     * The alwaysEmbed element tag.
     */
    public static final int ALWAYSEMBEDTAG = AGENTTAG +1;
    /**
     * The amd element tag.
     */
    public static final int AMDTAG = ALWAYSEMBEDTAG +1;
    /**
     * The apperanceFilter element tag.
     */
	public static final int APPEARANCEFILTERTAG = AMDTAG +1;
    /**
     * The arc element tag.
     */
    public static final int ARCTAG = APPEARANCEFILTERTAG +1;
    /**
     * The area element tag.
     */
    public static final int AREATAG = ARCTAG +1;
    /**
     * The assist element tag.
     */
    public static final int ASSISTTAG = AREATAG +1;
    /**
     * The attributes element tag.
     */
    public static final int ATTRIBUTESTAG = ASSISTTAG +1;
    /**
     * The barcode element tag.
     */
    public static final int BARCODETAG = ATTRIBUTESTAG +1;
    /**
     * The barcodeDefinition element tag.
     */
    public static final int BARCODEDEFINITIONTAG = BARCODETAG +1;
    /**
     * The barcodes element tag.
     */
    public static final int BARCODESTAG = BARCODEDEFINITIONTAG +1;
    /**
     * The base element tag.
     */
    public static final int BASETAG = BARCODESTAG +1;
    /**
     * The batchOutput element tag.
     */
    public static final int BATCHOUTPUTTAG = BASETAG +1;
	/**
	 * The behaviorOverride element tag.
	 */
	public static final int BEHAVIOROVERRIDETAG = BATCHOUTPUTTAG +1;
    /**
     * The binary element tag.
     */
    public static final int BINARYTAG = BEHAVIOROVERRIDETAG +1;
    /**
     * The bindItems element tag.
     */
    public static final int BINDITEMSTAG = BINARYTAG +1;
    /**
     * The boolean element tag.
     */
    public static final int BOOLEANTAG = BINDITEMSTAG +1;
    /**
     * The border element tag.
     */
    public static final int BORDERTAG = BOOLEANTAG +1;
    /**
     * The button element tag.
     */
    public static final int BUTTONTAG = BORDERTAG +1;
    /**
     * The cache element tag.
     */
    public static final int CACHETAG = BUTTONTAG +1;
    /**
     * The calculate element tag.
     */
    public static final int CALCULATETAG = CACHETAG +1;
    /**
     * The calendarSymbols element tag.
     */
    public static final int CALENDARSYMBOLSTAG = CALCULATETAG +1;
    /**
     * The callXpr element tag.
     */
    public static final int CALLXPRTAG = CALENDARSYMBOLSTAG +1;
    /**
     * The callback element tag.
     */
    public static final int CALLBACKTAG = CALLXPRTAG +1;
    /**
     * The callout element tag.
     */
    public static final int CALLOUTTAG = CALLBACKTAG +1;
    /**
     * The caption element tag.
     */
    public static final int CAPTIONTAG = CALLOUTTAG +1;
    /**
     * The catch element tag.
     */
    public static final int CATCHTAG = CAPTIONTAG +1;
    /**
     * The certificate element tag.
     */
    public static final int CERTIFICATETAG = CATCHTAG +1;
    /**
     * The certificates element tag.
     */
    public static final int CERTIFICATESTAG = CERTIFICATETAG +1;
    /**
     * The charWidths element tag.
     */
    public static final int CHARWIDTHTAG = CERTIFICATESTAG +1;
    /**
     * The checkButton element tag.
     */
    public static final int CHECKBUTTONTAG = CHARWIDTHTAG +1;
    /**
     * The choiceList element tag.
     */
    public static final int CHOICELISTTAG = CHECKBUTTONTAG +1;
    /**
     * The color element tag.
     */
    public static final int COLORTAG = CHOICELISTTAG +1;
    /**
     * The comb element tag.
     */
    public static final int COMBTAG = COLORTAG +1;
    /**
     * The command element tag.
     */
    public static final int COMMANDTAG = COMBTAG +1;
    /**
     * The common element tag.
     */
    public static final int COMMONTAG = COMMANDTAG +1;
    /**
     * The compress element tag.
     */
    public static final int COMPRESSTAG = COMMONTAG +1;
    /**
     * The compressObjectStream element tag.
     */
    public static final int COMPRESSOBJECTSTREAMTAG =  COMPRESSTAG +1;
    /**
     * The compressLogicalStructure element tag.
     */
    public static final int COMPRESSLOGICALSTRUCTURETAG = COMPRESSOBJECTSTREAMTAG +1;
    /**
     * The compression element tag.
     */
    public static final int COMPRESSIONTAG = COMPRESSLOGICALSTRUCTURETAG  +1;
    /**
     * The config element tag.
     */
    public static final int CONFIGTAG = COMPRESSIONTAG +1;
    /**
     * The configurationKey element tag.
     */
    public static final int CONFIGURATIONKEYTAG = CONFIGTAG +1;
    /**
     * The configurationValue element tag.
     */
    public static final int CONFIGURATIONVALUETAG = CONFIGURATIONKEYTAG +1;
    /**
     * The conformance element tag.
     */
    public static final int CONFORMANCETAG = CONFIGURATIONVALUETAG +1;
    /**
     * The connect element tag.
     */
    public static final int CONNECTTAG = CONFORMANCETAG +1;
    /**
     * The connectString element tag.
     */
    public static final int CONNECTSTRINGTAG = CONNECTTAG +1;
    /**
     * The connectionData element tag.
     */
    public static final int CONNECTIONDATATAG = CONNECTSTRINGTAG +1;
    /**
     * The connectionSet element tag.
     */
    public static final int CONNECTIONSETTAG = CONNECTIONDATATAG +1;
    /**
     * The contentArea element tag.
     */
    public static final int CONTENTAREATAG = CONNECTIONSETTAG +1;
    /**
     * The contentCopy element tag.
     */
    public static final int CONTENTCOPYTAG = CONTENTAREATAG +1;
    /**
     * The controlCode element tag.
     */
    public static final int CONTROLCODETAG = CONTENTCOPYTAG +1;
    /**
     * The copies element tag.
     */
    public static final int COPIESTAG = CONTROLCODETAG +1;
    /**
     * The copy element tag.
     */
    public static final int COPYTAG = COPIESTAG +1;
    /**
     * The copyFrom element tag.
     */
    public static final int COPYFROMTAG = COPYTAG +1;
    /**
     * The copyTo element tag.
     */
    public static final int COPYTOTAG = COPYFROMTAG +1;
    /**
     * The corner element tag.
     */
    public static final int CORNERTAG = COPYTOTAG +1;
    /**
     * The creator element tag.
     */
    public static final int CREATORTAG = CORNERTAG +1;
    /**
     * The currencySymbol element tag.
     */
    public static final int CURRENCYSYMBOLTAG = CREATORTAG +1;
    /**
     * The currencySymbols element tag.
     */
    public static final int CURRENCYSYMBOLSTAG = CURRENCYSYMBOLTAG +1;
    /**
     * The currentPage element tag.
     */
    public static final int CURRENTPAGETAG = CURRENCYSYMBOLSTAG +1;
    /**
     * The dSigData element tag.
     */
    public static final int DSIGDATATAG = CURRENTPAGETAG +1;
    /**
     * The dataGroup element tag.
     */
    public static final int DATAGROUPTAG = DSIGDATATAG +1;
    /**
     * The dataModel element tag.
     */
    public static final int DATAMODELTAG = DATAGROUPTAG +1;
    /**
     * The dataSetCatch element tag.
     */
    public static final int DATASETCATCHTAG = DATAMODELTAG +1;
    /**
     * The dataSetIn element tag.
     */
    public static final int DATASETINTAG = DATASETCATCHTAG +1;
    /**
     * The dataSetOut element tag.
     */
    public static final int DATASETOUTTAG = DATASETINTAG +1;
    /**
     * The dataValue element tag.
     */
    public static final int DATAVALUETAG = DATASETOUTTAG +1;
    /**
     * The date element tag.
     */
    public static final int DATETAG = DATAVALUETAG +1;
    /**
     * The datePattern element tag.
     */
    public static final int DATEPATTERNTAG = DATETAG +1;
    /**
     * The datePatterns element tag.
     */
    public static final int DATEPATTERNSTAG = DATEPATTERNTAG +1;
    /**
     * The dateTime element tag.
     */
    public static final int DATETIMETAG = DATEPATTERNSTAG +1;
    /**
     * The dateTimeEdit element tag.
     */
    public static final int DATETIMEEDITTAG = DATETIMETAG +1;
    /**
     * The dateTimeSymbols element tag.
     */
    public static final int DATETIMESYMBOLSTAG = DATETIMEEDITTAG +1;
    /**
     * The day element tag.
     */
    public static final int DAYTAG = DATETIMESYMBOLSTAG +1;
    /**
     * The dayNames element tag.
     */
    public static final int DAYNAMESTAG = DAYTAG +1;
    /**
     * The debug element tag.
     */
    public static final int DEBUGTAG = DAYNAMESTAG +1;
    /**
     * The decimal element tag.
     */
    public static final int DECIMALTAG = DEBUGTAG +1;
    /**
     * The defaultTypeface element tag.
     */
    public static final int DEFAULTTYPEFACETAG = DECIMALTAG +1;
    /**
     * The defaultUi element tag.
     */
    public static final int DEFAULTUITAG = DEFAULTTYPEFACETAG +1;
    /**
     * The delete element tag.
     */
    public static final int DELETETAG = DEFAULTUITAG +1;
    /**
     * The destination element tag.
     */
    public static final int DESTINATIONTAG = DELETETAG +1;
    /**
     * The deviceInfo element tag.
     */
    public static final int DEVICEINFOTAG = DESTINATIONTAG +1;
    /**
     * The deviceUnits element tag.
     */
    public static final int DEVICEUNITSTAG = DEVICEINFOTAG +1;
    /**
     * The digestMethod element tag.
     */
    public static final int DIGESTMETHODTAG = DEVICEUNITSTAG  +1;
    /**
     * The digestMethods element tag.
     */
    public static final int DIGESTMETHODSTAG = DIGESTMETHODTAG +1;
    /**
     * The documentAssembly element tag.
     */
    public static final int DOCUMENTASSEMBLYTAG = DIGESTMETHODSTAG +1;
    /**
     * The draw element tag.
     */
    public static final int DRAWTAG = DOCUMENTASSEMBLYTAG +1;
    /**
     * The driver element tag.
     */
    public static final int DRIVERTAG = DRAWTAG +1;
    /**
     * The duplexOption element tag.
     */
    public static final int DUPLEXOPTIONTAG = DRIVERTAG +1;
    /**
     * The dynamicRender element tag.
     */
    public static final int DYNAMICRENDERTAG = DUPLEXOPTIONTAG +1;
    /**
     * The edge element tag.
     */
    public static final int EDGETAG = DYNAMICRENDERTAG +1;
    /**
     * The effectiveInputPolicy element tag.
     */
    public static final int EFFECTIVEINPUTPOLICYTAG = EDGETAG +1;
    /**
     * The effectiveOutputPolicy element tag.
     */
    public static final int EFFECTIVEOUTPUTPOLICYTAG = EFFECTIVEINPUTPOLICYTAG +1;
    /**
     * The else element tag.
     */
    public static final int ELSETAG = EFFECTIVEOUTPUTPOLICYTAG +1;
    /**
     * The elseIf element tag.
     */
    public static final int ELSEIFTAG = ELSETAG +1;
    /**
     * The embed element tag.
     */
    public static final int EMBEDTAG = ELSEIFTAG +1;
    /**
     * The embedRenderedOutput element tag.
     */
    public static final int EMBEDRENDEREDOUTPUTTAG = EMBEDTAG +1;
    /**
     * The encodings element tag.
     */
    public static final int ENCODINGSTAG = EMBEDRENDEREDOUTPUTTAG +1;
    /**
     * The encrypt element tag.
     */
    public static final int ENCRYPTTAG = ENCODINGSTAG +1;
    /**
     * The encryption element tag.
     */
    public static final int ENCRYPTIONTAG = ENCRYPTTAG +1;
    /**
     * The encryptionLevel element tag.
     */
    public static final int ENCRYPTIONLEVELTAG = ENCRYPTIONTAG +1;
    /**
     * The enforce element tag.
     */
    public static final int ENFORCETAG = ENCRYPTIONLEVELTAG +1;
    /**
     * The equate element tag.
     */
    public static final int EQUATETAG = ENFORCETAG +1;
    /**
     * The equateRange element tag.
     */
    public static final int EQUATERANGETAG = EQUATETAG +1;
    /**
     * The era element tag.
     */
    public static final int ERATAG = EQUATERANGETAG +1;
    /**
     * The eraNames element tag.
     */
    public static final int ERANAMESTAG = ERATAG +1;
    /**
     * The error element tag.
     */
    public static final int ERRORTAG = ERANAMESTAG +1;
    /**
     * The errorInfo element tag.
     */
    public static final int ERRORINFOTAG = ERRORTAG +1;
    /**
     * The event element tag.
     */
    public static final int EVENTTAG = ERRORINFOTAG +1;
    /**
     * The exData element tag.
     */
    public static final int EXDATATAG = EVENTTAG +1;
    /**
     * The exObject element tag.
     */
    public static final int EXOBJECTTAG = EXDATATAG +1;
    /**
     * The exclGroup element tag.
     */
    public static final int EXCLGROUPTAG = EXOBJECTTAG +1;
    /**
     * The exclude element tag.
     */
    public static final int EXCLUDETAG = EXCLGROUPTAG +1;
    /**
     * The excludeNS element tag.
     */
    public static final int EXCLUDENSTAG = EXCLUDETAG +1;
    /**
     * The execute element tag.
     */
    public static final int EXECUTETAG = EXCLUDENSTAG +1;
    /**
     * The exitStatus element tag.
     */
    public static final int EXITSTATUSTAG = EXECUTETAG +1;
    /**
     * The extras element tag.
     */
    public static final int EXTRASTAG = EXITSTATUSTAG +1;
    /**
     * The field element tag.
     */
    public static final int FIELDTAG = EXTRASTAG +1;
    /**
     * The fill element tag.
     */
    public static final int FILLTAG = FIELDTAG +1;
    /**
     * The filter element tag.
     */
    public static final int FILTERTAG = FILLTAG +1;
    /**
     * The flipLabel element tag.
     */
    public static final int FLIPLABELTAG = FILTERTAG +1;
    /**
     * The float element tag.
     */
    public static final int FLOATTAG = FLIPLABELTAG +1;
    /**
     * The font element tag.
     */
    public static final int FONTTAG = FLOATTAG +1;
    /**
     * The fontIndex element tag.
     */
    public static final int FONTINDEXTAG = FONTTAG +1;
    /**
     * The fontInfo element tag.
     */
    public static final int FONTINFOTAG = FONTINDEXTAG +1;
    /**
     * The fontResource element tag.
     */
    public static final int FONTRESOURCETAG = FONTINFOTAG +1;
    /**
     * The fontSelect element tag.
     */
    public static final int FONTSELECTTAG = FONTRESOURCETAG +1;
    /**
     * The for element tag.
     */
    public static final int FORTAG = FONTSELECTTAG +1;
    /**
     * The form element tag.
     */
    public static final int FORMTAG = FORTAG +1;
    /**
     * The formFieldFilling element tag.
     */
    public static final int FORMFIELDFILLINGTAG = FORMTAG +1;
    /**
     * The group element tag.
     */
    public static final int GROUPTAG = FORMFIELDFILLINGTAG +1;
    /**
     * The groupParent element tag.
     */
    public static final int GROUPPARENTTAG = GROUPTAG +1;
    /**
     * The handler element tag.
     */
    public static final int HANDLERTAG = GROUPPARENTTAG +1;
    /**
     * The htmlMerge element tag.
     */
    public static final int HTMLMERGETAG = HANDLERTAG  +1;
	/**
	 * The hyphenation element tag.
	 */
	public static final int HYPHENATIONTAG = HTMLMERGETAG +1;
    /**
     * The if element tag.
     */
    public static final int IFTAG = HYPHENATIONTAG +1;
    /**
     * The ifEmpty element tag.
     */
    public static final int IFEMPTYTAG = IFTAG +1;
    /**
     * The image element tag.
     */
    public static final int IMAGETAG = IFEMPTYTAG +1;
    /**
     * The imageEdit element tag.
     */
    public static final int IMAGEEDITTAG = IMAGETAG +1;
    /**
     * The in element tag.
     */
    public static final int INTAG = IMAGEEDITTAG +1;
    /**
     * The includeXDPContent element tag.
     */
    public static final int INCLUDEXDPCONTENTTAG = INTAG +1;
    /**
     * The incrementalLoad element tag.
     */
    public static final int INCREMENTALLOADTAG = INCLUDEXDPCONTENTTAG +1;
    /**
     * The incrementalMerge element tag.
     */
    public static final int INCREMENTALMERGETAG = INCREMENTALLOADTAG +1;
    /**
     * The ini element tag.
     */
    public static final int INITAG = INCREMENTALMERGETAG +1;
    /**
     * The initVar element tag.
     */
    public static final int INITVARTAG = INITAG +1;
    /**
     * The inputTrays element tag.
     */
    public static final int INPUTTRAYSTAG = INITVARTAG +1;
    /**
     * The insert element tag.
     */
    public static final int INSERTTAG = INPUTTRAYSTAG +1;
    /**
     * The instanceManager element tag.
     */
    public static final int INSTANCEMANAGERTAG = INSERTTAG +1;
    /**
     * The integer element tag.
     */
    public static final int INTEGERTAG = INSTANCEMANAGERTAG +1;
    /**
     * The interactive element tag.
     */
    public static final int INTERACTIVETAG = INTEGERTAG +1;
    /**
     * The issuers element tag.
     */
    public static final int ISSUERSTAG = INTERACTIVETAG +1;
    /**
     * The items element tag.
     */
    public static final int ITEMSTAG = ISSUERSTAG +1;
    /**
     * The jog element tag.
     */
    public static final int JOGTAG = ITEMSTAG +1;
    /**
     * The keep element tag.
     */
    public static final int KEEPTAG = JOGTAG +1;
    /**
     * The keyUsage element tag.
     */
	public static final int KEYUSAGETAG = KEEPTAG +1;
    /**
     * The line element tag.
     */
    public static final int LINETAG = KEYUSAGETAG +1;
    /**
     * The lineStyle element tag.
     */
    public static final int LINESTYLETAG = LINETAG +1;
    /**
     * The linear element tag.
     */
    public static final int LINEARTAG = LINESTYLETAG +1;
    /**
     * The linearized element tag.
     */
    public static final int LINEARIZEDTAG = LINEARTAG +1;
    /**
     * The listFont element tag.
     */
    public static final int LISTFONTTAG = LINEARIZEDTAG +1;
    /**
     * The local element tag.
     */
    public static final int LOCALTAG = LISTFONTTAG +1;
    /**
     * The localeSet element tag.
     */
    public static final int LOCALESETTAG = LOCALTAG +1;
    /**
     * The lockDocument element tag.
     */
	public static final int LOCKDOCUMENTTAG = LOCALESETTAG +1;
    /**
     * The log element tag.
     */
    public static final int LOGTAG = LOCKDOCUMENTTAG +1;
    /**
     * The macro element tag.
     */
    public static final int MACROTAG = LOGTAG +1;
    /**
     * The macroCache element tag.
     */
    public static final int MACROCACHETAG = MACROTAG +1;
    /**
     * The manifest element tag.
     */
    public static final int MANIFESTTAG = MACROCACHETAG +1;
    /**
     * The map element tag.
     */
    public static final int MAPTAG = MANIFESTTAG +1;
    /**
     * The margin element tag.
     */
    public static final int MARGINTAG = MAPTAG +1;
    /**
     * The masterPassword element tag.
     */
    public static final int MASTERPASSWORDTAG = MARGINTAG +1;
    /**
     * The mdp element tag.
     */
    public static final int MDPTAG = MASTERPASSWORDTAG +1;
    /**
     * The medium element tag.
     */
    public static final int MEDIUMTAG = MDPTAG +1;
    /**
     * The mediumInfo element tag.
     */
    public static final int MEDIUMINFOTAG = MEDIUMTAG +1;
    /**
     * The meridiem element tag.
     */
    public static final int MERIDIEMTAG = MEDIUMINFOTAG +1;
    /**
     * The meridiemNames element tag.
     */
    public static final int MERIDIEMNAMESTAG = MERIDIEMTAG +1;
    /**
     * The messaging element tag.
     */
    public static final int MESSAGINGTAG = MERIDIEMNAMESTAG +1;
    /**
     * The metrics element tag.
     */
    public static final int METRICSTAG = MESSAGINGTAG +1;
    /**
     * The modifyAnnots element tag.
     */
    public static final int MODIFYANNOTSTAG = METRICSTAG +1;
    /**
     * The month element tag.
     */
    public static final int MONTHTAG = MODIFYANNOTSTAG +1;
    /**
     * The monthNames element tag.
     */
    public static final int MONTHNAMESTAG = MONTHTAG +1;
    /**
     * The msgId element tag.
     */
    public static final int MSGIDTAG = MONTHNAMESTAG +1;
    /**
     * The nameAttr element tag.
     */
    public static final int NAMEATTRTAG = MSGIDTAG +1;
    /**
     * The network element tag.
     */
    public static final int NETWORKTAG = NAMEATTRTAG +1;
    /**
     * The neverEmbed element tag.
     */
    public static final int NEVEREMBEDTAG = NETWORKTAG +1;
    /**
     * The node element tag.
     */
    public static final int NODETAG = NEVEREMBEDTAG +1;
    /**
     * The null element tag.
     */
    public static final int NULLTAG = NODETAG +1;
    /**
     * The numberOfCopies element tag.
     */
    public static final int NUMBEROFCOPIESTAG = NULLTAG +1;
    /**
     * The numberPattern element tag.
     */
    public static final int NUMBERPATTERNTAG = NUMBEROFCOPIESTAG +1;
    /**
     * The numberPatterns element tag.
     */
    public static final int NUMBERPATTERNSTAG = NUMBERPATTERNTAG +1;
    /**
     * The numberSymbol element tag.
     */
    public static final int NUMBERSYMBOLTAG = NUMBERPATTERNSTAG +1;
    /**
     * The numberSymbols element tag.
     */
    public static final int NUMBERSYMBOLSTAG = NUMBERSYMBOLTAG +1;
    /**
     * The numericEdit element tag.
     */
    public static final int NUMERICEDITTAG = NUMBERSYMBOLSTAG +1;
    /**
     * The occur element tag.
     */
    public static final int OCCURTAG = NUMERICEDITTAG +1;
    /**
     * The oid element tag.
     */
    public static final int OIDTAG = OCCURTAG +1;
    /**
     * The oids element tag.
     */
    public static final int OIDSTAG = OIDTAG +1;
    /**
     * The onError element tag.
     */
    public static final int ONERRORTAG = OIDSTAG +1;
    /**
     * The openAction element tag.
     */
    public static final int OPENACTIONTAG = ONERRORTAG +1;
    /**
     * The option element tag.
     */
    public static final int OPTIONTAG = OPENACTIONTAG +1;
    /**
     * The out element tag.
     */
    public static final int OUTTAG = OPTIONTAG +1;
    /**
     * The outputBin element tag.
     */
    public static final int OUTPUTBINTAG = OUTTAG +1;
    /**
     * The outputTrayDefinition element tag.
     */
    public static final int OUTPUTTRAYDEFINITIONTAG = OUTPUTBINTAG +1;
    /**
     * The outputTrays element tag.
     */
    public static final int OUTPUTTRAYSTAG =  OUTPUTTRAYDEFINITIONTAG +1;
    /**
     * The outputXSL element tag.
     */
    public static final int OUTPUTXSLTAG = OUTPUTTRAYSTAG +1;
    /**
     * The overprint element tag.
     */
    public static final int OVERPRINTTAG = OUTPUTXSLTAG +1;
    /**
     * The packet element tag.
     */
    public static final int PACKETTAG = OVERPRINTTAG +1;
    /**
     * The packets element tag.
     */
    public static final int PACKETSTAG = PACKETTAG +1;
    /**
     * The pageArea element tag.
     */
    public static final int PAGEAREATAG = PACKETSTAG +1;
    /**
     * The pageOffset element tag.
     */
    public static final int PAGEOFFSETTAG = PAGEAREATAG +1;
    /**
     * The pageRange element tag.
     */
    public static final int PAGERANGETAG = PAGEOFFSETTAG +1;
    /**
     * The pageSet element tag.
     */
    public static final int PAGESETTAG = PAGERANGETAG +1;
    /**
     * The pagination element tag.
     */
    public static final int PAGINATIONTAG = PAGESETTAG +1;
    /**
     * The paginationOverride element tag.
     */
    public static final int PAGINATIONOVERRIDETAG = PAGINATIONTAG +1;
    /**
     * The para element tag.
     */
    public static final int PARATAG = PAGINATIONOVERRIDETAG +1;
    /**
     * The param element tag.
     */
    public static final int PARAMTAG = PARATAG +1;
    /**
     * The parameter element tag.
     */
    public static final int PARAMETERTAG = PARAMTAG +1;
    /**
     * The part element tag.
     */
    public static final int PARTTAG = PARAMETERTAG +1;
    /**
     * The password element tag.
     */
    public static final int PASSWORDTAG = PARTTAG +1;
    /**
     * The passwordEdit element tag.
     */
    public static final int PASSWORDEDITTAG = PASSWORDTAG +1;
    /**
     * The path element tag.
     */
    public static final int PATHTAG = PASSWORDEDITTAG +1;
    /**
     * The pattern element tag.
     */
    public static final int PATTERNTAG = PATHTAG +1;
    /**
     * The pcl element tag.
     */
    public static final int PCLTAG = PATTERNTAG +1;
    /**
     * The pdf element tag.
     */
    public static final int PDFTAG = PCLTAG +1;
    /**
     * The pdfa element tag.
     */
    public static final int PDFATAG = PDFTAG +1;
    /**
     * The pdfMerge element tag.
     */
    public static final int PDFMERGETAG = PDFATAG +1;
    /**
     * The pdl element tag.
     */
    public static final int PDLTAG = PDFMERGETAG +1;
    /**
     * The pickTrayByPDFSize element tag.
     */
    public static final int PICKTRAYBYPDFSIZETAG = PDLTAG +1;
    /**
     * The picture element tag.
     */
    public static final int PICTURETAG = PICKTRAYBYPDFSIZETAG +1;
    /**
     * The plaintextMetadata element tag.
     */
    public static final int PLAINTEXTMETADATATAG = PICTURETAG +1;
    /**
     * The preambleFile element tag.
     */
    public static final int PREAMBLEFILETAG = PLAINTEXTMETADATATAG +1;
    /**
     * The present element tag.
     */
    public static final int PRESENTTAG = PREAMBLEFILETAG +1;
    /**
     * The print element tag.
     */
    public static final int PRINTTAG = PRESENTTAG +1;
    /**
     * The printHighQuality element tag.
     */
    public static final int PRINTHIGHQUALITYTAG = PRINTTAG +1;
    /**
     * The printerName element tag.
     */
    public static final int PRINTERNAMETAG = PRINTHIGHQUALITYTAG +1;
    /**
     * The printScaling element tag.
     */
    public static final int PRINTSCALINGTAG = PRINTERNAMETAG +1;
    /**
     * The producer element tag.
     */
    public static final int PRODUCERTAG = PRINTSCALINGTAG +1;
    /**
     * The proto element tag.
     */
    public static final int PROTOTAG = PRODUCERTAG +1;
    /**
     * The ps element tag.
     */
    public static final int PSTAG = PROTOTAG +1;
    /**
     * The psMap element tag.
     */
    public static final int PSMAPTAG = PSTAG +1;
    /**
     * The query element tag.
     */
    public static final int QUERYTAG = PSMAPTAG +1;
    /**
     * The radial element tag.
     */
    public static final int RADIALTAG = QUERYTAG +1;
    /**
     * The range element tag.
     */
    public static final int RANGETAG = RADIALTAG +1;
    /**
     * The reason element tag.
     */
    public static final int REASONTAG = RANGETAG +1;
    /**
     * The reasons element tag.
     */
    public static final int REASONSTAG = REASONTAG +1;
    /**
     * The record element tag.
     */
    public static final int RECORDTAG = REASONSTAG +1;
    /**
     * The recordSet element tag.
     */
    public static final int RECORDSETTAG = RECORDTAG +1;
    /**
     * The rectangle element tag.
     */
    public static final int RECTANGLETAG = RECORDSETTAG +1;
    /**
     * The recursive element tag.
     */
    public static final int RECURSIVETAG = RECTANGLETAG +1;
    /**
     * The removeFont element tag.
     */
    public static final int REMOVEFONTTAG = RECURSIVETAG +1;
    /**
     * The rename element tag.
     */
    public static final int RENAMETAG = REMOVEFONTTAG +1;
    /**
     * The renderAs element tag.
     */
    public static final int RENDERASTAG = RENAMETAG +1;
    /**
     * The renderCache element tag.
     */
    public static final int RENDERCACHETAG = RENDERASTAG +1;
    /**
     * The renderLib element tag.
     */
    public static final int RENDERLIBTAG = RENDERCACHETAG +1;
    /**
     * The renderPolicy element tag.
     */
    public static final int RENDERPOLICYTAG = RENDERLIBTAG +1;
    /**
     * The resolveFont element tag.
     */
    public static final int RESOLVEFONTTAG = RENDERPOLICYTAG +1;
    /**
     * The respond element tag.
     */
    public static final int RESPONDTAG = RESOLVEFONTTAG +1;
    /**
     * The result element tag.
     */
    public static final int RESULTTAG = RESPONDTAG +1;
    /**
     * The rootElement element tag.
     */
    public static final int ROOTELEMENTTAG = RESULTTAG +1;
    /**
     * The runScripts element tag.
     */
    public static final int RUNSCRIPTSTAG = ROOTELEMENTTAG +1;
    /**
     * The scriptModel element tag.
     */
    public static final int SCRIPTMODELTAG = RUNSCRIPTSTAG +1;
    /**
     * The searchFont element tag.
     */
    public static final int SEARCHFONTTAG = SCRIPTMODELTAG +1;
    /**
     * The seq element tag.
     */
    public static final int SEQTAG = SEARCHFONTTAG +1;
    /**
     * The set element tag.
     */
    public static final int SETTAG = SEQTAG +1;
    /**
     * The setProperty element tag.
     */
    public static final int SETPROPERTYTAG = SETTAG +1;
    /**
     * The severity element tag.
     */
    public static final int SEVERITYTAG = SETPROPERTYTAG +1;
    /**
     * The signData element tag.
     */
    public static final int SIGNDATATAG = SEVERITYTAG +1;
    /**
     * The signature element tag.
     */
    public static final int SIGNATURETAG = SIGNDATATAG +1;
    /**
     * The signing element tag.
     */
    public static final int SIGNINGTAG = SIGNATURETAG +1;
    /**
     * The silentPrint element tag.
     */
    public static final int SILENTPRINTTAG = SIGNINGTAG +1;
    /**
     * The soapAction element tag.
     */
    public static final int SOAPACTIONTAG = SILENTPRINTTAG +1;
    /**
     * The soapAddress element tag.
     */
    public static final int SOAPADDRESSTAG = SOAPACTIONTAG +1;
    /**
     * The solid element tag.
     */
    public static final int SOLIDTAG = SOAPADDRESSTAG +1;
    /**
     * The sourceSet element tag.
     */
    public static final int SOURCESETTAG = SOLIDTAG +1;
    /**
     * The speak element tag.
     */
    public static final int SPEAKTAG = SOURCESETTAG +1;
    /**
     * The staple element tag.
     */
    public static final int STAPLETAG = SPEAKTAG +1;
    /**
     * The startNode element tag.
     */
    public static final int STARTNODETAG = STAPLETAG +1;
    /**
     * The startPage element tag.
     */
    public static final int STARTPAGETAG = STARTNODETAG +1;
    /**
     * The status element tag.
     */
    public static final int STATUSTAG = STARTPAGETAG +1;
    /**
     * The stderr element tag.
     */
    public static final int STDERRTAG = STATUSTAG +1;
    /**
     * The stdin element tag.
     */
    public static final int STDINTAG = STDERRTAG +1;
    /**
     * The stdout element tag.
     */
    public static final int STDOUTTAG = STDINTAG +1;
    /**
     * The stipple element tag.
     */
    public static final int STIPPLETAG = STDOUTTAG +1;
    /**
     * The subform element tag.
     */
    public static final int SUBFORMTAG = STIPPLETAG +1;
    /**
     * The subformSet element tag.
     */
    public static final int SUBFORMSETTAG = SUBFORMTAG +1;
    /**
     * The subjectDN element tag.
     */
    public static final int SUBJECTDNTAG = SUBFORMSETTAG +1;
    /**
     * The subjectDNs element tag.
     */
    public static final int SUBJECTDNSTAG = SUBJECTDNTAG +1;
    /**
     * The submit element tag.
     */
    public static final int SUBMITTAG = SUBJECTDNSTAG +1;
    /**
     * The submitFormat element tag.
     */
    public static final int SUBMITFORMATTAG = SUBMITTAG +1;
    /**
     * The submitUrl element tag.
     */
    public static final int SUBMITURLTAG = SUBMITFORMATTAG +1;
    /**
     * The subsetBelow element tag.
     */
    public static final int SUBSETBELOWTAG = SUBMITURLTAG +1;
    /**
     * The supportedEncodings element tag.
     */
    public static final int SUPPORTEDENCODINGSTAG = SUBSETBELOWTAG +1;
    /**
     * The supportedTechnologies element tag.
     */
    public static final int SUPPORTEDTECHNOLOGIESTAG = SUPPORTEDENCODINGSTAG +1;
    /**
     * The suppressBanner element tag.
     */
    public static final int SUPPRESSBANNERTAG = SUPPORTEDTECHNOLOGIESTAG +1;
    /**
     * The system element tag.
     */
    public static final int SYSTEMTAG = SUPPRESSBANNERTAG +1;
    /**
     * The tagged element tag.
     */
    public static final int TAGGEDTAG = SYSTEMTAG +1;
    /**
     * The taggedMode element tag.
     */
    public static final int TAGGEDMODETAG = TAGGEDTAG +1;
    /**
     * The technology element tag.
     */
    public static final int TECHNOLOGYTAG = TAGGEDMODETAG +1;
    /**
     * The temp element tag.
     */
    public static final int TEMPTAG = TECHNOLOGYTAG +1;
    /**
     * The template element tag.
     */
    public static final int TEMPLATETAG = TEMPTAG +1;
    /**
     * The templateCache element tag.
     */
    public static final int TEMPLATECACHETAG = TEMPLATETAG +1;
    /**
     * The textEdit element tag.
     */
    public static final int TEXTEDITTAG = TEMPLATECACHETAG +1;
    /**
     * The then element tag.
     */
    public static final int THENTAG = TEXTEDITTAG +1;
    /**
     * The time element tag.
     */
    public static final int TIMETAG = THENTAG +1;
    /**
     * The timePattern element tag.
     */
    public static final int TIMEPATTERNTAG = TIMETAG +1;
    /**
     * The timePatterns element tag.
     */
    public static final int TIMEPATTERNSTAG = TIMEPATTERNTAG +1;
    /**
     * The toolTip element tag.
     */
    public static final int TOOLTIPTAG = TIMEPATTERNSTAG +1;
    /**
     * The tp element tag.
     */
    public static final int TRANSACTIONPROCESSORTAG = TOOLTIPTAG +1;
    /**
     * The trace element tag.
     */
    public static final int TRACETAG = TRANSACTIONPROCESSORTAG +1;
    /**
     * The traceDom element tag.
     */
    public static final int TRACEDOMTAG = TRACETAG +1;
    /**
     * The traceFile element tag.
     */
    public static final int TRACEFILETAG = TRACEDOMTAG +1;
    /**
     * The traceTo element tag.
     */
    public static final int TRACETOTAG = TRACEFILETAG +1;
    /**
     * The transform element tag.
     */
    public static final int TRANSFORMTAG = TRACETOTAG +1;
    /**
     * The traversal element tag.
     */
    public static final int TRAVERSALTAG = TRANSFORMTAG +1;
    /**
     * The traverse element tag.
     */
    public static final int TRAVERSETAG = TRAVERSALTAG +1;
    /**
     * The typefaces element tag.
     */
    public static final int TYPEFACESTAG = TRAVERSETAG +1;
    /**
     * The inputTrayDefinition element tag.
     */
    public static final int INPUTTRAYDEFINITIONTAG = TYPEFACESTAG +1;
    /**
     * The ui element tag.
     */
    public static final int UITAG = INPUTTRAYDEFINITIONTAG +1;
    /**
     * The update element tag.
     */
    public static final int UPDATETAG = UITAG +1;
    /**
     * The updateXDC element tag.
     */
    public static final int UPDATEXDCTAG = UPDATETAG +1;
    /**
     * The uri element tag.
     */
    public static final int URITAG = UPDATEXDCTAG +1;
    /**
     * The user element tag.
     */
    public static final int USERTAG = URITAG +1;
    /**
     * The userPassword element tag.
     */
    public static final int USERPASSWORDTAG = USERTAG +1;
    /**
     * The validateApprovalSignatures element tag.
     */
    public static final int VALIDATEAPPROVALSIGNATURESTAG = USERPASSWORDTAG +1;
    /**
     * The validationMessaging element tag.
     */
    public static final int VALIDATIONMESSAGINGTAG = VALIDATEAPPROVALSIGNATURESTAG +1;
    /**
     * The var element tag.
     */
    public static final int VARTAG = VALIDATIONMESSAGINGTAG +1;
    /**
     * The variables element tag.
     */
    public static final int VARIABLESTAG = VARTAG +1;
    /**
     * The versionControl element tag.
     */
    public static final int VERSIONCONTROLTAG = VARIABLESTAG + 1;
    /**
     * The viewerPreferences element tag.
     */
    public static final int VIEWERPREFERENCESTAG = VERSIONCONTROLTAG + 1;
    /**
     * The webClient element tag.
     */
    public static final int WEBCLIENTTAG = VIEWERPREFERENCESTAG +1;
    /**
     * The while element tag.
     */
    public static final int WHILETAG = WEBCLIENTTAG +1;
    /**
     * The whitespace element tag.
     */
    public static final int WHITESPACETAG = WHILETAG +1;
    /**
     * The window element tag.
     */
    public static final int WINDOWTAG = WHITESPACETAG +1;
    /**
     * The wsdlAddress element tag.
     */
    public static final int WSDLADDRESSTAG = WINDOWTAG +1;
    /**
     * The wsdlConnection element tag.
     */
    public static final int WSDLCONNECTIONTAG = WSDLADDRESSTAG +1;
    /**
     * The xci element tag.
     */
    public static final int XCITAG = WSDLCONNECTIONTAG +1;
    /**
     * The xdc element tag.
     */
    public static final int XDCTAG = XCITAG +1;
    /**
     * The xdcFontAgent element tag.
     */
    public static final int XDCFONTAGENTTAG = XDCTAG +1;
    /**
     * The xdp element tag.
     */
    public static final int XDPTAG = XDCFONTAGENTTAG +1;
    /**
     * The xfa element tag.
     */
    public static final int XFATAG = XDPTAG +1;
    /**
     * The xft element tag.
     */
    public static final int XFTTAG = XFATAG +1;
    /**
     * The xmlConnection element tag.
     */
    public static final int XMLCONNECTIONTAG = XFTTAG +1;
    /**
     * The xpr element tag.
     */
    public static final int XPRTAG = XMLCONNECTIONTAG +1;
    /**
     * The xprModel element tag.
     */
    public static final int XPRMODELTAG = XPRTAG +1;
    /**
     * The xprSource element tag.
     */
    public static final int XPRSOURCETAG = XPRMODELTAG +1;
    /**
     * The xsdConnection element tag.
     */
    public static final int XSDCONNECTIONTAG = XPRSOURCETAG +1;
    /**
     * The xsl element tag.
     */
    public static final int XSLTAG = XSDCONNECTIONTAG +1;
    /**
     * The zpl element tag.
     */
    public static final int ZPLTAG = XSLTAG +1;
    /**
	 * The ending index of element (only) tags.
     */
    public static final int XFA_ELEMENTS = ZPLTAG;
    /**
	 * The schema defaults tag.
     */
    public static final int SCHEMA_DEFAULTTAG = ZPLTAG +1;
    /**
     * The accept element or attribute tag.
     */
    public static final int ACCEPTTAG = SCHEMA_DEFAULTTAG + 1;
    /**
     * The bind element or attribute tag.
     */
    public static final int BINDTAG = ACCEPTTAG +1;
    /**
     * The bookend element or attribute tag.
     */
    public static final int BOOKENDTAG = BINDTAG +1;
    /**
     * The break element or attribute tag.
     */
    public static final int BREAKTAG = BOOKENDTAG +1;
    /**
     * The breakAfter element or attribute tag.
     */
    public static final int BREAKAFTERTAG = BREAKTAG +1;
    /**
     * The breakBefore element or attribute tag.
     */
    public static final int BREAKBEFORETAG = BREAKAFTERTAG +1;
    /**
     * The cSpace element or attribute tag.
     */
    public static final int CSPACETAG = BREAKBEFORETAG +1;
    /**
     * The change element or attribute tag.
     */
    public static final int CHANGETAG = CSPACETAG +1;
    /**
     * The connection element or attribute tag.
     */
    public static final int CONNECTIONTAG = CHANGETAG +1;
    /**
     * The data element or attribute tag.
     */
    public static final int DATATAG = CONNECTIONTAG +1;
    /**
     * The dataDescription element or attribute tag.
     */
    public static final int DATADESCRIPTIONTAG = DATATAG +1;
    /**
     * The desc element or attribute tag.
     */
    public static final int DESCTAG = DATADESCRIPTIONTAG +1;
    /**
     * The encoding element or attribute tag.
     */
    public static final int ENCODINGTAG = DESCTAG +1;
    /**
     * The file element or attribute tag.
     */
    public static final int FILETAG = ENCODINGTAG +1;
    /**
     * The format element or attribute tag.
     */
    public static final int FORMATTAG = FILETAG +1;
    /**
     * The input element or attribute tag.
     */
    public static final int INPUTTAG = FORMATTAG +1;
    /**
     * The layout element or attribute tag.
     */
    public static final int LAYOUTTAG = INPUTTAG +1;
    /**
     * The level element or attribute tag.
     */
    public static final int LEVELTAG = LAYOUTTAG +1;
    /**
     * The link element or attribute tag.
     */
    public static final int LINKTAG = LEVELTAG +1;
    /**
     * The locale element or attribute tag.
     */
    public static final int LOCALETAG = LINKTAG +1;
    /**
     * The lock element or attribute tag.
     */
    public static final int LOCKTAG = LOCALETAG +1;
    /**
     * The message element or attribute tag.
     */
    public static final int MESSAGETAG = LOCKTAG +1;
    /**
     * The metaData element or attribute tag.
     */
    public static final int METADATATAG = MESSAGETAG +1;
    /**
     * The mode element or attribute tag.
     */
    public static final int MODETAG = METADATATAG +1;
    /**
     * The operation element or attribute tag.
     */
    public static final int OPERATIONTAG = MODETAG +1;
    /**
     * The output element or attribute tag.
     */
    public static final int OUTPUTTAG = OPERATIONTAG +1;
    /**
     * The overflow element or attribute tag.
     */
    public static final int OVERFLOWTAG = OUTPUTTAG +1;
    /**
     * The permissions element or attribute tag.
     */
    public static final int PERMISSIONSTAG = OVERFLOWTAG +1;
    /**
     * The presence element or attribute tag.
     */
    public static final int PRESENCETAG = PERMISSIONSTAG +1;
    /**
     * The ref element or attribute tag.
     */
    public static final int REFTAG = PRESENCETAG +1;
    /**
     * The relevant element or attribute tag.
     */
    public static final int RELEVANTTAG = REFTAG +1;
    /**
     * The script element or attribute tag.
     */
    public static final int SCRIPTTAG = RELEVANTTAG +1;
    /**
     * The select element or attribute tag.
     */
    public static final int SELECTTAG = SCRIPTTAG +1;
    /**
     * The source element or attribute tag.
     */
    public static final int SOURCETAG = SELECTTAG +1;
    /**
     * The step element or attribute tag.
     */
    public static final int STEPTAG = SOURCETAG +1;
    /**
     * The text element or attribute tag.
     */
    public static final int TEXTTAG = STEPTAG +1;
    /**
     * The threshold element or attribute tag.
     */
    public static final int THRESHOLDTAG = TEXTTAG +1;
    /**
     * The timeStamp element or attribute tag.
     */
    public static final int TIMESTAMPTAG = THRESHOLDTAG +1;
    /**
     * The to element or attribute tag.
     */
    public static final int TOTAG = TIMESTAMPTAG +1;
    /**
     * The type element or attribute tag.
     */
    public static final int TYPETAG = TOTAG +1;
    /**
     * The typeface element or attribute tag.
     */
    public static final int TYPEFACETAG = TYPETAG +1;
    /**
     * The validate element or attribute tag.
     */
    public static final int VALIDATETAG = TYPEFACETAG +1;
    /**
     * The value element or attribute tag.
     */
    public static final int VALUETAG = VALIDATETAG +1;
    /**
     * The version element or attribute tag.
     */
    public static final int VERSIONTAG = VALUETAG +1;
    /**
	 * The ending index of element plus attribute tags.
     */
    static final int XFA_ELEMENTS_ATTRS = VERSIONTAG;
    /**
     * The APIVersion attribute tag.
     */
    public static final int APIVERSIONTAG = VERSIONTAG +1;
    /**
     * The abbr attribute tag.
     */
    public static final int ABBRTAG = APIVERSIONTAG +1;
    /**
     * The access attribute tag.
     */
    public static final int ACCESSTAG = ABBRTAG +1;
    /**
     * The accessKey attribute tag.
     */
    public static final int ACCESSKEYTAG = ACCESSTAG +1;
    /**
     * The action attribute tag.
     */
    public static final int ACTIONTAG = ACCESSKEYTAG +1;
    /**
     * The activity attribute tag.
     */
    public static final int ACTIVITYTAG = ACTIONTAG +1;
    /**
     * The add attribute tag.
     */
    public static final int ADDTAG = ACTIVITYTAG +1;
    /**
     * The addRevocationInfo attribute tag.
     */
    public static final int ADDREVOCATIONINFOTAG = ADDTAG +1;
    /**
     * The after attribute tag.
     */
    public static final int AFTERTAG = ADDREVOCATIONINFOTAG +1;
    /**
     * The afterTarget attribute tag.
     */
    public static final int AFTERTARGETTAG = AFTERTAG +1;
    /**
     * The allowMacro attribute tag.
     */
    public static final int ALLOWMACROTAG = AFTERTARGETTAG +1;
    /**
     * The allowNeutral attribute tag.
     */
    public static final int ALLOWNEUTRALTAG = ALLOWMACROTAG +1;
    /**
     * The allowRichText attribute tag.
     */
    public static final int ALLOWRICHTEXTTAG = ALLOWNEUTRALTAG +1;
    /**
     * The anchorType attribute tag.
     */
    public static final int ANCHORTYPETAG = ALLOWRICHTEXTTAG +1;
    /**
     * The applicationData attribute tag.
     */
    public static final int APPLICATIONDATATAG = ANCHORTYPETAG +1;
    /**
     * The applicationDataPrefix attribute tag.
     */
    public static final int APPLICATIONDATAPREFIXTAG = APPLICATIONDATATAG +1;
    /**
     * The archive attribute tag.
     */
    public static final int ARCHIVETAG = APPLICATIONDATAPREFIXTAG +1;
    /**
     * The ascent attribute tag.
     */
    public static final int ASCENTTAG = ARCHIVETAG +1;
    /**
     * The aspect attribute tag.
     */
    public static final int ASPECTTAG = ASCENTTAG +1;
    /**
     * The backfeedSpeed attribute tag.
     */
    public static final int BACKFEEDSPEEDTAG = ASPECTTAG +1;
    /**
     * The bBox attribute tag.
     */
    public static final int BBOXTAG = BACKFEEDSPEEDTAG +1;
    /**
     * The baseMode attribute tag.
     */
    public static final int BASEMODETAG = BBOXTAG +1;
    /**
     * The baseName attribute tag.
     */
    public static final int BASENAMETAG = BASEMODETAG +1;
    /**
     * The baseProfile attribute tag.
     */
    public static final int BASEPROFILETAG = BASENAMETAG +1;
    /**
     * The baselineShift attribute tag.
     */
    public static final int BASELINESHIFTTAG = BASEPROFILETAG +1;
    /**
     * The before attribute tag.
     */
    public static final int BEFORETAG = BASELINESHIFTTAG +1;
    /**
     * The beforeTarget attribute tag.
     */
    public static final int BEFORETARGETTAG = BEFORETAG +1;
    /**
     * The bin attribute tag.
     */
    public static final int BINTAG = BEFORETARGETTAG +1;
    /**
     * The binding attribute tag.
     */
    public static final int BINDINGTAG = BINTAG +1;
    /**
     * The blankOrNotBlank attribute tag.
     */
    public static final int BLANKORNOTBLANKTAG = BINDINGTAG +1;
    /**
     * The bofAction attribute tag.
     */
    public static final int BOFACTIONTAG = BLANKORNOTBLANKTAG +1;
    /**
     * The bookendLeader attribute tag.
     */
    public static final int BOOKENDLEADERTAG = BOFACTIONTAG +1;
    /**
     * The bookendTrailer attribute tag.
     */
    public static final int BOOKENDTRAILERTAG = BOOKENDLEADERTAG +1;
    /**
     * The bottomInset attribute tag.
     */
    public static final int BOTTOMINSETTAG = BOOKENDTRAILERTAG +1;
    /**
     * The cacheLib attribute tag.
     */
    public static final int CACHELIBTAG = BOTTOMINSETTAG +1;
    /**
     * The cap attribute tag.
     */
    public static final int CAPTAG = CACHELIBTAG +1;
    /**
     * The capHeight attribute tag.
     */
    public static final int CAPHEIGHTTAG = CAPTAG +1;
    /**
     * The charEncoding attribute tag.
     */
    public static final int CHARENCODINGTAG = CAPHEIGHTTAG +1;
    /**
     * The charSet attribute tag.
     */
    public static final int CHARSETTAG = CHARENCODINGTAG +1;
    /**
     * The checksum attribute tag.
     */
    public static final int CHECKSUMTAG = CHARSETTAG +1;
    /**
     * The circular attribute tag.
     */
    public static final int CIRCULARTAG = CHECKSUMTAG +1;
    /**
     * The class attribute tag.
     */
    public static final int CLASSTAG = CIRCULARTAG +1;
    /**
     * The classId attribute tag.
     */
    public static final int CLASSIDTAG = CLASSTAG +1;
    /**
     * The codeBase attribute tag.
     */
    public static final int CODEBASETAG = CLASSIDTAG +1;
    /**
     * The codeType attribute tag.
     */
    public static final int CODETYPETAG = CODEBASETAG +1;
    /**
     * The colSpan attribute tag.
     */
    public static final int COLSPANTAG = CODETYPETAG +1;
    /**
     * The columnWidths attribute tag.
     */
    public static final int COLUMNWIDTHSTAG = COLSPANTAG +1;
    /**
     * The commandType attribute tag.
     */
    public static final int COMMANDTYPETAG = COLUMNWIDTHSTAG +1;
    /**
     * The commitOn attribute tag.
     */
    public static final int COMMITONTAG = COMMANDTYPETAG +1;
    /**
     * The condition attribute tag.
     */
    public static final int CONDITIONTAG = COMMITONTAG +1;
    /**
     * The contentType attribute tag.
     */
    public static final int CONTENTTYPETAG = CONDITIONTAG +1;
    /**
     * The counter attribute tag.
     */
    public static final int COUNTERTAG = CONTENTTYPETAG +1;
    /**
     * The credentialServerPolicy attribute tag.
     */
    public static final int CREDENTIALSERVERPOLICYTAG = COUNTERTAG +1;
    /**
     * The crlSign attribute tag.
     */
    public static final int CRLSIGNTAG = CREDENTIALSERVERPOLICYTAG +1;
    /**
     * The cursorLocation attribute tag.
     */
    public static final int CURSORLOCATIONTAG = CRLSIGNTAG +1;
    /**
     * The cursorType attribute tag.
     */
    public static final int CURSORTYPETAG = CURSORLOCATIONTAG +1;
    /**
     * The dataColumnCount attribute tag.
     */
    public static final int DATACOLUMNCOUNTTAG = CURSORTYPETAG +1;
    /**
     * The dataEncipherment attribute tag.
     */
    public static final int DATAENCIPHERMENTTAG = DATACOLUMNCOUNTTAG +1;
    /**
     * The dataLength attribute tag.
     */
    public static final int DATALENGTHTAG = DATAENCIPHERMENTTAG +1;
    /**
     * The dataMode attribute tag.
     */
    public static final int DATAMODETAG = DATALENGTHTAG +1;
    /**
     * The dataNode attribute tag.
     */
    public static final int DATANODETAG = DATAMODETAG +1;
    /**
     * The dataPrep attribute tag.
     */
    public static final int DATAPREPTAG = DATANODETAG +1;
    /**
     * The dataRowCount attribute tag.
     */
    public static final int DATAROWCOUNTTAG = DATAPREPTAG +1;
    /**
     * The dataSetInfo attribute tag.
     */
    public static final int DATASETINFOTAG = DATAROWCOUNTTAG +1;
    /**
     * The db attribute tag.
     */
    public static final int DBTAG = DATASETINFOTAG +1;
    /**
     * The decipherOnly attribute tag.
     */
    public static final int DECIPHERONLYTAG = DBTAG +1;
    /**
     * The defaultCharWidth attribute tag.
     */
    public static final int DEFAULTCHARWIDTHTAG = DECIPHERONLYTAG +1;
    /**
     * The delayedOpen attribute tag.
     */
    public static final int DELAYEDOPENTAG = DEFAULTCHARWIDTHTAG +1;
    /**
     * The delegate attribute tag.
     */
    public static final int DELEGATETAG = DELAYEDOPENTAG +1;
    /**
     * The delimiter attribute tag.
     */
    public static final int DELIMITERTAG = DELEGATETAG +1;
    /**
     * The descent attribute tag.
     */
    public static final int DESCENTTAG = DELIMITERTAG +1;
    /**
     * The dest attribute tag.
     */
    public static final int DESTTAG = DESCENTTAG +1;
    /**
     * The destOp attribute tag.
     */
    public static final int DESTOPTAG = DESTTAG +1;
    /**
     * The destVar attribute tag.
     */
    public static final int DESTVARTAG = DESTOPTAG +1;
    /**
     * The digitalSignature attribute tag.
     */
    public static final int DIGITALSIGNATURETAG = DESTVARTAG +1;
    /**
     * The disable attribute tag.
     */
    public static final int DISABLETAG = DIGITALSIGNATURETAG +1;
    /**
     * The disableAll attribute tag.
     */
    public static final int DISABLEALLTAG = DISABLETAG +1;
    /**
     * The domRef attribute tag.
     */
    public static final int DOMREFTAG = DISABLEALLTAG +1;
    /**
     * The duplexImposition attribute tag.
     */
    public static final int DUPLEXIMPOSITIONTAG = DOMREFTAG +1;
   /**
     * The embedPDF attribute tag.
     */
    public static final int EMBEDPDFTAG = DUPLEXIMPOSITIONTAG +1;
    /**
     * The emfContext attribute tag.
     */
    public static final int EMFCONTEXTTAG = EMBEDPDFTAG +1;
    /**
     * The enable attribute tag.
     */
    public static final int ENABLETAG = EMFCONTEXTTAG +1;
    /**
     * The encipherOnly attribute tag.
     */
    public static final int ENCIPHERONLYTAG = ENABLETAG +1;
    /**
     * The endChar attribute tag.
     */
    public static final int ENDCHARTAG = ENCIPHERONLYTAG +1;
    /**
     * The eofAction attribute tag.
     */
    public static final int EOFACTIONTAG = ENDCHARTAG +1;
    /**
     * The errorCorrectionLevel attribute tag.
     */
    public static final int ERRORCORRECTIONLEVELTAG = EOFACTIONTAG +1;
    /**
     * The errorId attribute tag.
     */
    public static final int ERRORIDTAG = ERRORCORRECTIONLEVELTAG +1;
    /**
     * The eventContentType attribute tag.
     */
    public static final int EVENTCONTENTTYPETAG = ERRORIDTAG +1;
    /**
     * The excludeAllCaps element tag.
     */
    public static final int EXCLUDEALLCAPSTAG = EVENTCONTENTTYPETAG +1;
    /**
     * The excludeInitialCap element tag.
     */
    public static final int EXCLUDEINITIALCAPTAG = EXCLUDEALLCAPSTAG +1;
    /**
     * The executeIf attribute tag.
     */
    public static final int EXECUTEIFTAG = EXCLUDEINITIALCAPTAG +1;
    /**
     * The executeType attribute tag.
     */
    public static final int EXECUTETYPETAG = EXECUTEIFTAG +1;
    /**
     * The extendSize attribute tag.
     */
    public static final int EXTENDSIZETAG = EXECUTETYPETAG +1;
    /**
     * The extension attribute tag.
     */
    public static final int EXTENSIONTAG = EXTENDSIZETAG +1;
    /**
     * The final attribute tag.
     */
    public static final int FINALTAG = EXTENSIONTAG +1;
    /**
     * The flags attribute tag.
     */
    public static final int FLAGSTAG = FINALTAG +1;
    /**
     * The fontHorizontalScale attribute tag.
     */
	public static final int FONTHORIZONTALSCALETAG = FLAGSTAG +1;
    /**
     * The fontVerticalScale attribute tag.
     */
	public static final int FONTVERTICALSCALETAG = FONTHORIZONTALSCALETAG +1;
    /**
     * The force attribute tag.
     */
    public static final int FORCETAG = FONTVERTICALSCALETAG +1;
    /**
     * The formats attribute tag.
     */
    public static final int FORMATSTAG = FORCETAG +1;
    /**
     * The formatTest attribute tag.
     */
    public static final int FORMATTESTTAG = FORMATSTAG +1;
    /**
     * The fracDigits attribute tag.
     */
    public static final int FRACDIGITSTAG = FORMATTESTTAG +1;
    /**
     * The fraction attribute tag.
     */
    public static final int FRACTIONTAG = FRACDIGITSTAG +1;
    /**
     * The from attribute tag.
     */
    public static final int FROMTAG = FRACTIONTAG +1;
    /**
     * The genericFamily attribute tag.
     */
    public static final int GENERICFAMILYTAG =  FROMTAG +1;
    /**
     * The h attribute tag.
     */
    public static final int HTAG = GENERICFAMILYTAG +1;
    /**
     * The hAlign attribute tag.
     */
    public static final int HALIGNTAG = HTAG +1;
    /**
     * The highlight attribute tag.
     */
    public static final int HIGHLIGHTTAG = HALIGNTAG +1;
    /**
     * The hScrollPolicy attribute tag.
     */
    public static final int HSCROLLPOLICYTAG = HIGHLIGHTTAG +1;
    /**
     * The hSize attribute tag.
     */
    public static final int HSIZETAG = HSCROLLPOLICYTAG +1;
    /**
     * The hand attribute tag.
     */
    public static final int HANDTAG = HSIZETAG +1;
    /**
     * The handlerFor attribute tag.
     */
    public static final int HANDLERFORTAG = HANDTAG +1;
    /**
     * The href attribute tag.
     */
    public static final int HREFTAG = HANDLERFORTAG +1;
    /**
     * The hyphenate attribute tag.
     */
    public static final int HYPHENATETAG = HREFTAG +1;
    /**
     * The id attribute tag.
     */
    public static final int IDTAG = HYPHENATETAG +1;
    /**
     * The imagingBBox attribute tag.
     */
    public static final int IMAGINGBBOXTAG = IDTAG +1;
    /**
     * The initSize attribute tag.
     */
    public static final int INITSIZETAG = IMAGINGBBOXTAG +1;
    /**
     * The initial attribute tag.
     */
    public static final int INITIALTAG = INITSIZETAG +1;
    /**
     * The initialNumber attribute tag.
     */
    public static final int INITIALNUMBERTAG = INITIALTAG +1;
    /**
     * The intact attribute tag.
     */
    public static final int INTACTTAG = INITIALNUMBERTAG +1;
    /**
     * The intermediate attribute tag.
     */
    public static final int INTERMEDIATETAG = INTACTTAG +1;
    /**
     * The inverted attribute tag.
     */
    public static final int INVERTEDTAG = INTERMEDIATETAG +1;
    /**
     * The italicAngle attribute tag.
     */
    public static final int ITALICANGLETAG = INVERTEDTAG +1;
    /**
     * The iterate attribute tag.
     */
    public static final int ITERATETAG = ITALICANGLETAG +1;
    /**
     * The join attribute tag.
     */
    public static final int JOINTAG = ITERATETAG +1;
    /**
	 * The kerningMode attribute tag.
	 */
	public static final int KERNINGMODETAG = JOINTAG +1;
    /**
     * The key attribute tag.
     */
    public static final int KEYTAG = KERNINGMODETAG +1;
    /**
     * The keyAgreement attribute tag.
     */
    public static final int KEYAGREEMENTTAG = KEYTAG +1;
    /**
     * The keyCertSign attribute tag.
     */
    public static final int KEYCERTSIGNTAG = KEYAGREEMENTTAG +1;
    /**
     * The keyEncipherment attribute tag.
     */
    public static final int KEYENCIPHERMENTTAG = KEYCERTSIGNTAG +1;
    /**
     * The labelRef attribute tag.
     */
    public static final int LABELREFTAG = KEYENCIPHERMENTTAG +1;
    /**
     * The ladderCount attribute tag.
     */
	public static final int LADDERCOUNTTAG = LABELREFTAG +1;
    /**
     * The leadDigits attribute tag.
     */
    public static final int LEADDIGITSTAG = LADDERCOUNTTAG +1;
    /**
     * The leader attribute tag.
     */
    public static final int LEADERTAG = LEADDIGITSTAG +1;
    /**
     * The leftInset attribute tag.
     */
    public static final int LEFTINSETTAG = LEADERTAG +1;
    /**
     * The legacyConfig attribute tag.
     */
    public static final int LEGACYCONFIGTAG = LEFTINSETTAG +1;
    /**
     * The letterSpacing attribute tag.
     */
	public static final int LETTERSPACINGTAG = LEGACYCONFIGTAG +1;;
    /**
     * The li attribute tag.
     */
    public static final int LITAG = LETTERSPACINGTAG +1;
    /**
     * The lineHeight attribute tag.
     */
    public static final int LINEHEIGHTTAG = LITAG +1;
    /**
     * The lineThrough attribute tag.
     */
    public static final int LINETHROUGHTAG = LINEHEIGHTTAG +1;
    /**
     * The lineThroughPeriod attribute tag.
     */
    public static final int LINETHROUGHPERIODTAG = LINETHROUGHTAG +1;
    /**
     * The listen attribute tag.
     */
    public static final int LISTENTAG = LINETHROUGHPERIODTAG +1;
    /**
     * The lockType attribute tag.
     */
    public static final int LOCKTYPETAG = LISTENTAG +1;
    /**
     * The long attribute tag.
     */
    public static final int LONGTAG = LOCKTYPETAG +1;
    /**
     * The marginLeft attribute tag.
     */
    public static final int MARGINLEFTTAG = LONGTAG +1;
    /**
     * The marginRight attribute tag.
     */
    public static final int MARGINRIGHTTAG = MARGINLEFTTAG +1;
    /**
     * The mark attribute tag.
     */
    public static final int MARKTAG = MARGINRIGHTTAG +1;
    /**
     * The match attribute tag.
     */
    public static final int MATCHTAG = MARKTAG +1;
    /**
     * The max attribute tag.
     */
    public static final int MAXTAG = MATCHTAG +1;
    /**
     * The maxChars attribute tag.
     */
    public static final int MAXCHARSTAG = MAXTAG +1;
    /**
     * The maxEntries attribute tag.
     */
    public static final int MAXENTRIESTAG = MAXCHARSTAG +1;
    /**
     * The maxH attribute tag.
     */
    public static final int MAXHTAG = MAXENTRIESTAG +1;
    /**
     * The maxLength attribute tag.
     */
    public static final int MAXLENGTHTAG = MAXHTAG +1;
    /**
     * The maxW attribute tag.
     */
    public static final int MAXWTAG = MAXLENGTHTAG +1;
    /**
     * The medium attribute tag.
     */
    public static final int MEDIUMSTOCKTAG = MAXWTAG +1;
    /**
     * The member attribute tag.
     */
    public static final int MEMBERTAG = MEDIUMSTOCKTAG +1;
    /**
     * The memberOf attribute tag.
     */
    public static final int MEMBEROFTAG = MEMBERTAG +1;
    /**
     * The merge attribute tag.
     */
    public static final int MERGETAG = MEMBEROFTAG +1;
    /**
     * The mergeMode attribute tag.
     */    
    public static final int MERGEMODETAG = MERGETAG +1;
    /**
     * The min attribute tag.
     */
    public static final int MINTAG = MERGEMODETAG +1;
    /**
     * The minH attribute tag.
     */
    public static final int MINHTAG = MINTAG +1;
    /**
     * The minW attribute tag.
     */
    public static final int MINWTAG = MINHTAG +1;
    /**
     * The moduleHeight attribute tag.
     */
    public static final int MODULEHEIGHTTAG = MINWTAG +1;
    /**
     * The moduleHeightVariable attribute tag.
     */
    public static final int MODULEHEIGHTVARIABLETAG = MODULEHEIGHTTAG +1;
    /**
     * The moduleWidth attribute tag.
     */
    public static final int MODULEWIDTHTAG = MODULEHEIGHTVARIABLETAG +1;
    /**
     * The moduleWidthVariable attribute tag.
     */
    public static final int MODULEWIDTHVARIABLETAG = MODULEWIDTHTAG +1;
    /**
     * The multiLine attribute tag.
     */
    public static final int MULTILINETAG = MODULEWIDTHVARIABLETAG +1;
    /**
     * The name attribute tag.
     */
    public static final int NAMETAG = MULTILINETAG +1;
    /**
     * The next attribute tag.
     */
    public static final int NEXTTAG = NAMETAG +1;
    /**
     * The nodeType attribute tag.
     */
    public static final int NODETYPETAG = NEXTTAG +1;
    /**
     * The nonRepudiation attribute tag.
     */
    public static final int NONREPUDIATIONTAG = NODETYPETAG +1;
    /**
     * The nullTest attribute tag.
     */
    public static final int NULLTESTTAG = NONREPUDIATIONTAG +1;
    /**
     * The nullType attribute tag.
     */
    public static final int NULLTYPETAG = NULLTESTTAG +1;
    /**
     * The numbered attribute tag.
     */
    public static final int NUMBEREDTAG = NULLTYPETAG +1;
    /**
     * The numberOfCells attribute tag.
     */
    public static final int NUMBEROFCELLSTAG = NUMBEREDTAG +1;
    /**
     * The oddOrEven attribute tag.
     */
    public static final int ODDOREVENTAG = NUMBEROFCELLSTAG +1;
    /**
     * The ol attribute tag.
     */
    public static final int OLTAG = ODDOREVENTAG +1;
    /**
     * The open attribute tag.
     */
    public static final int OPENTAG = OLTAG +1;
    /**
     * The orientation attribute tag.
     */
    public static final int ORIENTATIONTAG = OPENTAG +1;
    /**
     * The orphans attribute tag.
     */
    public static final int ORPHANSTAG = ORIENTATIONTAG +1;
    /**
     * The outputBelow attribute tag.
     */
    public static final int OUTPUTBELOWTAG = ORPHANSTAG +1;
    /**
     * The overflowLeader attribute tag.
     */
    public static final int OVERFLOWLEADERTAG = OUTPUTBELOWTAG +1;
    /**
     * The overflowTarget attribute tag.
     */
    public static final int OVERFLOWTARGETTAG = OVERFLOWLEADERTAG +1;
    /**
     * The overflowTrailer attribute tag.
     */
    public static final int OVERFLOWTRAILERTAG = OVERFLOWTARGETTAG +1;
    /**
     * The overline attribute tag.
     */
    public static final int OVERLINETAG = OVERFLOWTRAILERTAG +1;
    /**
     * The overlinePeriod attribute tag.
     */
    public static final int OVERLINEPERIODTAG = OVERLINETAG +1;
    /**
     * The override attribute tag.
     */
    public static final int OVERRIDETAG = OVERLINEPERIODTAG +1;
    /**
     * The padding attribute tag.
     */
    public static final int PADDINGTAG = OVERRIDETAG +1;
    /**
     * The pagePosition attribute tag.
     */
    public static final int PAGEPOSITIONTAG = PADDINGTAG +1;
    /**
     * The parity attribute tag.
     */
    public static final int PARITYTAG = PAGEPOSITIONTAG +1;
    /**
     * The parse attribute tag.
     */
    public static final int PARSETAG = PARITYTAG +1;
    /**
     * The passThrough attribute tag.
     */
    public static final int PASSTHROUGHTAG = PARSETAG +1;
    /**
     * The passwordChar attribute tag.
     */
    public static final int PASSWORDCHARTAG = PASSTHROUGHTAG +1;
	/**
	 * The picker attribute tag.
	 */
	public static final int PICKERTAG = PASSWORDCHARTAG +1;
    /**
     * The pitch attribute tag.
     */
    public static final int PITCHTAG = PICKERTAG +1;
    /**
     * The placement attribute tag.
     */
    public static final int PLACEMENTTAG = PITCHTAG +1;
    /**
     * The posture attribute tag.
     */
    public static final int POSTURETAG = PLACEMENTTAG +1;
   /**
     * The prefix attribute tag.
     */
    public static final int PREFIXTAG = POSTURETAG +1;
    /**
     * The preserve attribute tag.
     */
    public static final int PRESERVETAG = PREFIXTAG +1;
    /**
     * The previous attribute tag.
     */
    public static final int PREVIOUSTAG = PRESERVETAG +1;
    /**
     * The previousSibling attribute tag.
     */
    public static final int PREVIOUSSIBLINGTAG = PREVIOUSTAG +1;
    /**
     * The printCheckDigit attribute tag.
     */
    public static final int PRINTCHECKDIGITTAG = PREVIOUSSIBLINGTAG +1;
    /**
     * The printerType attribute tag.
     */
    public static final int PRINTERTYPETAG = PRINTCHECKDIGITTAG +1;
    /**
     * The printSpeed attribute tag.
     */
    public static final int PRINTSPEEDTAG = PRINTERTYPETAG +1;
    /**
     * The priority attribute tag.
     */
    public static final int PRIORITYTAG = PRINTSPEEDTAG +1;
    /**
     * The program attribute tag.
     */
    public static final int PROGRAMTAG = PRIORITYTAG +1;
    /**
     * The psName attribute tag.
     */
    public static final int PSNAMETAG = PROGRAMTAG +1;
    /**
     * The pushCharacterCount attribute tag.
     */
	public static final int PUSHCHARACTERCOUNTTAG = PSNAMETAG +1;
    /**
     * The quietZone attribute tag.
     */
    public static final int QUIETZONETAG = PUSHCHARACTERCOUNTTAG +1;
    /**
     * The radius attribute tag.
     */
    public static final int RADIUSTAG = QUIETZONETAG +1;
    /**
     * The radixOffset attribute tag.
     */
    public static final int RADIXOFFSETTAG = RADIUSTAG +1;
    /**
     * The rate attribute tag.
     */
    public static final int RATETAG = RADIXOFFSETTAG +1;
    /**
     * The readOnly attribute tag.
     */
    public static final int READONLYTAG = RATETAG +1;
    /**
     * The relation attribute tag.
     */
    public static final int RELATIONTAG = READONLYTAG +1;
    /**
     * The remainCharacterCount attribute tag.
     */
	public static final int REMAINCHARACTERCOUNTTAG = RELATIONTAG  +1;
    /**
     * The reserve attribute tag.
     */
    public static final int RESERVETAG = REMAINCHARACTERCOUNTTAG +1;
    /**
     * The reserveH attribute tag.
     */
    public static final int RESERVEHTAG = RESERVETAG +1;
    /**
     * The restoreState attribute tag.
     */
    public static final int RESTORESTATETAG = RESERVEHTAG +1;
    /**
     * The retryCount attribute tag.
     */
    public static final int RETRYCOUNTTAG = RESTORESTATETAG +1;
    /**
     * The retryIn attribute tag.
     */
    public static final int RETRYINTAG = RETRYCOUNTTAG +1;
    /**
     * The rid attribute tag.
     */
    public static final int RIDTAG = RETRYINTAG +1;
    /**
     * The rightInset attribute tag.
     */
    public static final int RIGHTINSETTAG = RIDTAG +1;
    /**
     * The role attribute tag.
     */
    public static final int ROLETAG = RIGHTINSETTAG +1;
    /**
     * The root attribute tag.
     */
    public static final int ROOTTAG = ROLETAG +1;
    /**
     * The rotate attribute tag.
     */
    public static final int ROTATETAG = ROOTTAG +1;
    /**
     * The round attribute tag.
     */
    public static final int ROUNDTAG = ROTATETAG +1;
    /**
     * The rowColumnRatio attribute tag.
     */
    public static final int ROWCOLUMNRATIOTAG = ROUNDTAG +1;
    /**
     * The runAt attribute tag.
     */
    public static final int RUNATTAG = ROWCOLUMNRATIOTAG +1;
    /**
     * The save attribute tag.
     */
    public static final int SAVETAG = RUNATTAG +1;
    /**
     * The scalable attribute tag.
     */
    public static final int SCALABLETAG = SAVETAG +1;
    /**
     * The scope attribute tag.
     */
    public static final int SCOPETAG = SCALABLETAG +1;
    /**
     * The scriptTest attribute tag.
     */
    public static final int SCRIPTTESTTAG = SCOPETAG +1;
    /**
     * The serialize attribute tag.
     */
    public static final int SERIALIZETAG = SCRIPTTESTTAG +1;
    /**
     * The server attribute tag.
     */
    public static final int SERVERTAG = SERIALIZETAG +1;
    /**
     * The shape attribute tag.
     */
    public static final int SHAPETAG = SERVERTAG +1;
    /**
     * The shareDom attribute tag.
     */
    public static final int SHAREDOMTAG = SHAPETAG +1;
    /**
     * The short attribute tag.
     */
    public static final int SHORTTAG = SHAREDOMTAG +1;
    /**
     * The sign attribute tag.
     */
    public static final int SIGNTAG = SHORTTAG +1;
    /**
     * The signatureType attribute tag.
     */
    public static final int SIGNATURETYPETAG = SIGNTAG +1;
    /**
     * The size attribute tag.
     */
    public static final int SIZETAG = SIGNATURETYPETAG +1;
    /**
     * The slewSpeed attribute tag.
     */
    public static final int SLEWSPEEDTAG = SIZETAG +1;
    /**
     * The slope attribute tag.
     */
    public static final int SLOPETAG = SLEWSPEEDTAG +1;
    /**
     * The som attribute tag.
     */
    public static final int SOMTAG = SLOPETAG +1;
    /**
     * The sourceAbove attribute tag.
     */
    public static final int SOURCEABOVETAG = SOMTAG +1;
    /**
     * The sourceBelow attribute tag.
     */
    public static final int SOURCEBELOWTAG = SOURCEABOVETAG +1;
    /**
     * The spaceAbove attribute tag.
     */
    public static final int SPACEABOVETAG = SOURCEBELOWTAG +1;
    /**
     * The spaceBelow attribute tag.
     */
    public static final int SPACEBELOWTAG = SPACEABOVETAG +1;
    /**
     * The square attribute tag.
     */
    public static final int SQUARETAG = SPACEBELOWTAG +1;
    /**
     * The startAngle attribute tag.
     */
    public static final int STARTANGLETAG = SQUARETAG +1;
    /**
     * The startChar attribute tag.
     */
    public static final int STARTCHARTAG = STARTANGLETAG +1;
    /**
     * The startNew attribute tag.
     */
    public static final int STARTNEWTAG = STARTCHARTAG +1;
    /**
     * The stateless attribute tag.
     */
    public static final int STATELESSTAG = STARTNEWTAG +1;
    /**
     * The stdHW attribute tag.
     */
    public static final int STDHWTAG = STATELESSTAG +1;
    /**
     * The stdVW attribute tag.
     */
    public static final int STDVWTAG = STDHWTAG +1;
    /**
     * The steps attribute tag.
     */
    public static final int STEPSTAG = STDVWTAG +1;
    /**
     * The stock attribute tag.
     */
    public static final int STOCKTAG = STEPSTAG +1;
    /**
     * The stroke attribute tag.
     */
    public static final int STROKETAG = STOCKTAG +1;
    /**
     * The styleType attribute tag.
     */
    public static final int STYLETYPETAG = STROKETAG +1;
    /**
     * The suffix attribute tag.
     */
    public static final int SUFFIXTAG = STYLETYPETAG +1;
    /**
     * The support attribute tag.
     */
    public static final int SUPPORTTAG = SUFFIXTAG +1;
    /**
     * The sweepAngle attribute tag.
     */
    public static final int SWEEPANGLETAG = SUPPORTTAG +1;
    /**
     * The tabDefault attribute tag.
     */
    public static final int TABSDEFAULTTAG = SWEEPANGLETAG +1;
    /**
     * The tabStops attribute tag.
     */
    public static final int TABSTOPSTAG = TABSDEFAULTTAG +1;
    /**
     * The target attribute tag.
     */
    public static final int TARGETTAG = TABSTOPSTAG +1;
    /**
     * The targetType attribute tag.
     */
    public static final int TARGETTYPETAG = TARGETTAG +1;
    /**
     * The textEncoding attribute tag.
     */
    public static final int TEXTENCODINGTAG = TARGETTYPETAG +1;
    /**
     * The textEntry attribute tag.
     */
    public static final int TEXTENTRYTAG = TEXTENCODINGTAG +1;
    /**
     * The textIndent attribute tag.
     */
    public static final int TEXTINDENTTAG = TEXTENTRYTAG +1;
    /**
     * The textLocation attribute tag.
     */
    public static final int TEXTLOCATIONTAG = TEXTINDENTTAG +1;
    /**
     * The thickness attribute tag.
     */
    public static final int THICKNESSTAG = TEXTLOCATIONTAG +1;
    /**
     * The timeout attribute tag.
     */
    public static final int TIMEOUTTAG = THICKNESSTAG +1;
    /**
     * The topInset attribute tag.
     */
    public static final int TOPINSETTAG = TIMEOUTTAG +1;
    /**
     * The traceInclude attribute tag.
     */
    public static final int TRACEINCLUDETAG = TOPINSETTAG +1;
    /**
     * The trailer attribute tag.
     */
    public static final int TRAILERTAG = TRACEINCLUDETAG +1;
    /**
     * The transferEncoding attribute tag.
     */
    public static final int TRANSFERENCODINGTAG = TRAILERTAG +1;
    /**
     * The transient attribute tag.
     */
    public static final int TRANSIENTTAG = TRANSFERENCODINGTAG +1;
    /**
     * The trayIn attribute tag.
     */
    public static final int TRAYINTAG = TRANSIENTTAG +1;
    /**
     * The trayNumber attribute tag.
     */
    public static final int TRAYNUMBERTAG = TRAYINTAG +1;
    /**
     * The trayOut attribute tag.
     */
    public static final int TRAYOUTTAG = TRAYNUMBERTAG +1;
    /**
     * The trayType attribute tag.
     */
    public static final int TRAYTYPETAG = TRAYOUTTAG +1;
    /**
     * The truncate attribute tag.
     */
    public static final int TRUNCATETAG = TRAYTYPETAG +1;
    /**
     * The ul attribute tag.
     */
    public static final int ULTAG = TRUNCATETAG +1;
    /**
     * The underline attribute tag.
     */
    public static final int UNDERLINETAG = ULTAG +1;
    /**
     * The underlinePeriod attribute tag.
     */
    public static final int UNDERLINEPERIODTAG = UNDERLINETAG +1;
    /**
     * The unicodeRange attribute tag.
     */
    public static final int UNICODERANGETAG = UNDERLINEPERIODTAG +1;
    /**
     * The unsigner attribute tag.
     */
    public static final int UNSIGNERTAG = UNICODERANGETAG +1;
    /**
     * The upsMode attribute tag.
     */
    public static final int UPSMODETAG = UNSIGNERTAG +1;
    /**
     * The url attribute tag.
     */
    public static final int URLTAG = UPSMODETAG +1;
    /**
     * The urlPolicy attribute tag.
     */
    public static final int URLPOLICYTAG = URLTAG +1;
    /**
     * The usage attribute tag.
     */
    public static final int USAGETAG = URLPOLICYTAG +1;
    /**
     * The use attribute tag.
     */
    public static final int USETAG = USAGETAG +1;
    /**
     * The usehref attribute tag.
     */
    public static final int USEHREFTAG = USETAG +1;
    /**
     * The uuid attribute tag.
     */
    public static final int UUIDTAG = USEHREFTAG +1;
    /**
     * The vAlign attribute tag.
     */
    public static final int VALIGNTAG = UUIDTAG +1;
    /**
     * The valueRef attribute tag.
     */
    public static final int VALUEREFTAG = VALIGNTAG +1;
    /**
     * The vScrollPolicy attribute tag.
     */
    public static final int VSCROLLPOLICYTAG = VALUEREFTAG +1;
    /**
     * The vSize attribute tag.
     */
    public static final int VSIZETAG = VSCROLLPOLICYTAG +1;
    /**
     * The validDataChars attribute tag.
     */
    public static final int VALIDDATACHARSTAG = VSIZETAG +1;
    /**
     * The w attribute tag.
     */
    public static final int WTAG = VALIDDATACHARSTAG +1;
    /**
     * The weight attribute tag.
     */
    public static final int WEIGHTTAG = WTAG +1;
    /**
     * The wideNarrowRatio attribute tag.
     */
    public static final int WIDENARROWRATIOTAG = WEIGHTTAG +1;
    /**
     * The widows attribute tag.
     */
    public static final int WIDOWSTAG = WIDENARROWRATIOTAG +1;
    /**
     * The wordCharacterCount attribute tag.
     */
    public static final int WORDCHARACTERCOUNTTAG = WIDOWSTAG +1;
    /**
     * The wordSpacingMaximum attribute tag.
     */
	public static final int WORDSPACINGMAXIMUMTAG = WORDCHARACTERCOUNTTAG +1;
    /**
     * The wordSpacingMinimum attribute tag.
     */
	public static final int WORDSPACINGMINIMUMTAG = WORDSPACINGMAXIMUMTAG +1;
    /**
     * The wordSpacingOptimum attribute tag.
     */
	public static final int WORDSPACINGOPTIMUMTAG = WORDSPACINGMINIMUMTAG +1;
    /**
     * The writingScript attribute tag.
     */
    public static final int WRITINGSCRIPTTAG = WORDSPACINGOPTIMUMTAG +1;
    /**
     * The x attribute tag.
     */
    public static final int XTAG = WRITINGSCRIPTTAG +1;
    /**
     * The xHeight attribute tag.
     */
    public static final int XHEIGHTTAG = XTAG +1;
    /**
     * The xdpContent attribute tag.
     */
    public static final int XDPCONTENTTAG = XHEIGHTTAG +1;
    /**
     * The xmlns attribute tag.
     */
    public static final int XMLNSTAG = XDPCONTENTTAG +1;
    /**
     * The y attribute tag.
     */
    public static final int YTAG = XMLNSTAG +1;
    /*
	 * Ending index of attribute tags.
     */
    static final int XFA_ATTRS = YTAG;
    /**
	 * The starting index of SVG elements.
     */
    public static final int SVG_START = YTAG + 1;
    /**
	 * The ending index of SVG elements.
     */
    public static final int SVG_END = SVG_START + 30;
    
    

	// list of all the possible XFAAttributes
	static final int XFA_PARTIAL_ATTR_COUNT = XFA_ATTRS - XFA_ELEMENTS_ATTRS;
	// list of all the possible XFAElements
	static final int XFA_PARTIAL_ELEMENT_COUNT = XFA_ELEMENTS + 1;
	
	// list of all the possible ELEMENTS AND ATTRIBUTES
	static final int XFA_UNION_COUNT = XFA_ELEMENTS_ATTRS - XFA_ELEMENTS;
	static final int XFA_ELEMENT_COUNT = XFA_PARTIAL_ELEMENT_COUNT + XFA_UNION_COUNT;
	static final int XFA_ATTR_COUNT = XFA_PARTIAL_ATTR_COUNT + XFA_UNION_COUNT;
	
	/**
	 * The starting index of attribute tags.
	 */
    public static final int XFA_ATTRIBUTE_MIN = XFA_ELEMENTS + 2;
	/**
	 * The ending index of attribute tags.
	 */
    public static final int XFA_ATTRIBUTE_MAX  = XFA_ATTRS;
	
	/**
	 * The starting index of element tags.
	 */
    public static final int XFA_ELEMENT_MIN = XFA_START;
	/**
	 * The ending index of element tags.
	 */
    public static final int XFA_ELEMENT_MAX  = XFA_ELEMENTS_ATTRS;

	private static final SchemaStrings mAttributeTags  = new SchemaStrings(XFA_PARTIAL_ATTR_COUNT);
	private static final SchemaStrings mElementTags = new SchemaStrings(XFA_PARTIAL_ELEMENT_COUNT);
	private static final SchemaStrings mUnionTags = new SchemaStrings(XFA_UNION_COUNT-1);
	
	/**
	 * This will initialize the static data of the class.
	 *
	 * @exclude from published api.
	 */
	static {
		for (int i = 0; i < goXFAAtoms.length; i++) {
			final String atom = goXFAAtoms[i];
			if (i <= XFA_ELEMENTS) {
				mElementTags.put(atom, i);
			} else if (i <= XFA_ELEMENTS_ATTRS) {
				mUnionTags.put(atom, i);
			} else if (i <= XFA_ATTRS) {
				mAttributeTags.put(atom, i);
			}
		}
	}





	/**
	 * Find a tag in XFA namespace by name.
	 * 
	 * @param aXFAName the input name to search for. This String must be interned.
	 * @return The tag value, -1 if the name was not found
	 *
	 * @exclude from published api.
	 */
	static public int getTag(String aXFAName) {
		return getTagImpl(aXFAName, null);
	}

	/**
	 * Find an element tag in XFA namespace by name.
	 * 
	 * @param aXFAName the input name to search for. This String must be interned.
	 * @return The tag value, -1 if the name was not found
	 *
	 * @exclude from published api.
	 */
	static public int getElementTag(String aXFAName) {
		return getTagImpl(aXFAName, Boolean.TRUE);
	}

	/**
	 * Find an attribute tag in XFA namespace by name.
	 * 
	 * @param aXFAName the input name to search for. This String must be interned.
	 * @return The tag value, -1 if the name was not found
	 *
	 * @exclude from published api.
	 */
	static public int getAttributeTag(String aXFAName) {
		return getTagImpl(aXFAName, Boolean.FALSE);
	}

	/**
	 * return a string base on a tag
	 * @exclude from published api.
	 */
	static public String getString(int eTag) {
		return goXFAAtoms[eTag];
	}

	/**
	 * return an atom based on a tag
	 * Shouldn't really need this in Java, since atoms are strings
	 * @exclude from published api.
	 */
	static public String getAtom(int eTag) {
		return goXFAAtoms[eTag];
	}

	/**
	 * Private helper function for implementation of getTag().
	 * @param sXFAName the name to the name to search for.
	 * @param bIsElement if true, search the list of elements only;
	 *                   if false, search the list of attributes only; 
	 *                   if null, both are searched.
	 * @return the int (enum) corresponding to the name, or -1 if not found.
	 *
	 * @exclude from published api.
	 */
	@FindBugsSuppress(code="ES")
	static protected int getTagImpl(String sXFAName, Boolean bIsElement) {
		// if the atom is undefined, then there can't be a related tag
		if (sXFAName == null)
			return -1;

		// check the union tags first
		int nPos = mUnionTags.getInt(sXFAName);
		if (nPos == -1 && (bIsElement == null || bIsElement.booleanValue() == true)) {
			// if not yet found, and we're checking all tags or element tags...
			nPos = mElementTags.getInt(sXFAName);
		}
		
		if (nPos == -1 && (bIsElement == null || bIsElement.booleanValue() == false)) {
			// if not yet found, and we're checking all tags or attribute tags...
			nPos = mAttributeTags.getInt(sXFAName);
		}

		return nPos;
	}
	
	/*
	 * Disallow instances of this class.
	 */
	private XFA() {
	}
}
