/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.configuration;


import java.net.URL;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.UriPath;


/**
 * An element that represents a value capable of containing data.
 *
 * @author Ian Benedict Carreon
 * @author Mike Tardif (ported to Java)
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class ConfigurationUri extends ConfigurationValue {

	private final UriPath mUriPath = new UriPath();

    /**
     * Constructor.
     */
	public ConfigurationUri(Element parent, Node prevSibling) {
		// TODO next line should be correct, but causes problems.
		//super(parent, prevSibling, XFA.URITAG, XFA.URI);
		super(parent, prevSibling);
		
		mUriPath.setRefFileLocation(parent.getOwnerDocument().getParseFile());
	}

	/**
	 * @exclude from published api.
	 */
	public Element clone(Element parent, boolean deep) {
		ConfigurationUri oNew = (ConfigurationUri)super.clone(parent, deep);
		if (oNew != null)
			oNew.setConfigLocation(getConfigLocation());
		return oNew;
	}
	
	public URL getConfigLocation() {
		return mUriPath.getRefFileLocation();
	}

//	public String getExeLocation() {
//		return moUriPath.getExeFileLocation();
//	}

	public URL getFile() {
		return mUriPath.getFile(getValue(null).toString());
	}

	public ScriptTable getScriptTable() {
		return ConfigurationUriScript.getScriptTable();
	}

	public void setConfigLocation(URL location) {
		mUriPath.setRefFileLocation(location);
	}

//	public void setExeLocation(String sLocation) {
//		moUriPath.setExeFileLocation(sLocation);
//	}

//	private void setUriPath(UriPath oUriPath) {
//		moUriPath = oUriPath;
//	}

	public void setValue(Attribute oData) {
		super.setValue(oData);
		// Reset the refFileLocation value in moUriPath
 		mUriPath.setRefFileLocation(null);
	}
}
