// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================
package com.adobe.xmp.core;


/**
 * This class represents the set of XMP metadata as a DOM representation. It represents the root node
 * of the XMP tree. An XMPParser always creates an XMPMetadata object and a serializer only works on 
 * XMPMetadata objects. The root node is always an XMPStruct and the children are other XMPNodes.
 *
 */
public interface XMPMetadata extends XMPStruct
{
	/**
	 * This correlates to the about-attribute,
	 * returns the empty String if no name is set.
	 * 
	 * @return Returns the value of rdf:about attribute for XMP object.
	 */
	String getAboutURI();


	/**
	 * Sets the value of rdf:about attribute for the XMP object.
	 * 
	 * @param name value to be set.
	 */
	void setAboutURI(String name);

	
	// Utilities
	/**
	 * Deep clone of the XMP tree
	 * @return returns a deeply cloned copy of the XMP tree
	 */
	XMPMetadata clone();
	
		
}
