/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2006 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.commons.datasource.poolservice;

/** Indicate that no datasource could be found with
 *  the required name.
 */
@SuppressWarnings("serial")
public class DataSourceNotFoundException extends Exception {
    public DataSourceNotFoundException(String dataSourceName, int nProviders) {
        super("No data source found with name '" + dataSourceName + "' (after asking " + nProviders + " providers)");
    }

    public DataSourceNotFoundException(String reason, Throwable cause) {
        super(reason, cause);
    }
}
