/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.result;

/**
 * <code>ResultPage</code> represents one page of the search result. The page
 * size depends on the start and limit parameters set on the query.
 */
public interface ResultPage {

    /**
     * @return zero based index of this result page.
     */
    long getIndex();

    /**
     * @return the start offset for the query result.
     */
    long getStart();

    /**
     * @return whether this page is currently displayed.
     */
    boolean isCurrentPage();
}
