/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.writer;

import javax.jcr.RepositoryException;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

import com.day.cq.search.Query;
import com.day.cq.search.result.Hit;

/**
 * {@linkplain ResultHitWriter} writes a search result {@link Hit} into a
 * {@link JSONWriter}. This is used in the standard servlet for the query
 * builder to allow different output renderings. The appropriate
 * {@link ResultHitWriter} is selected by passing the desired name in the query
 * using <code>p.hitwriter=NAME</code> as request parameter.
 * 
 * <p>
 * Implementations of this interface must be defined as an OSGi component
 * factory. The name of the factory must be the fully qualified name of this
 * interface plus "/" and a distinct short name of the renderer (that will be
 * used in request parameters to select it, <code>NAME</code> above). For
 * example for a {@link ResultHitWriter} under the name "damasset", the SCR
 * annotation would look like this:
 * 
 * <pre>
 * {@literal @}Component(factory=&quot;com.day.cq.search.result.ResultHitWriter/damasset&quot;)
 * </pre>
 * 
 * @since 5.2
 */
public interface ResultHitWriter {

    /**
     * Writes a given {@link Hit} into the {@link JSONWriter}. This will be
     * called for each hit of the result page. The surrounding json structure is
     * an array and each entry should be a simple object. The caller will have
     * invoked the <code>writer.object()</code> already and will call
     * <code>writer.endObject()</code> directly after this method returns.
     * 
     * @param hit
     *            the result hit to render
     * @param writer
     *            to output json
     * @param query
     *            the original query; can be used to access custom parameters
     *            set in the predicate root group (
     *            <code>query.getPredicates().get("param", "default")</code>)
     * @throws RepositoryException
     *             in case access on the hit failed
     * @throws JSONException
     *             in case there is a problem with writing to the jsonwriter
     */
    void write(Hit hit, JSONWriter writer, Query query) throws RepositoryException, JSONException;
}
