/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.requests.logging.api;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>TimedRequest</code> interface provides the functionality to
 * track the details about the processing of a request.
 * This is used in the context of the
 * {@link com.adobe.granite.requests.logging} bundle, which offers details
 * about the longest running requests.
 */
@ProviderType
public interface TimedRequest {
    /**
     * @return the URL requested.
     */
    String getRequestUrl();

    /**
     * @return the request method (GET, POST etc.).
     */
    String getRequestMethod();

    /**
     * @return the time of the request.
     */
    Date getRequestDate();

    /**
     * @return the time elapsed in milliseconds until the request was completed.
     */
    Long getDuration();
}
