/* $Header: /Faultline/com/adobe/acrobat/filters/DCTTables.java 1      */
/*
  DCTTables.java

  This is the incarnation of DCTOpt.h in Java

*/
package com.adobe.internal.pdftoolkit.core.filter;

public interface DCTTables
{
/*-------------------------------------------------------------------------
 dctopt.h contains configuration-independent parameters.
 JPEGOptions.h contains conditional switch declarations derived from the
   DCTOPTIONS compile switch.
 dctcfg.h contains configuration-dependent parameters.
 For !WITHIN_STM, ASFiltExt.h contains declarations used by both the base
 level implementation and clients; for WITHIN_STM, this module is copied
 into the ASFilter.h filter interface.
 -------------------------------------------------------------------------*/

/* This section (dctcfg.h) contains configuration-dependent declarations which were split
 off from dctopt.h on 3/27/96 to better separate common declarations from
 those which vary with products.
 */
//    static final boolean DEBUG  = false;

    /* Lossless (Spatial) JPEG is unimplemented, so LEAVE THIS 0. */
//    static final boolean HAVELOSSLESS  = false;

    /* This is only true for Postscript printers */
      static final boolean ExtendedAPPE = false;

/*-------------------------------------------------------------------------
 ASJPEGEncoding encodes the JPEG sub-type or coding method.  For ASDCTEOpen,
 specifying either ASJPEGEncoding == ASJPEGSequential or ASJPEGBaseline will
 result in JPEG Baseline Sequential coding, if the other parameters are
 compliant with Baseline requirements.  If the other parameters are
 non-compliant, ASJPEGSequential will allow a JPEG Extended Sequential
 coding, while ASJPEGBaseline will return NULL (fail).  Of these two,
 ASJPEGBaseline is recommended to avoid inadvertent use of non-Baseline
 parameter choices which some applications do not implement (and because
 non-baseline choices do not improve compression much).

 ASJPEGBaseline is also recommended over ASJPEGProgressive except maybe for
 Internet images where some applications may utilize the progressivity.
 NOTE: PSL2 Printers do not print ASJPEGProgressive images.

 NOTE: Adobe also does not implement arithmetic coding variations, or the
 lossless, hierarchical, or differential JPEG variations.
 -------------------------------------------------------------------------*/
    static final int ASJPEGBaseline     =0;
    static final int ASJPEGSequential   =1;
    static final int ASJPEGProgressive  =2;


/*-------------------------------------------------------------------------
 Color transform options.
 -------------------------------------------------------------------------*/
    static final int NoColorTransform   = 0;
    static final int RGBtoYUV           = 1;
    static final int CMYKtoYUVK         = 2;

/*------------------------------------------------------------------------
 All Adobe implementations should make the same choices for the parameters
 below; since these have been made, do not change them.
 -------------------------------------------------------------------------*/
 // static final boolean TableDecode    = true;
    /* 1 causes a 128 entry x 2-byte accelerator table to be used for decoding
     each AC HuffTable; 0 uses shift-and-test.  The effect of the table is to
     decode high quality images (QFactor < 0.2) about 7% faster; no gain at
     QFactor = 1.0.  For Baseline, 2 tables use 512 bytes RAM. */

//  static final boolean ProcedureDecode  = false;
    /* 1 causes procedures to be used for MCU decoding, saving 3,720 code bytes
     -O2 compiled on the Sparc.  0 open codes everything.
     USE 0 IN ALL PRODUCTS UNLESS SUPER-TIGHT ON CODE MEMORY. */

//  static final boolean ProcedureGetc  = false;
    /* For DCTDecode, call the ASfgetc procedure instead of the ASgetc macro;
     with  == 1, this saves 200 code bytes.  If GetcSentinel
     also is 1, ProcedureGetc affects only less critical marker ASgetc's.
     USE 0 IN ALL PRODUCTS UNLESS SUPER-TIGHT ON CODE MEMORY. */

//  static final int SqueezeCode    = 0;
    /* 0 enables all speed optimizations; 1 removes some to save storage;
     2 removes more.
     USE 0 IN ALL PRODUCTS UNLESS SUPER-TIGHT ON CODE MEMORY. */

//  static final int ShiftRXform    = 0;
    /* Control IDCT multiply implementation:
       0 shift-and-add about 13 bits accurate.
       1 shift-and-add about 15 bits accurate.
       2 integer constant multiplies (some compilers subst. shift-and-add).
       3 reserved for shift-and-add compatible with multiply (not implemented).
     USE 0 IN ALL PRODUCTS. */

//  static final int ShiftXform = 0;
    /* Control DCT multiply implementation:
       0 shift-and-add about 13 bits accurate.
       1 shift-and-add about 15 bits accurate.
       2 integer constant multiplies (some compilers subst. shift-and-add).
       3 reserved for shift-and-add compatible with multiply
         (only for dctexf.cold.1)
     USE 0 IN ALL PRODUCTS. */

//  static final boolean EnableQClip    = true;
    /* 1 enables the feature that clips to 0 quant. coef. below a minimum. */

//  static final boolean EnableAClip    = (EnableQClip && false);
    /* 1 enables the DCTEncode adaptive quantizer, which clips to 0 using a
     larger threshold for coefficients in MCUs judged to be inactive.  This
     slows compression somewhat due to the computation of block activity.
     NOT READY YET.  DO NOT ENABLE. */

//  static final boolean LimitLowQuantizers = true;
    /* Limit DC quantizer growth for QFactor > 1.0 (only when default tables
     are used) to 50% as fast as normal QFactor scaling.
     THIS IS SUPERIOR; USE 1 IN ALL PRODUCTS. */

//  static final boolean ProgDefHuffTables  = false;
    /* If 1, include 18 default AC HuffTables for progressive JPEG (about
     2,184 code bytes); if 0, force progressive JPEG to use custom
     HuffTables.  Since these are not particularly good defaults, and since
     custom HuffTables slow encoding only 10% while getting 1% to 15% higher
     compression, USE 0 IN ALL PRODUCTS. */

//  static final boolean ManyHuffDefaults = (ProgDefHuffTables || true);
    /* 1 is 11/15/93 4 default AC and 3 default DC HuffTables; 0 is the two
     10/15/91 tables used in 2011 to 2014; (very old 2010 tables no longer
     supported); USE 1 IN ALL PRODUCTS. */

//  static final boolean DCTExtensions = true;
    /* 1 enables the non-Baseline JPEG sequential mode extensions (currently
     allows Sum(HS*VS) > 10 and > 2 HuffTables.  USE 1 IN ALL PRODUCTS. */

    static final boolean BuildAdobeScanDir = true;
    /* 1 compiles code to build (DCTEncode) or read back (DCTDecode) an
     optional scan directory in the APPE marker for progressive JPEG images.
     The directory is not written for sequential JPEG.  The directory is
     intended for clients' use in managing the decoding byte stream when
     progressivity is of interest. */

//  static final boolean FixupAdobeScanDir  = (BuildAdobeScanDir && true);
    /* 1 compiles code to reposition DCTEncode's baseStm at the end of
     compression and write scan positions into the scan directory (iff there
     is a scan directory and the output baseStm is positionable). */

    static final boolean UserMarkers    = false;
    /* If 1, compile in DCTEncode code to output after the initial SOI marker
     a chain of caller-formatted APPn, COM, or other markers.  If 1, compile
     in DCTDecode code to issue the decodeUserMarker callback for every COM
     or APPn marker except the Adobe APPE marker.  (STANDALONE and WITHIN_STM
     features to write JFIF and COM markers use this mechanism; Photoshop uses
     it for its private APPD marker containing resource data.) */

    static final boolean BuildCaption    = false;
     /* If 1, include code to put a caption into the Adobe APPE marker when
      encoding and to save any caption from an Adobe marker when decoding.
      If 0, do not include code to create the caption or to save it, but do
      include decoder code to skip the property in the marker property list. */

//  static final boolean BigCT    = true;
     /* If 1, maintain 16-bit intermediate values when decoding */

/*--------------------------------------------------------------------------
 There are no configuration-dependent definitions below this point except for
 debugging functions.  Everything different about PostScript, PhotoShop,
 Acrobat, and other applications is (should be) defined above.
 --------------------------------------------------------------------------*/

/*------------------------------------------------------------------------
 The following debugging compile options SHOULD BE 0 IN SHIPPING PRODUCTS
 (except that CountEncStm will be forced to 1 if BuildAdobeScanDir==1).

 All configurations define ASAssert in ASEXCEPT; JPEG filters redefine
 ASDebugAssert here and do not use ASCantHappen in the ASEXCEPT interface.
 The dctcanth.c implementation for STMTEST and STANDALONE prints out
 source module and line number if DEBUG == 1 (or defaults DEBUG from
 STAGE==DEVELOP if undefined) while suppressing this mechanism otherwise
 to reduce code size for shipping products.  A source comment can add more
 explanation, if needed.  When EnableDAsserts is 1, locally define
 ASDebugAssert here as either nothing or as ASAssert to permit local
 debugging of just the DCT filters in an otherwise EXPORT configuration.

 For PSL2, custom HuffTables and HuffCounts may be returned in a private
 structure for single image compression, or in the PSL2 DCTEncode parameter
 dictionary, if PSL2HuffReturn == 1.  The DataStudy and HuffCounts dictionary
 keys are non-Redbook and are not in any shipping product.

 The StudyQErr and StudyRecon debugging features are needed in special PS
 products for qualifying PS diagnostics.  They will ordinarily be enabled
 in whichever DEVELOP stage adobe sps product I use for debugging and
 disabled in all shipping products.  These options require the extra code
 which StudyOptions == 1 compiles.  StudyQErr is automatically computed from
 the values of PrivateQErrReturn and PSL2QErrReturn.  This feature adds about
 1300 code bytes and requires the dctdxf.c module to be included in the
 encode filter.
 -------------------------------------------------------------------------*/

// static final boolean EnableDAsserts  = DEBUG;
   /* 1 ASDebugAssert statements compile their checks; 0, noops. */
// static final boolean StudyQErr   = false;
// static final boolean StudyRecon  = false;

/*------------------------------------------------------------------------
 The following compile options ARE FOR SPECIAL-PURPOSE DEBUGGING ONLY.
 'Selected blocks' means that the option applies to any block such that
    begin_blk <= block no. < end_blk
 where begin_blk and end_blk are specified by commandline switches in the
 STANDALONE test program.  [NOTE: In modifying debug switch settings, edit
 only the 0 or 1.  Other logic forces values to be consistent when features
 are used in combination; e.g. define SummarizeHuffCount 1 forces
 StudyOptions to 1.]
 -------------------------------------------------------------------------*/
// static final boolean PrintAllocate   = false;
    /* 1 prints allocation results in dctalloc.c */
// static final boolean ShowSelectedBlock   = false;
    /* 1 prints the transform input and output and the rev_transform input
     (and, data_study only, rev_transform output) of selected blocks. */
// static final boolean PrintDecodeFSM   = false;
    /* 1 prints decoder finite state machine progress messages. */
// static final boolean PrintDictOptions   = false;
    /* 1 prints options decoded from the PS filter dictionary; no effect on
     non-PSL2. */
// static final boolean PrintECTTables   = false;
    /* 1 prints encoder ColorTransform tables. */
// static final boolean PrintCTDTables   = false;
    /* 1 prints decoder ColorTransform tables. */
// static final boolean PrintScaledQT   = false;
    /* 1 prints quantizer scaling array, scaled quantizer tables, and
     zeroclip tables. */
// static final boolean PrintEQTables   = false;
    /* 1 prints encoder QuantTables. */
// static final boolean PrintEHuffData   = false;
    /* 1 prints encoder Huff tables. */
// static final boolean TraceEHuff   = false;
    /* 1 traces encoder huff codes in selected blocks. */
// static final boolean CheckEncodeData   = false;
    /* 1 checks the Huffman encode data; fail if allowed ranges are exceeded. */
// static final boolean PrintBackoff   = false;
    /* 1 prints encoder edge fix params. */
// static final boolean SummarizeHuffCounts   = false;
    /* 1 prints HuffCounts tables returned on a data_study in the STANDALONE
     summary.  No effect on other configurations. */
// static final boolean SummarizeHuffTables   = false;
    /* 1 prints HuffTables computed on a data_study in the STANDALONE or
     PostScript summary. */
// static final boolean SummarizeQXFSizes   = ((StudyRecon || StudyQErr) && false);
    /* 1 to include code to compute quant. coef. magnitude statistics for each
     quant. coef. in 8x8 XF blocks.   If compiled, the study occurs when a
     reconstructed image or quantized coefficient error study is performed. */
// static final boolean PrintDQTables   = false;
    /* 1 prints decoder quant. tables. */
// static final boolean PrintDHuffData   = false;
    /* 1 prints decoder HuffTables. */
// static final boolean PrintDHuffExtras   = false;
    /* 1 prints decoder auxiliary coding tables */
// static final boolean TraceDHuff   = false;
    /* 1 traces decoder Huff codes in selected blocks. */
// static final boolean PrintMaxRowCol   = false;
    /* 1 prints the max row and max col counts of decoder input. */
// static final boolean PrintRevXFOvf   = false;
    /* 1 prints each reverse transform overflow and underflow. */
// static final boolean SummarizeRevXFOvf   = false;
    /* 1 figures the min. underflow and max. overflow of the reverse transform
     and report it in the summary. */
// static final boolean TraceNearMarkers   = false;
    /* 1 prints decoder status near markers. */
// static final boolean ReportMarkers   = false;
    /* 1 prints a msg for every JPEG marker during decoding.  Requires
     CountDecStm == 1. */
// static final boolean ReportScans   = false;
    /* 1 prints a msg with the ASStm position (byte count) after each scan */
// static final boolean CountDecStm = (ReportMarkers || TraceNearMarkers || false);
    /* Count bytes in the DCTDecode ASStm and non-zero dc and ac coef. */
// static final boolean CountEncStm = (ReportScans || BuildAdobeScanDir || false);
    /* Count bytes in the DCTEncode ASStm; build the scanPos table. */
// static final boolean ShowActiveBlocks    = (EnableAClip && false);
    /* Modify the image to show black where the adaptive quantizer chooses
     active, white for inactive, gray for somewhat inactive. */

/* QuantCoefRaster and StudyOptions were declared in dctcfg.h; force these
 to 1 if the combinations of the declarations are inconsistent.
 */
// static final boolean IncludeConverters   = false;
   static final boolean QuantCoefRaster = true;
// static final boolean PSL2HuffReturn   = false;

// static final boolean StudyOptions = (StudyQErr || StudyRecon || PSL2HuffReturn ||
//                                      SummarizeHuffCounts || SummarizeHuffTables ||
//                                      SummarizeQXFSizes || QuantCoefRaster);

    static final int NErrCounters   = 513;
    static final int MaxErrCounter  = 256;
/*-------------------------------------------------------------------------*/

    static final int ASDCTMaxColors =  4;
    static final int MAX_COMP_PER_SCAN = 4;     /* This is a JPEG limit. */
    static final int MAX_CODE_TBLS =  4;         /* 4 is a JPEG limit. */

/* Define info and optional flags passed in APPE marker.  Color transform
 code is also passed.  Philosophy: every optional encoder transformation
 is described in this info.
 */
    static final int DCTFlags = 0;
   /* Non-aborting variations signalled in left-half, aborting in right-half.
    avgSSFlag==1 if downsampled pixels are averaged, 0 if chopped.  No
      current effect on decoder.
    accurateCTFlag==1 if the encoder used AccurateCT, else 0.
    dontKnowAvgSSFlag==1 when avgSSFlag might be wrong.
    dontKnowAccCTFlag==1 when accurateCTFlag might be wrong.
    dontKnowCTFlag==1 when the color transform byte might be wrong.
    */
    static final int avgSSFlag         = 0x80000000;
    static final int accurateCTFlag    = 0x40000000;
    static final int dontKnowAvgSSFlag = 0x20000000;
    static final int dontKnowAccCTFlag = 0x10000000;
    static final int dontKnowCTFlag    = 0x4000000;

/* JPEG Marker codes; Baseline sequential, extended sequential (8-bit input pixels
   only), and progressive are implemented.  The arithmetic coding variations are
   unimplemented; lossless is unimplmented.
 */
    static final int SOF0_MARKER = 0xC0;   /* 192d or 300b; Baseline Sequential */
    static final int SOF1_MARKER = 0xC1;   /* 193d or 301b; Extended Sequential */
    static final int SOF2_MARKER = 0xC2;   /* 194d or 302b; Progressive */
    static final int SOF3_MARKER = 0xC3;   /* 195d or 303b; Lossless */

    static final int SOF5_MARKER = 0xC5;   /* 197d or 305b; Differential sequential */
    static final int SOF7_MARKER = 0xC7;   /* 199d or 307b; Differential lossless */

    static final int SOF9_MARKER = 0xC9;   /* 201d or 311b */
    static final int SOFF_MARKER = 0xCF;   /* 207d or 317b */

    static final int DHT_MARKER = 0xC4;    /* 196d or 304b */
    static final int DRI_MARKER = 0xDD;    /* 221d or 335b */
/* RST0 is the first of 8 restart with modulo 8 count markers. */
    static final int RST0_MARKER = 0xD0;   /* 208d or 320b */

    static final int SOI_MARKER = 0xD8;    /* 216d or 330b */
    static final int EOI_MARKER = 0xD9;    /* 217d or 331b */
    static final int SOS_MARKER = 0xDA;    /* 218d or 332b */
    static final int DQT_MARKER = 0xDB;    /* 219d or 333b */
    static final int DNL_MARKER = 0xDC;    /* 220d or 334b */

/* APP0..APPD are application-specific markers. */
    static final int APP0_MARKER = 0xE0;   /* 224d or 340b */
    static final int APPD_MARKER = 0xED;   /* 237d or 355b */
/* APPE is used by Adobe's implementation for its internal purposes
   (version number; optional features implemented).
 */
    static final int APPE_MARKER = 0xEE;   /* 238d or 356b */
    static final int APPF_MARKER = 0xEF;   /* 239d or 357b */
    static final int COM_MARKER = 0xFE;    /* 254d or 376b */
    static final int FIL_MARKER = 0xFF;    /* 255d or 377b */

/* JPEG 10918-3 extension markers (unimplemented) */
    static final int VER_MARKER = 0xF0;
    static final int DTI_MARKER = 0xF1;
    static final int DTF_MARKER = 0xF2;
    static final int SRF_MARKER = 0xF3;
    static final int SRS_MARKER = 0xF4;
    static final int DCR_MARKER = 0xF5;
    static final int DQS_MARKER = 0xF6;

/* Fast horizontal strip handling options */
    static final int SLOWSTRIP  = 0;
    static final int FAST211    = 1;
    static final int FAST111CT  = 2;
    static final int FAST211CT  = 3;
    static final int FAST1111CT = 4;
    static final int FAST2112CT = 5;
/* define VFAST211211 6 */
/* define VFAST21122112 7 */
}
