/*
 * File: SchemaInfo.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.xmp.schema.rng.model;

/**
 * This class handles schema level info such as label and description, which is extracted from annotations from RelaxNG
 * schema.
 * 
 * @author hraghav
 */
public class SchemaInfo
{
	private String label;

	private String description;

	private String prefix;

	/**
	 * Gets the label to be used for this schema
	 * 
	 * @return label extracted from rng schema for this XMP schema
	 */
	public String getLabel()
	{
		return label;
	}

	/**
	 * Sets the extracted label from rng schema
	 * 
	 * @param label
	 *            label to set
	 */
	public void setLabel(String label)
	{
		this.label = label;
	}

	/**
	 * Gets the description to be used for this schems
	 * 
	 * @return description extracted from rng schema for this XMP schema
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * Sets the description extracted from rng schema
	 * 
	 * @param description
	 *            description to set
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

	/**
	 * Gets the prefix defined to be used for this schema
	 * 
	 * @return prefix to use
	 */
	public String getPrefix()
	{
		return prefix;
	}

	/**
	 * Sets the prefix defined to be used for this schema.
	 * 
	 * @param prefix
	 *            prefix to use
	 */
	public void setPrefix(String prefix)
	{
		this.prefix = prefix;
	}
}