package com.day.cq.commons.predicate;

import com.day.cq.commons.jcr.JcrConstants;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Predicate used to filter Template nodes.
 */
@Component(metatype = false)
@Service(Predicate.class)
@Properties({
        @Property(name = "predicate.name", value = "template")
})
public class IsTemplateNodePredicate   extends AbstractNodePredicate implements Predicate {

    /**
     * default logger
     */
    private final Logger log = LoggerFactory.getLogger(IsTemplateNodePredicate.class);
    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is an nt:folder containing templates or cq:Template node.
     */
    public boolean evaluate(Node node) throws RepositoryException {
        if (node.getPrimaryNodeType().getName().equals("cq:Template")) {
            return true;
        }
        if(node.getPrimaryNodeType().getName().equals(JcrConstants.NT_FOLDER)) {
            if(!node.hasNodes()) {
                return false;
            }
            return true;
        }
        return false;
    }
}
