/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api.metadata.xmp;

import static com.day.cq.commons.jcr.JcrConstants.JCR_TITLE;
import static com.day.cq.dam.api.DamConstants.DC_CONTRIBUTOR;
import static com.day.cq.dam.api.DamConstants.DC_COVERAGE;
import static com.day.cq.dam.api.DamConstants.DC_CREATOR;
import static com.day.cq.dam.api.DamConstants.DC_DATE;
import static com.day.cq.dam.api.DamConstants.DC_DESCRIPTION;
import static com.day.cq.dam.api.DamConstants.DC_FORMAT;
import static com.day.cq.dam.api.DamConstants.DC_IDENTIFIER;
import static com.day.cq.dam.api.DamConstants.DC_LANGUAGE;
import static com.day.cq.dam.api.DamConstants.DC_PUBLISHER;
import static com.day.cq.dam.api.DamConstants.DC_RELATION;
import static com.day.cq.dam.api.DamConstants.DC_RIGHTS;
import static com.day.cq.dam.api.DamConstants.DC_SUBJECT;
import static com.day.cq.dam.api.DamConstants.DC_TITLE;
import static com.day.cq.dam.api.DamConstants.TIFF_IMAGELENGTH;
import static com.day.cq.dam.api.DamConstants.TIFF_IMAGEWIDTH;
import static com.day.cq.dam.api.DamConstants.EXIF_PIXELXDIMENSION;
import static com.day.cq.dam.api.DamConstants.EXIF_PIXELYDIMENSION;

import java.util.HashMap;
import java.util.Map;

/**
 * The <code>XmpMappings</code> class ...
 */
public interface XmpMappings {
    static final Map<String , String> defaultSimpleXmpMappings =
           new HashMap<String , String>() {{
        // dc
        put("identifier", DC_IDENTIFIER);
        put("format", DC_FORMAT);
        put("coverage", DC_COVERAGE);
        put("rights", DC_RIGHTS);
        put("Rights", DC_RIGHTS);
        put("title", DC_TITLE + "," + JCR_TITLE);
        put("Title", DC_TITLE + "," + JCR_TITLE);
        put("dc:title", DC_TITLE + "," + JCR_TITLE);
        put("Object Name", DC_TITLE + "," + JCR_TITLE)   ;

        // xmp
        put("CreationDate", "xmp:CreateDate");
        put("createdate", "xmp:CreateDate");
        put("creatortool", "xmp:CreatorTool");
        put("modifydate", "xmp:ModifyDate");
        //commons imaginge has changed modifydate to DateTime, hence adjusting
        //not removing older
        put("DateTime", "xmp:ModifyDate");
        put("modificationdate", "xmp:ModifyDate");
        put("ModificationDate", "xmp:ModifyDate");

        // exif tiff
        put("Compression", "tiff:Compression");
        put("CreateDate", "tiff:DateTime,exif:DateTimeOriginal");
        put("Make", "tiff:Make");
        put("Model", "tiff:Model");
        put("ExifImageWidth", EXIF_PIXELXDIMENSION);
        put("ExifImageLength", EXIF_PIXELYDIMENSION);
        put("ResolutionUnit", "tiff:ResolutionUnit");
        put("Resolution Unit", "tiff:ResolutionUnit");
        put("YCbCrPositioning", "tiff:YCbCrPositioning");
        put("ImageDescription", "tiff:ImageDescription");
        put("Image Description", "tiff:ImageDescription");
        put("Orientation", "tiff:Orientation");
        put("X Resolution", "tiff:XResolution");
        put("Y Resolution", "tiff:YResolution");
        put("XResolution", "tiff:XResolution");
        put("YResolution", "tiff:YResolution");
        put("ImageWidth", TIFF_IMAGEWIDTH);
        put("ImageLength", TIFF_IMAGELENGTH);
        put("Image Width", TIFF_IMAGEWIDTH);
        put("Image Height", TIFF_IMAGELENGTH);
        put("Image Length", TIFF_IMAGELENGTH);
        put("Exif Image Width", TIFF_IMAGEWIDTH);
        put("Exif Image Height", TIFF_IMAGELENGTH);
        put("PhotometricInterpretation", "tiff:PhotometricInterpretation");
		put("Photometric Interpretation", "tiff:PhotometricInterpretation");
        put("Bits Per Sample", "tiff:BitsPerSample");
        put("SamplesPerPixel", "tiff:SamplesPerPixel");
        put("Samples Per Pixel", "tiff:SamplesPerPixel");
        put("PlanarConfiguration", "tiff:PlanarConfiguration");
        put("Planar Configuration", "tiff:PlanarConfiguration");
        put("YCbCrSubSampling", "tiff:YCbCrSubSampling");
        put("TransferFunction", "tiff:TransferFunction");
        put("Transfer Function", "tiff:TransferFunction");
        put("WhitePoint", "tiff:WhitePoint");
        put("PrimaryChromaticities", "tiff:PrimaryChromaticities");
        put("Primary Chromaticities", "tiff:PrimaryChromaticities");
        put("YCbCrCoefficients", "tiff:YCbCrCoefficients");
        put("ReferenceBlackWhite", "tiff:ReferenceBlackWhite");
        put("Software", "tiff:Software");
        put("Artist", "tiff:Artist");
        put("Copyright", "tiff:Copyright");
        put("Copyright Notice", "tiff:Copyright");

        // exif
        put("Contrast", "exif:Contrast");
        put("CompressedBitsPerPixel", "exif:CompressedBitsPerPixel");
        put("PhotographicSensitivity", "psAux:ISO"); // Bug 29556
        put("ApertureValue", "exif:ApertureValue");
        put("MaxApertureValue", "exif:MaxApertureValue");
        put("BrightnessValue", "exif:BrightnessValue");
        put("FNumber", "exif:FNumber");
        put("ColorSpace", "exif:ColorSpace");
        put("Sharpness", "exif:Sharpness");
        put("FileSource", "exif:FileSource");
        put("FocalLength", "exif:FocalLength");
        put("ExposureMode", "exif:ExposureMode");
        put("Saturation", "exif:Saturation");
        put("FlashpixVersion", "exif:FlashpixVersion");
        put("ExposureTime", "exif:ExposureTime");
        put("LightSource", "exif:LightSource");
        put("SceneCaptureType", "exif:SceneCaptureType");
        put("ExposureProgram", "exif:ExposureProgram");
        put("MeteringMode", "exif:MeteringMode");
        put("DateTimeOriginal", "exif:DateTimeOriginal");
        put("DateTimeDigitized", "exif:DateTimeDigitized");
        put("SceneType", "exif:SceneType");
        put("WhiteBalance", "exif:WhiteBalance");
        put("Flash", "exif:Flash");
        put("CustomRendered", "exif:CustomRendered");
        put("ExifVersion", "exif:ExifVersion");
        put("FocalLengthIn35mmFormat", "exif:FocalLengthIn35mmFormat");
        put("FocalLengthIn35mmFilm", "exif:FocalLengthIn35mmFilm");
        put("SensingMethod", "exif:SensingMethod");
        put("ShutterSpeedValue", "exif:ShutterSpeedValue");
        put("SubSecTimeOriginal", "exif:SubSecTimeOriginal");
        put("SubSecTimeDigitized", "exif:SubSecTimeDigitized");
        put("ExifOffset", "exif:ExifOffset");
        put("ExposureCompensation", "exif:ExposureCompensation");
        //exif GPS
        put("GPSVersionID", "exif:GPSVersionID");
        put("GPSAltitude", "exif:GPSAltitude");
        put("GPSAltitudeRef", "exif:GPSAltitudeRef");
        put("GPSImgDirectionRef", "exif:GPSImgDirectionRef");
        put("GPSImgDirection", "exif:GPSImgDirection");
        put("GPSDestBearingRef", "exif:GPSDestBearingRef");
        put("GPSDestBearing", "exif:GPSDestBearing");
        put("GPSTimeStamp", "exif:GPSTimeStamp");
        put("GPSDateStamp", "exif:GPSDateStamp");
        put("GPSSatellites", "exif:GPSSatellites");
        put("GPSStatus", "exif:GPSStatus");
        put("GPSTrack", "exif:GPSTrack");
        put("GPSTrackRef", "exif:GPSTrackRef");
        put("GPSDOP", "exif:GPSDOP");
        put("GPSDifferential", "exif:GPSDifferential");
        put("GPSDestDistanceRef", "exif:GPSDestDistanceRef");
        put("GPSDestDistance", "exif:GPSDestDistance");
        put("GPSDestLatitudeRef", "exif:GPSDestLatitudeRef");
        put("GPSDestLatitude", "exif:GPSDestLatitude");
        put("GPSDestLongitudeRef", "exif:GPSDestLongitudeRef");
        put("GPSDestLongitude", "exif:GPSDestLongitudeRef");
        put("GPSInfo", "exif:GPSInfo");
        put("GPSLatitudeRef", "exif:GPSLatitudeRef");
        put("GPSLongitudeRef", "exif:GPSLongitudeRef");
        put("GPSSpeed", "exif:GPSSpeed");
        put("GPSSpeedRef", "exif:GPSSpeedRef");
        put("GPSProcessingMethod", "exif:GPSProcessingMethod");
        put("GPSAreaInformation", "exif:GPSAreaInformation");
        put("GPSMeasureMode", "exif:GPSMeasureMode");

        //iptc
        put("Country/Primary Location Name", "photoshop:Country");
        put("Country Code", "Iptc4xmpCore:CountryCode");
        put("Country/Primary Location Code", "Iptc4xmpCore:CountryCode");
        put("Intellectual Genre", "Iptc4xmpCore:IntellectualGenre");
        put("Province/State", "photoshop:State");
        put("City", "photoshop:City");
        put("Country Name", "Iptc4xmpExt:CountryName");
        put("Category", "photoshop:Category");
        put("Supplemental Category", "photoshop:SupplementalCategories");
        put("Urgency","photoshop:Urgency");
        put("By-line Title","photoshop:AuthorsPosition");
        put("Headline","photoshop:Headline");
        put("Special Instruction","photoshop:Instructions");
        put("Source","photoshop:Source");
        put("Original Transmission Reference","photoshop:TransmissionReference");
        put("Credit","photoshop:Credit");
        put("Headline","photoshop:Headline");
        put("Writer/Editor","photoshop:CaptionWriter");
    }};

    static final Map<String , String> defaultBagXmpMappings =
           new HashMap<String , String>() {{
        // dc
        put("language", DC_LANGUAGE);
        put("publisher", DC_PUBLISHER);
        put("relation", DC_RELATION);
        put("contributor", DC_CONTRIBUTOR);
        put("subject", DC_SUBJECT);
        put("Subject", DC_SUBJECT);
        put("Keywords", DC_SUBJECT);
        put("GPSLatitude", "exif:GPSLatitude");
        put("GPSLongitude", "exif:GPSLongitude");
        put("SubjectArea", "exif:SubjectArea");
        put("BitsPerSample", "tiff:BitsPerSample");

    }};

    static final Map<String , String> defaultSeqXmpMappings =
           new HashMap<String , String>() {{
        // dc
        put("creator", DC_CREATOR);
        put("Creator", DC_CREATOR);
        put("Creator Tool",DC_CREATOR);
        put("By-line",DC_CREATOR);
        put("Originating Program", DC_CREATOR);
        put("date", DC_DATE);
        put("Date Created", DC_DATE);

        // exif
        put("ComponentsConfiguration", "exif:ComponentsConfiguration");
    }};

    static final Map<String , String> defaultAltXmpMappings =
           new HashMap<String , String>() {{
        // dc
        put("description", DC_DESCRIPTION);
        put("Caption/Abstract", DC_DESCRIPTION);
        put("Caption-Abstract", DC_DESCRIPTION);
    }};
}
