/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security;

/**
 * Exception indicates that an {@link Authorizable Authorizable}
 * can not be resolved.
 *
 * @deprecated cq 5.5
 */
public class NoSuchAuthorizableException extends RuntimeException {

    private String authorizable;

    private static String DEFAULT_MESSAGE = "No Authorizable with ID %s";

    private static final long serialVersionUID = 3626245256148675980L;

    public NoSuchAuthorizableException(String authorizable) {
        this(String.format(DEFAULT_MESSAGE, authorizable), null, authorizable);
    }

    public NoSuchAuthorizableException(String msg, Throwable t, String authorizable) {
        super(msg, t);
        this.authorizable = authorizable;

    }

    public String getAuthorizable() {
        return authorizable;
    }
}
