/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Represents a data type for structured content provided by a Content Fragment.
 *
 * <p>Data types are used to extend text-based Content Fragments with structured, typed
 * data. Fragments with structured data are called Structured Content Fragments.</p>
 *
 * <p>The defining type strings (@see {@link #getTypeString()}} for available types
 * are defined by {@link BasicDataType}.</p>
 *
 * <p>Additionally, arrays of each data type are supported ("multi-value").</p>
 *
 * @since 1.1
 */
@ProviderType
public interface DataType {

    /**
     * Gets the string representation of the data type.
     *
     * <p>The string representation must be unique and is used to identify the type (and
     * some related data like mappings, etc.) within the repository.</p>
     *
     * <p>Note that it is recommended to use {@link #getValueType()} and
     * {@code getSemanticType()}, which provide more precise and normalized access to the
     * type information.</p>
     *
     * @deprecated Use {@link #getValueType()} and {@link #getSemanticType()}
     *
     * @return The string representation of the data type
     */
    @Deprecated
    @NotNull
    String getTypeString();

    /**
     * Gets the value type of the data type.
     *
     * <p>The value type defines how a value is persisted. The list of value types is
     * provided through {@link BasicDataType}, except for the values deprecated there.</p>
     *
     * @return The value type
     */
    @NotNull
    String getValueType();

    /**
     * Gets the semantic type of the data type.
     *
     * <p>The semantic type defines how the stored value should be interpreted and mapped
     * to a Java object. For example, a semantic type {@code content-fragment} defines that
     * a value of value type {@code string} provides the path to a (nested) Content
     * Fragment.</p>
     *
     * <p>Content Fragments ship with a set of predefined semantic types, defined by the
     * constants found in {@link SemanticDataType}.</p>
     *
     * @return The semantic type
     */
    @Nullable
    String getSemanticType();

    /**
     * Determines if the data type represents an array of values.
     *
     * @return {@code true} if the data type represents a collection of values;
     *         {@code false} if the data type represents a single value
     */
    boolean isMultiValue();

}
