/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm.converter;

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.dam.cfm.ContentFragmentException;

/**
 * <p>Provides means to convert texts of a certain content type to another content type.</p>
 *
 * <p>The entire conversion process uses HTML as base format. This means that you might
 * need two conversion steps to convert a text from format A to format B: First, you
 * convert format A to HTML. Then the HTML to format B.</p>
 *
 * <p>For example, to convert a plain text to Markdown, use the following snippet:</p>
 *
 * <code>
 * String html = converter.convertToHTML(plainText, "text/plain");<br>
 * String markdown = converter.convertToType(html, "text/x-markdown");
 * </code>
 *
 * <p>Note that depending on the quality of the {@link ContentTypeAdapter} implementations
 * (or the target text format) you might loose some (or all) formatting.</p>
 *
 * <p>Additional {@link ContentTypeAdapter}s can be provided by external bundles. To
 * override default adapters, use the OSGi service ranking. The default adapters have a
 * service ranking of 0.</p>
 */
@ProviderType
public interface ContentTypeConverter {

    /**
     * Converts a given text of the specified format to its HTML equivalent.
     *
     * @param text The text
     * @param type The MIME type of the text's format
     * @return The HTML equivalent
     * @throws ContentFragmentException if the conversion failed
     */
    String convertToHTML(String text, String type) throws ContentFragmentException;

    /**
     * Converts the given HTML fragment to an equivalent text of the specified
     * target format.
     *
     * @param html The original HTML fragment
     * @param type The MIME type of the target format
     * @return The converted text
     * @throws ContentFragmentException if the conversion failed
     */
    String convertToType(String html, String type) throws ContentFragmentException;

}
