/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.sightly;

/**
 * This class defines the WCM bindings which are expected to be available to Sightly scripts.
 **/
public final class WCMBindings {

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.components.ComponentContext}
     * object (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_COMPONENT_CONTEXT} instead.
     */
    public static final String COMPONENT_CONTEXT = "componentContext";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.components.EditContext}
     * object (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_EDIT_CONTEXT} instead.
     */
    public static final String EDIT_CONTEXT = "editContext";

    /**
     * Name for the scripting variable referencing the {@link org.apache.sling.api.resource.ValueMap properties}
     * of the current resource (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_PROPERTIES} instead.
     */
    public static final String PROPERTIES = "properties";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.PageManager}
     * object (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_PAGE_MANAGER} instead.
     */
    public static final String PAGE_MANAGER = "pageManager";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.Page current page}
     * object (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_CURRENT_PAGE} instead.
     */
    public static final String CURRENT_PAGE = "currentPage";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.Page resource page}
     * object (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_RESOURCE_PAGE} instead.
     */
    public static final String RESOURCE_PAGE = "resourcePage";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.commons.inherit.InheritanceValueMap
     * page properties} of the current
     * page (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_PAGE_PROPERTIES} instead.
     */
    public static final String PAGE_PROPERTIES = "pageProperties";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.components.Component}
     * of the current resource (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_COMPONENT} instead.
     */
    public static final String COMPONENT = "component";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.designer.Designer}
     * object (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_DESIGNER} instead.
     */
    public static final String DESIGNER = "designer";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.designer.Design design}
     * of the current page (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_CURRENT_DESIGN} instead.
     */
    public static final String CURRENT_DESIGN = "currentDesign";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.designer.Design design}
     * of the resource page (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_RESOURCE_DESIGN} instead.
     */
    public static final String RESOURCE_DESIGN = "resourceDesign";

    /**
     * Name for the scripting variable referencing the {@link com.day.cq.wcm.api.designer.Style style}
     * of the current cell (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_CURRENT_STYLE} instead.
     */
    public static final String CURRENT_STYLE = "currentStyle";

    /**
     * Name for the scripting variable referencing the {@link com.adobe.granite.xss.XSSAPI xssAPI protection service}
     * currently in use (value is {@value}).
     *
     * @deprecated Use {@link com.day.cq.wcm.scripting.WCMBindingsConstants#NAME_XSSAPI} instead.
     */
    public static final String XSSAPI = "xssAPI";

    /**
     * Name for the scripting variable referencing {@link SightlyWCMMode} (value is {@value}).
     *
     * */
    public static final String WCM_MODE = "wcmmode";

    /**
     * Name for the scripting variable referencing the {@link org.apache.sling.api.resource.ValueMap inherited page
     * properties} (value is {@value}).
     * */
    public static final String INHERITED_PAGE_PROPERTIES = "inheritedPageProperties";
}
