/*
 * File: BitmapConsumer.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font;

/** Receives events for bitmaps. 
 * 
 * This interface is experimental and will likely change significantly.
 * 
 * A BitmapConsumer can receive multiple bitmaps. The calls to 
 * this interface must follow the pattern 
 * (startBitmap (addRun)* endBitmap)*.
 */

public interface BitmapConsumer {
  /** Called at the beginning of a bitmap.
   * 
   * @param n some identifier for the bitmap. The meaning of that identifier
   * is not defined by this interface, but that the contract between the
   * client and the provider of this interface.
   */
  public void startBitmap (int n);
  
  /** Add a run of black pixels to the bitmap. */
  public void addRun (double xOn, double xOff, double y);
  
  /** End of a bitmap. */
  public void endBitmap ();
}
