package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.GlyphBBoxCalculator;
import com.adobe.fontengine.font.GlyphBBoxOutlineConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;

public class TrueTypeGlyphBBoxCalculator implements GlyphBBoxCalculator {

	private final boolean hinted;
	private final int scaling;
	
	TrueTypeGlyphBBoxCalculator(boolean hinted, int scaling) 
			throws InvalidFontException, UnsupportedFontException {
		this.hinted = hinted;
		this.scaling = scaling;
	}
	
	public Rect calculateBBox(FontData font, int glyphID)
			throws InvalidFontException, UnsupportedFontException {
		GlyphBBoxOutlineConsumer consumer;
		
		if (hinted) {
			TTScaler hintedOutline = new TTScaler((OpenTypeFont)font, null);	
			hintedOutline.setScale(scaling, scaling, scaling, 0, 0);
			consumer = new GlyphBBoxOutlineConsumer(Matrix.IDENTITY_MATRIX);
			consumer.reset();
			consumer.setMatrix(Matrix.IDENTITY_MATRIX);
			hintedOutline.getOutline(glyphID, consumer);
		} else {
			consumer = new GlyphBBoxOutlineConsumer(new Matrix(scaling, 0, 0, scaling, 0, 0));
			consumer.reset();
			TTParser unhintedOutline = new TTParser();
			unhintedOutline.parse((OpenTypeFont)font, glyphID, consumer);
		}

		return consumer.getBBox();
	}

}
