/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.asset.api;

import javax.jcr.Binary;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ConsumerType;

/**
 * <code>BinaryRendition</code> is a read only representation of a particular rendition of an {@link Asset}.
 * <p>
 * BinaryRendition is an extension of a Rendition which is an extension of a Sling Resource, therefore its adaptable.
 * <p>
 * BinaryRendition is created by {@link Asset#setRendition(String, Binary, java.util.Map)} and can be
 * retrieved either via {@link Asset#getRendition(String)} or by adapting a rendition {@link Resource}
 * to a <code>BinaryRendition</code> type.
 */
@ConsumerType
public interface BinaryRendition extends Rendition {
    /**
     * Returns the <code>Binary</code> of this rendition.
     *
     * @return The rendition's binary, or <code>null</code> if the binary is not found.
     *
     * @throws AssetIOException if cannot get binary
     */
    Binary getBinary();
}
