/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import org.apache.jackrabbit.oak.spi.security.authentication.credentials.AbstractCredentials;
import org.osgi.annotation.versioning.ConsumerType;

import javax.security.auth.login.LoginException;

/**
 * <p>This interface is intended to be implemented by an application which wants
 * to customize the validation of the users based on their credential.</p>
 *
 * <p>A {@code CredentialsValidator} is passed to {@link Provider} providers if {@link Provider#getId} equals
 * {@link CredentialsValidator#getId()} or {@link CredentialsValidator#getId()}
 * is equals to {@link CredentialsValidator#ALL_ID}-</p>
 */
@ConsumerType
public interface CredentialsValidator {

    /** Id used to register a validator to all providers **/
    String ALL_ID = "*";

    /**
     * Credentials Attribute Id used to store the reason why it is not considered valid
     */
    String FAILED_VALIDATION_REASON = CredentialsValidator.class.getCanonicalName() + ".validation.failed.reason";

    /**
     * Check the validity of a user credential. If the user credential is not valid, an optional credential attribute is stored with key  @{code
     *
     * @param credentials the non {@code null} credential
     * @return {@code true} if the credential is valid ; {@code false} otherwise
     * @throws javax.security.auth.login.LoginException if the user could not be authenticated
     */
    boolean validate(AbstractCredentials credentials) throws LoginException;

    /**
     * Provider identifier used to map this credential validator to it.
     *
     * @return the provider identifier to map this credentials validator to it or ALL_ID if applies to every provider.
     */
    String getId();
}
