/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.api;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.CheckForNull;
import java.util.List;

/**
 * PaginatableResourceList is a collection of paginated resources.  Provides access to the resources, as well as
 * an indication on whether or not more resources are available, and the information necessary to retrieve the next
 * set of resources.
 */
@ProviderType
public interface PaginatableResourceList {
    /**
     * Returns the value to use to get the next page of resources.
     * @return The next value.
     */
    @CheckForNull
    String getNextOffsetValue();

    /**
     * Returns the number of resources contained in the list.
     * @return The number of resources.
     */
    int getCount();

    /**
     * Returns the list of resources.
     * @return the list of resources
     */
    List<Resource> getResources();

    /**
     * Indicates whether more results are possible.  This is based on the presence of a valid nextOffsetValue or not.
     * @return Whether more results are possible.
     */
    boolean hasMore();
}
