/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.api;

/**
 * An enum to describe a sorting order, allowing ascending or descending as values.
 */
public enum SortOrder {
    /**
     * Ascending sort order.
     */
    ASCENDING,

    /**
     * Descending sort order.
     */
    DESCENDING;

    @Override
    public String toString() {
        switch(this) {
            case ASCENDING: return "asc";
            case DESCENDING: return "desc";
            default: throw new IllegalArgumentException();
        }
    }
}
