/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api.description;

import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/**
 * A description of a field that an action is expecting.
 */
@ProviderType
public interface ActionFieldDescription {
    /**
     * Get the name of the field.
     * @return The name.
     */
    @Nonnull
    String getName();

    /**
     * Get the type of the field.
     * @return The type.
     */
    @CheckForNull
    String getType();

    /**
     * Get the value of the field.
     * @return The value.
     */
    @CheckForNull
    Object getValue();

    /**
     * Get whether the field is optional or not.
     * @return Whether the field is optional or not.
     */
    boolean isOptional();

    /**
     * Get whether the field can support multiple values.
     * @return Whether the field can support multiple values.
     */
    boolean isMulti();
}
