/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.taskmanagement;

/**
 * TaskManagerException is the parent exception for all exceptions thrown out of TaskManager.
 */
public class TaskManagerException extends Exception {
    /**
     * Id of the task this exception originates with, or null if the exception is not tied to
     * a task id.
     */
    private String taskId;

    /**
     * Creates a new instance of TaskManagerException.
     */
    public TaskManagerException() {
        super();
    }

    /**
     * Creates a new instance of TaskManagerException.
     * @param message Message for this error.
     */
    public TaskManagerException(final String message) {
        super(message);
    }

    /**
     * Creates a new instance of TaskManagerException.
     * @param message Message for this error.
     * @param cause Cause of the exception.
     */
    public TaskManagerException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a new instance of TaskManagerException.
     * @param message Message for this error.
     * @param stack Stack trace for this exception.
     */
    public TaskManagerException(final String message, final StackTraceElement[] stack) {
        super(message);
        this.setStackTrace(stack);
    }

    /**
     * Sets the id of the task associated to this exception.
     * @param aTaskId String containing the task id.
     */
    public void setTaskId(final String aTaskId) {
        this.taskId = aTaskId;
    }

    /**
     * Gets the id of the task associated to this exception.
     * @return String containing the task id.
     */
    public String getTaskId() {
        return taskId;
    }

    /**
     * {@inheritDoc}
     */
    //@override
    public String getMessage() {
        String message = super.getMessage();
        if (null != this.taskId) {
            message += ", taskId = " + this.taskId;
        }
        return message;
    }
}

