/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs.script;

import java.io.IOException;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Another resource provider abstraction
 */
@ProviderType
public interface ScriptResourceProvider {

    /**
     * Provides a script resource for the given path.
     * @param path the path
     * @return the script resource or {@code null}
     * @throws IOException if an error occurrs
     */
    @CheckForNull
    ScriptResource getResource(@Nonnull String path) throws IOException;
}