/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2016 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs.script;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

import javax.annotation.Nonnull;

/**
 * Simple {@link ScriptResource} based on strings.
 */
public class StringScriptResource implements ScriptResource {

    /**
     * The script source
     */
    private final String source;

    /**
     * The name of the script
     */
    private final String name;

    /**
     * Creates a simple script resource based on a string.
     * @param source The source code
     * @param name the name of this source
     */
    public StringScriptResource(@Nonnull String source, @Nonnull String name) {
        this.source = source;
        this.name = name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getName() {
        return name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Reader getReader() throws IOException {
        return new StringReader(source);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public long getSize() {
        return source.length();
    }
}