/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2021 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 *
 **************************************************************************/

package com.adobe.granite.workflow.metadata.storage;

import com.adobe.granite.workflow.exec.Workflow;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface UserMetaDataPersistenceContext {

    /**
     * Gets the workflow for persistence
     * @return workflow
     */
    Workflow getWorkflow();

    /**
     * Gets the workflow id for persistence
     * @return workflowId
     */
    String getWorkflowId();

    /**
     * Gets the user metadata persistence id
     * @return userDataId
     */
    String getUserDataId();
}
