/**
 * 
 */
package com.adobe.internal.io;

import java.io.IOException;
import java.io.InputStream;

/**
 * A wrapper stream representing multiple underlying streams as a single stream.
 *
 */
public class ChainedInputStream extends InputStream
{
	private InputStream[] streams;
	private int streamIndex;
	private int streamCount;
	
	private static final int EOF = -1;
	
	/**
	 * 
	 */
	public ChainedInputStream(InputStream[] streams)
	{
		this.streams = streams;
		this.streamCount = streams.length;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#read()
	 */
	public int read() throws IOException
	{
		if (this.streamIndex >= this.streamCount)
		{
			return EOF;
		}
		int value = this.streams[streamIndex].read();
		while ((value == EOF) && (++this.streamIndex < this.streamCount))
		{
			value = this.streams[streamIndex].read();
		}
		return value;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#available()
	 */
	public int available() throws IOException
	{
		if (streamIndex >= this.streamCount)
		{
			return 0;
		}
		return this.streams[streamIndex].available();
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#close()
	 */
	public void close() throws IOException
	{
		for (int i = 0; i < this.streamCount; i++)
		{
			this.streams[i].close();
		}
		this.streams = null;
		this.streamCount = 0;
	}
}
