/* ****************************************************************************
 *
 *	File: CosObjectRefHolder.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2010 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.pdftoolkit.core.util.AbstractRefAdapter;

/**
 * This class keeps the reference of CosObject and overrides equals() method.
 * This class can be used as a wrapper of CosObject where we don't want to do deep equality checks but only reference checking.
 * @author hkansal
 *
 */
public class CosObjectRefAdapter extends AbstractRefAdapter<CosObject>{
	
	private CosObjectRefAdapter(CosObject cosObject){
		this.objectRef = cosObject;
	}
	/**
	 * returns new instance of CosObjectRefHolder.
	 * @param cosObject
	 * @return CosObjectRefHolder
	 */
	public static CosObjectRefAdapter newInstance(CosObject cosObject){
		if(cosObject == null)
			return null;
		return new CosObjectRefAdapter(cosObject);
	}
	
	
	@Override
	public boolean equals(Object obj) {
		if(!(obj instanceof CosObjectRefAdapter))
			return false;
		return ((CosObjectRefAdapter)obj).objectRef == this.objectRef;
	}
			
}
