/*
 *
 *	File: PDFUnsupportedFeatureException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.pdftoolkit.core.exceptions;

/**
 * A portion of the PDF spec that is required to complete the request
 * is not currently supported in the Adobe PDF Java  Toolkit.
 */
public class PDFUnsupportedFeatureException extends RuntimeException
{
	/**
	 * This is a default serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Create a new PDFException.
     * @param message the detail message.
     */
    public PDFUnsupportedFeatureException(String message)
    {
        super(message);
    }

    /**
     * Create a new PDFException wrapping an existing exception.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PDFUnsupportedFeatureException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Create a new PDFException wrapping an existing exception.
     * @param cause the cause.
     */
    public PDFUnsupportedFeatureException(Throwable cause)
    {
        super(cause);
    }
}
