/* ****************************************************************************
 *
 *	File: ASObject.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;

/**
 * This class represents non-cos PDF objects.
 *
 */
public abstract class ASObject
{
	protected ASObject(){}
	
	/**
	 * Writes the ASObject to the given OutputStream in the format expected by the PDF Spec.
	 *
	 * @param outputByteStream OutputByteStream to write to.
	 * @throws PDFIOException exception from OutputStream
	 */
	public abstract void write(OutputByteStream outputByteStream) throws PDFIOException;
    
    //public abstract boolean read(InputByteStream inputStream);
    
	//public abstract boolean read(byte[] b);
	
    //public abstract byte[] toPDFBytes();
    
    //public abstrast byte[] toPDFBytes(
    
    //public abstract String toPDFString();
    
}
