/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;


/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class EnumType {
	/**
	 * High order bit on type is used to indicate that this enum type gets
	 * used in ambiguous contexts.
	 */
	public static final int AMBIGUOUS_MASK = 0x80000000;

	/**
	 * Second high order bit is used to indicate that this enum type gets
	 * used as an element value.
	 */
	public static final int ELEMENTAL_MASK = 0x40000000;

	private final int mNum;
	private final String mName;
	private EnumType(int num, String sName) {
		assert ((num & ~(AMBIGUOUS_MASK | ELEMENTAL_MASK)) <= TYPE_MAX);
		assert ((num & EnumAttr.ENUM_VALUE_MASK) == 0);
		mNum = num;
		mName = sName;
	}
	
	int getInt() {
		return mNum;
	}
	boolean usedAmbiguously() {
		return (mNum & AMBIGUOUS_MASK) != 0;
	}
	boolean usedElementarily() {
		return (mNum & ELEMENTAL_MASK) != 0;
	}
	static public EnumType getEnum(int value) {
		int pos = (value & ~(AMBIGUOUS_MASK | ELEMENTAL_MASK)) >> 16;
		return gTypes[pos-1];	// pos is one-based
	}
	
	public String toString() {
		return mName;
	}

	/**
	 * The complete list of enumerated types.  The entries in this list are
	 * categories of enums.  The enumerated values are restricted to the upper
	 * 16 bits.  The values that belong in each of these categories will share
	 * the same upper bits and will be made unique by numbering within the 
	 * lower 16 bits.
	 */
	// The values in the list *must* remain in consecutive order
	// no gaps!  (They don't have to stay in alphabetic order)
	public static final int ACCESS    			= 0x00010000;
	public static final int ANCHOR  			= 0x00020000;
	public static final int ATTRIBUTES 			= 0x40030000;
	public static final int BOOLEAN				= 0x40040000;
	public static final int CAP					= 0x00050000;
	public static final int CONTROLCODE			= 0x00060000;
	public static final int DEST				= 0x00070000;
	public static final int DESTOP				= 0x00080000;
	public static final int ENCODING			= 0x00090000;
	public static final int ENCRYPTIONLEVEL		= 0x400A0000;
	public static final int EXCEPTION			= 0x000B0000;
	public static final int FONTLINETHROUGH		= 0x000C0000;
	public static final int FONTLINETHROUGHPERIOD=0x000D0000;
	public static final int FONTOVERLINE		= 0x000E0000;
	public static final int FONTOVERLINEPERIOD	= 0x000F0000;
	public static final int FONTPITCH			= 0x00100000;
	public static final int FONTPOSTURE			= 0x00110000;
	public static final int FONTUNDERLINE		= 0x00120000;
	public static final int FONTUNDERLINEPERIOD	= 0x00130000;
	public static final int FONTWEIGHT			= 0x00140000;
	public static final int FRACTION			= 0x00150000;
	public static final int HALIGN				= 0x00160000;
	public static final int HAND				= 0x00170000;
	public static final int IFEMPTY				= 0x40180000;
	public static final int IMAGINGBBOX			= 0x00190000;
	public static final int JOIN				= 0x001A0000;
	public static final int LAYOUT				= 0x001B0000;
	public static final int LINEAR				= 0x801C0000;
	public static final int LINEEND				= 0x001D0000;
	public static final int LOGTO				= 0x801E0000;
	public static final int MATCH				= 0x001F0000;
	public static final int MESSAGETYPE			= 0x40200000;
	public static final int MODE				= 0x40210000;
	public static final int NODEPRESENCE		= 0x00220000;
	public static final int OPEN				= 0x00230000;
	public static final int OPERATION			= 0x80240000;
	public static final int ORDER				= 0x00250000;
	public static final int ORIENTATION			= 0x00260000;
	public static final int OUTPUTTO			= 0x80270000;
	public static final int OVERRIDE			= 0x80280000;
	public static final int PATTERN				= 0x80290000;
	public static final int PRESENCE			= 0x402A0000;
	public static final int RADIAL				= 0x802B0000;
	public static final int RELATION			= 0x802C0000;
	public static final int SCRIPTMODEL			= 0x402D0000;
	public static final int SELECT				= 0x002E0000;
	public static final int SEVERITY			= 0x402F0000;
	public static final int SHAPE				= 0x00300000;
	public static final int SLOPE				= 0x00310000;
	public static final int SPLITBIAS			= 0x00320000;
	public static final int STROKE				= 0x00330000;
	public static final int STYLETYPE			= 0x00340000;
	public static final int SUBFORMBREAK		= 0x00350000;
	public static final int SUBFORMKEEP			= 0x00360000;
	public static final int SUBMITFORMAT		= 0x40370000;
	public static final int TEST				= 0x00380000;
	public static final int TRANSFERENCODING	= 0x00390000;
	public static final int TRAYIN				= 0x003A0000;
	public static final int TRAYOUT				= 0x003B0000;
	public static final int UNIT				= 0x003C0000;
	public static final int UNSIGN				= 0x003D0000;
	public static final int VALIGN				= 0x003E0000;
	public static final int WHITESPACE			= 0x403F0000;
	public static final int PLACEMENT			= 0x00400000;
	public static final int DESTINATION			= 0x40410000;
	public static final int DB					= 0x00420000;
	public static final int CMDTYPE				= 0x00430000;
	public static final int CURSORTYPE			= 0x00440000;
	public static final int CURSORLOCATION		= 0x00450000;
	public static final int LOCKTYPE			= 0x00460000;
	public static final int INCREMENTALLOAD		= 0x40470000;
	public static final int BOFACTION			= 0x00480000;
	public static final int EOFACTION			= 0x00490000;
	public static final int NODETYPE			= 0x004A0000;
	public static final int ACTIVITY			= 0x004B0000;
	public static final int FORMAT				= 0x804C0000;
	public static final int NULLTYPE			= 0x004D0000;
	public static final int ASPECT				= 0x004E0000;
	public static final int OUTPUTTYPE			= 0x004F0000;
	public static final int CALENDARSYMBOLS		= 0x00500000;
	public static final int DATETIMESYMBOLS		= 0x80510000;
	public static final int NUMBERPATTERN		= 0x80520000;
	public static final int NUMBERSYMBOL		= 0x80530000;
	public static final int CURRENCYSYMBOL		= 0x80540000;
	public static final int PARITY				= 0x00550000;
	public static final int TEXTLOCATION		= 0x00560000;
	public static final int CHECKSUM			= 0x00570000;
	public static final int SIGNATURETYPE		= 0x80580000;
	public static final int BORDERBREAK			= 0x00590000;
	public static final int SUPPORT				= 0x005A0000;
	public static final int SCOPE				= 0x005B0000;
	public static final int XDCLAYOUT			= 0x405C0000;
	public static final int RUNAT				= 0x405D0000;
	public static final int PRIORITY			= 0x005E0000;
	public static final int USAGE				= 0x005F0000;
	public static final int EXECUTETYPE			= 0x00600000;
	public static final int DATA    			= 0x00610000;
	public static final int DATAPREP			= 0x00620000;
	public static final int SIGNOPERATION		= 0x80630000;
	public static final int REQUIREMENT			= 0x80640000;
	public static final int COMMITON			= 0x00650000;
	public static final int DYNAMICRENDER		= 0x40660000;
	public static final int BATCHFORMAT         = 0x00670000;
	public static final int RENDERPOLICY		= 0x40680000;
	public static final int WRITINGSCRIPT		= 0x00690000;
	public static final int TAGGEDMODE			= 0x406A0000;
	public static final int RUNSCRIPTS			= 0x406B0000;
	public static final int MANIFESTACTION 		= 0x006C0000;
	public static final int MDPSIGNATURETYPE	= 0x006D0000;
	public static final int MDPPERMISSIONS		= 0x006E0000;
	public static final int PAGESETRELATION 	= 0x806F0000;
	public static final int PAGEPOSITION 		= 0x00700000;
	public static final int ODDOREVEN 			= 0x00710000;
	public static final int BLANKORNOTBLANK 	= 0x00720000;
	public static final int SCROLLPOLICY		= 0x00730000;
	public static final int BASEPROFILE 		= 0x00740000;
	public static final int DUPLEXOPTION		= 0x40750000;
	public static final int MARK				= 0x00760000;
	public static final int HIGHLIGHT			= 0x00770000;
	public static final int RESTORESTATE		= 0x00780000;
	public static final int PAGINATION			= 0x40790000;
	public static final int JOGOPTION			= 0x407A0000;
	public static final int ADDREVOCATIONINFO	= 0x007B0000;
	public static final int UPSMODE				= 0x007C0000;
	public static final int SOURCEBELOW			= 0x007D0000;
	public static final int SOURCEABOVE			= 0x007E0000;
	public static final int OUTPUTBELOW			= 0x007F0000;
	public static final int COMPRESSSCOPE		= 0x00800000;
	public static final int STAPLEMODE			= 0x00810000;
	public static final int PDFACONFORMANCE		= 0x40820000;
	public static final int OVERPRINT			= 0x40830000;
	public static final int GENERICFAMILY		= 0x00840000;
	public static final int KERNINGMODE			= 0x00850000;
	public static final int PICKER				= 0x00860000;
	public static final int PAGINATIONOVERRIDE	= 0x40870000;
	public static final int VALIDATIONMESSAGING = 0x40880000;
	public static final int EVENTLISTEN			= 0x40890000;
	public static final int PRINTSCALING		= 0x408A0000;
	public static final int DUPLEXIMPOSITION  	= 0x008B0000;
	public static final int MERGEMODE			= 0x008C0000;	
	public static final int CREDENTIALPOLICY	= 0x008D0000;	// added to resolve ambiguities.
	public static final int SUBMIT				= 0x808E0000;	// added to resolve ambiguities.
	public static final int BATCHOUTPUT			= 0x808F0000;	// added to resolve ambiguities.
	public static final int TYPEFACE			= 0x00900000;
	public static final int TYPE_MAX 			= 0x00900000;	// MAKE SURE THIS STAYS AT THE END, and is equal to the largest value.

	public static final EnumType ACCESS_TYPE = new EnumType(ACCESS,	XFA.ACCESS);
	public static final EnumType ANCHOR_TYPE = new EnumType(ANCHOR, "anchor");
	public static final EnumType ATTRIBUTES_TYPE = new EnumType(ATTRIBUTES, XFA.ATTRIBUTES);
	public static final EnumType BOOLEAN_TYPE = new EnumType(BOOLEAN, XFA.BOOLEAN);
	public static final EnumType CAP_TYPE = new EnumType(CAP, XFA.CAP);
	public static final EnumType CONTROLCODE_TYPE = new EnumType(CONTROLCODE, XFA.CONTROLCODE);
	public static final EnumType DEST_TYPE = new EnumType(DEST, XFA.DEST);
	public static final EnumType DESTOP_TYPE = new EnumType(DESTOP, XFA.DESTOP);
	public static final EnumType ENCODING_TYPE = new EnumType(ENCODING, XFA.ENCODING);
	public static final EnumType ENCRYPTIONLEVEL_TYPE = new EnumType(ENCRYPTIONLEVEL, XFA.ENCRYPTIONLEVEL);
	public static final EnumType EXCEPTION_TYPE = new EnumType(EXCEPTION, "exception");
	public static final EnumType FONTLINETHROUGH_TYPE = new EnumType(FONTLINETHROUGH, "fontLineThrough");
	public static final EnumType FONTLINETHROUGHPERIOD_TYPE = new EnumType(FONTLINETHROUGHPERIOD, "fontLineThroughPeriod");
	public static final EnumType FONTOVERLINE_TYPE = new EnumType(FONTOVERLINE, "fontOverline");
	public static final EnumType FONTOVERLINEPERIOD_TYPE = new EnumType(FONTOVERLINEPERIOD, "fontOverlinePeriod");
	public static final EnumType FONTPITCH_TYPE = new EnumType(FONTPITCH, "fontPitch");
	public static final EnumType FONTPOSTURE_TYPE = new EnumType(FONTPOSTURE, "fontPosture");
	public static final EnumType FONTUNDERLINE_TYPE = new EnumType(FONTUNDERLINE, "fontUnderline");
	public static final EnumType FONTUNDERLINEPERIOD_TYPE = new EnumType(FONTUNDERLINEPERIOD, "fontUnderlinePeriod");
	public static final EnumType FONTWEIGHT_TYPE = new EnumType(FONTWEIGHT, "fontWeight");
	public static final EnumType FRACTION_TYPE = new EnumType(FRACTION, XFA.FRACTION);
	public static final EnumType HALIGN_TYPE = new EnumType(HALIGN, XFA.HALIGN);
	public static final EnumType HAND_TYPE = new EnumType(HAND, XFA.HAND);
	public static final EnumType IFEMPTY_TYPE = new EnumType(IFEMPTY, XFA.IFEMPTY);
	public static final EnumType IMAGINGBBOX_TYPE = new EnumType(IMAGINGBBOX, XFA.IMAGINGBBOX);
	public static final EnumType JOIN_TYPE = new EnumType(JOIN, XFA.JOIN);
	public static final EnumType LAYOUT_TYPE = new EnumType(LAYOUT, XFA.LAYOUT);
	public static final EnumType LINEAR_TYPE = new EnumType(LINEAR, XFA.LINEAR);
	public static final EnumType LINEEND_TYPE = new EnumType(LINEEND, "lineend");
	public static final EnumType LOGTO_TYPE = new EnumType(LOGTO, "logto");
	public static final EnumType MATCH_TYPE = new EnumType(MATCH, XFA.MATCH);
	public static final EnumType MESSAGETYPE_TYPE = new EnumType(MESSAGETYPE, "messageType");
	public static final EnumType MODE_TYPE = new EnumType(MODE, XFA.MODE);
	public static final EnumType NODEPRESENCE_TYPE = new EnumType(NODEPRESENCE, "nodePresence");
	public static final EnumType OPEN_TYPE = new EnumType(OPEN, XFA.OPEN);
	public static final EnumType OPERATION_TYPE = new EnumType(OPERATION, XFA.OPERATION);
	public static final EnumType ORDER_TYPE = new EnumType(ORDER, "order");
	public static final EnumType ORIENTATION_TYPE = new EnumType(ORIENTATION, XFA.ORIENTATION);
	public static final EnumType OUTPUTTO_TYPE = new EnumType(OUTPUTTO, "outputto");
	public static final EnumType OVERRIDE_TYPE = new EnumType(OVERRIDE, XFA.OVERRIDE);
	public static final EnumType PATTERN_TYPE = new EnumType(PATTERN, XFA.PATTERN);
	public static final EnumType PRESENCE_TYPE = new EnumType(PRESENCE, XFA.PRESENCE);
	public static final EnumType RADIAL_TYPE = new EnumType(RADIAL, XFA.RADIAL);
	public static final EnumType RELATION_TYPE = new EnumType(RELATION, XFA.RELATION);
	public static final EnumType SCRIPTMODEL_TYPE = new EnumType(SCRIPTMODEL, XFA.SCRIPTMODEL);
	public static final EnumType SELECT_TYPE = new EnumType(SELECT, XFA.SELECT);
	public static final EnumType SEVERITY_TYPE = new EnumType(SEVERITY, XFA.SEVERITY);
	public static final EnumType SHAPE_TYPE = new EnumType(SHAPE, XFA.SHAPE);
	public static final EnumType SLOPE_TYPE = new EnumType(SLOPE, XFA.SLOPE);
	public static final EnumType SPLITBIAS_TYPE = new EnumType(SPLITBIAS, "splitBias");
	public static final EnumType STROKE_TYPE = new EnumType(STROKE, XFA.STROKE);
	public static final EnumType STYLETYPE_TYPE = new EnumType(STYLETYPE, XFA.STYLETYPE);
	public static final EnumType SUBFORMBREAK_TYPE = new EnumType(SUBFORMBREAK, "subformBreak");
	public static final EnumType SUBFORMKEEP_TYPE = new EnumType(SUBFORMKEEP, "subformKeep");
	public static final EnumType SUBMITFORMAT_TYPE = new EnumType(SUBMITFORMAT, XFA.SUBMITFORMAT);
	public static final EnumType TEST_TYPE = new EnumType(TEST, "test");
	public static final EnumType TRANSFERENCODING_TYPE = new EnumType(TRANSFERENCODING, XFA.TRANSFERENCODING);
	public static final EnumType TRAYIN_TYPE = new EnumType(TRAYIN, XFA.TRAYIN);
	public static final EnumType TRAYOUT_TYPE = new EnumType(TRAYOUT, XFA.TRAYOUT);
	public static final EnumType UNIT_TYPE = new EnumType(UNIT, "unit");
	public static final EnumType UNSIGN_TYPE = new EnumType(UNSIGN, "unsign");
	public static final EnumType VALIGN_TYPE = new EnumType(VALIGN, XFA.VALIGN);
	public static final EnumType WHITESPACE_TYPE = new EnumType(WHITESPACE, XFA.WHITESPACE);
	public static final EnumType PLACEMENT_TYPE = new EnumType(PLACEMENT, XFA.PLACEMENT);
	public static final EnumType DESTINATION_TYPE = new EnumType(DESTINATION, XFA.DESTINATION);
	public static final EnumType DB_TYPE = new EnumType(DB, XFA.DB);
	public static final EnumType CMDTYPE_TYPE = new EnumType(CMDTYPE, "cmdtype");
	public static final EnumType CURSORTYPE_TYPE = new EnumType(CURSORTYPE, XFA.CURSORTYPE);
	public static final EnumType CURSORLOCATION_TYPE = new EnumType(CURSORLOCATION, XFA.CURSORLOCATION);
	public static final EnumType LOCKTYPE_TYPE = new EnumType(LOCKTYPE, XFA.LOCKTYPE);
	public static final EnumType INCREMENTALLOAD_TYPE = new EnumType(INCREMENTALLOAD, XFA.INCREMENTALLOAD);
	public static final EnumType BOFACTION_TYPE = new EnumType(BOFACTION, XFA.BOFACTION);
	public static final EnumType EOFACTION_TYPE = new EnumType(EOFACTION, XFA.EOFACTION);
	public static final EnumType NODETYPE_TYPE = new EnumType(NODETYPE, XFA.NODETYPE);
	public static final EnumType ACTIVITY_TYPE = new EnumType(ACTIVITY, XFA.ACTIVITY);
	public static final EnumType FORMAT_TYPE = new EnumType(FORMAT, XFA.FORMAT);
	public static final EnumType NULLTYPE_TYPE = new EnumType(NULLTYPE, XFA.NULLTYPE);
	public static final EnumType ASPECT_TYPE = new EnumType(ASPECT, XFA.ASPECT);
	public static final EnumType OUTPUTTYPE_TYPE = new EnumType(OUTPUTTYPE, "outputtype");
	public static final EnumType CALENDARSYMBOLS_TYPE = new EnumType(CALENDARSYMBOLS, XFA.CALENDARSYMBOLS);
	public static final EnumType DATETIMESYMBOLS_TYPE = new EnumType(DATETIMESYMBOLS, XFA.DATETIMESYMBOLS);
	public static final EnumType NUMBERPATTERN_TYPE = new EnumType(NUMBERPATTERN, XFA.NUMBERPATTERN);
	public static final EnumType NUMBERSYMBOL_TYPE = new EnumType(NUMBERSYMBOL, XFA.NUMBERSYMBOL);
	public static final EnumType CURRENCYSYMBOL_TYPE = new EnumType(CURRENCYSYMBOL, XFA.CURRENCYSYMBOL);
	public static final EnumType PARITY_TYPE = new EnumType(PARITY, XFA.PARITY);
	public static final EnumType TEXTLOCATION_TYPE = new EnumType(TEXTLOCATION, XFA.TEXTLOCATION);
	public static final EnumType CHECKSUM_TYPE = new EnumType(CHECKSUM, XFA.CHECKSUM);
	public static final EnumType SIGNATURETYPE_TYPE = new EnumType(SIGNATURETYPE, XFA.SIGNATURETYPE);
	public static final EnumType BORDERBREAK_TYPE = new EnumType(BORDERBREAK, "borderBreak");
	public static final EnumType SUPPORT_TYPE = new EnumType(SUPPORT, XFA.SUPPORT);
	public static final EnumType SCOPE_TYPE = new EnumType(SCOPE, XFA.SCOPE);
	public static final EnumType XDCLAYOUT_TYPE = new EnumType(XDCLAYOUT, XFA.LAYOUT);
	public static final EnumType RUNAT_TYPE = new EnumType(RUNAT, XFA.RUNAT);
	public static final EnumType PRIORITY_TYPE = new EnumType(PRIORITY, XFA.PRIORITY);
	public static final EnumType USAGE_TYPE = new EnumType(USAGE, XFA.USAGE);
	public static final EnumType EXECUTETYPE_TYPE = new EnumType(EXECUTETYPE, XFA.EXECUTETYPE);
	public static final EnumType DATA_TYPE = new EnumType(DATA, XFA.DATA);
	public static final EnumType DATAPREP_TYPE = new EnumType(DATAPREP, XFA.DATAPREP);
	public static final EnumType SIGNOPERATION_TYPE = new EnumType(SIGNOPERATION, "signOperation");
	public static final EnumType REQUIREMENT_TYPE = new EnumType(REQUIREMENT, "requirement");
	public static final EnumType COMMITON_TYPE = new EnumType(COMMITON, XFA.COMMITON);
	public static final EnumType DYNAMICRENDER_TYPE = new EnumType(DYNAMICRENDER, XFA.DYNAMICRENDER);
	public static final EnumType BATCHFORMAT_TYPE = new EnumType(BATCHFORMAT, XFA.FORMAT);
	public static final EnumType RENDERPOLICY_TYPE = new EnumType(RENDERPOLICY, XFA.RENDERPOLICY);
	public static final EnumType WRITINGSCRIPT_TYPE = new EnumType(WRITINGSCRIPT, XFA.WRITINGSCRIPT);
	public static final EnumType TAGGEDMODE_TYPE = new EnumType(TAGGEDMODE, XFA.TAGGEDMODE);
	public static final EnumType RUNSCRIPTS_TYPE = new EnumType(RUNSCRIPTS, XFA.RUNSCRIPTS);
	public static final EnumType MANIFESTACTION_TYPE = new EnumType(MANIFESTACTION, XFA.ACTION);
	public static final EnumType MDPSIGNATURETYPE_TYPE = new EnumType(MDPSIGNATURETYPE, XFA.SIGNATURETYPE);
	public static final EnumType MDPPERMISSIONS_TYPE = new EnumType(MDPPERMISSIONS, XFA.PERMISSIONS);
	public static final EnumType PAGESETRELATION_TYPE = new EnumType(PAGESETRELATION, XFA.RELATION);
	public static final EnumType PAGEPOSITION_TYPE = new EnumType(PAGEPOSITION, XFA.PAGEPOSITION);
	public static final EnumType ODDOREVEN_TYPE = new EnumType(ODDOREVEN, XFA.ODDOREVEN);
	public static final EnumType BLANKORNOTBLANK_TYPE = new EnumType(BLANKORNOTBLANK, XFA.BLANKORNOTBLANK);
	public static final EnumType SCROLLPOLICY_TYPE = new EnumType(SCROLLPOLICY, "scrollPolicy");
	public static final EnumType BASEPROFILE_TYPE = new EnumType(BASEPROFILE, XFA.BASEPROFILE);
	public static final EnumType DUPLEXOPTION_TYPE = new EnumType(DUPLEXOPTION, XFA.DUPLEXOPTION);
	public static final EnumType MARK_TYPE = new EnumType(MARK, XFA.MARK);
	public static final EnumType HIGHLIGHT_TYPE = new EnumType(HIGHLIGHT, XFA.HIGHLIGHT);
	public static final EnumType RESTORESTATE_TYPE = new EnumType(RESTORESTATE, XFA.RESTORESTATE);
	public static final EnumType PAGINATION_TYPE = new EnumType(PAGINATION, XFA.PAGINATION);
	public static final EnumType JOGOPTION_TYPE = new EnumType(JOGOPTION, XFA.JOG);
	public static final EnumType ADDREVOCATIONINFO_TYPE = new EnumType(ADDREVOCATIONINFO, XFA.ADDREVOCATIONINFO);
	public static final EnumType UPSMODE_TYPE = new EnumType(UPSMODE, XFA.MARK);
	public static final EnumType SOURCEBELOW_TYPE = new EnumType(SOURCEBELOW, XFA.SOURCEBELOW);
	public static final EnumType SOURCEABOVE_TYPE = new EnumType(SOURCEABOVE, XFA.SOURCEABOVE);
	public static final EnumType OUTPUTBELOW_TYPE = new EnumType(OUTPUTBELOW, XFA.OUTPUTBELOW);
	public static final EnumType COMPRESSSCOPE_TYPE = new EnumType(COMPRESSSCOPE, XFA.SCOPE);
	public static final EnumType STAPLEMODE_TYPE = new EnumType(STAPLEMODE, XFA.MODE);
	public static final EnumType PDFACONFORMANCE_TYPE = new EnumType(PDFACONFORMANCE, XFA.CONFORMANCE);
	public static final EnumType GENERICFAMILY_TYPE = new EnumType(GENERICFAMILY, XFA.GENERICFAMILY);
	public static final EnumType OVERPRINT_TYPE = new EnumType(OVERPRINT, XFA.OVERPRINT);
	public static final EnumType KERNINGMODE_TYPE = new EnumType(KERNINGMODE, XFA.KERNINGMODE);
	public static final EnumType PICKER_TYPE = new EnumType(PICKER, XFA.PICKER);
	public static final EnumType PAGINATIONOVERRIDE_TYPE = new EnumType(PAGINATIONOVERRIDE, XFA.PAGINATIONOVERRIDE);
	public static final EnumType VALIDATIONMESSAGING_TYPE = new EnumType(VALIDATIONMESSAGING, XFA.VALIDATIONMESSAGING);
	public static final EnumType EVENTLISTEN_TYPE = new EnumType(EVENTLISTEN, XFA.LISTEN);
	public static final EnumType PRINTSCALING_TYPE = new EnumType(PRINTSCALING, XFA.PRINTSCALING);
	public static final EnumType DUPLEXIMPOSITION_TYPE = new EnumType(DUPLEXIMPOSITION, XFA.DUPLEXIMPOSITION);
	public static final EnumType MERGEMODE_TYPE = new EnumType(MERGEMODE, XFA.MERGEMODE);
	public static final EnumType CREDENTIALPOLICY_TYPE = new EnumType(CREDENTIALPOLICY, XFA.CREDENTIALSERVERPOLICY);

	// members of this list must appear in the same order as the corresponding integer entry above.
	static final EnumType[] gTypes = new EnumType[] {
		ACCESS_TYPE,
		ANCHOR_TYPE,
		ATTRIBUTES_TYPE,
		BOOLEAN_TYPE,
		CAP_TYPE,
		CONTROLCODE_TYPE,
		DEST_TYPE,
		DESTOP_TYPE,
		ENCODING_TYPE,
		ENCRYPTIONLEVEL_TYPE,
		EXCEPTION_TYPE,
		FONTLINETHROUGH_TYPE,
		FONTLINETHROUGHPERIOD_TYPE,
		FONTOVERLINE_TYPE,
		FONTOVERLINEPERIOD_TYPE,
		FONTPITCH_TYPE,
		FONTPOSTURE_TYPE,
		FONTUNDERLINE_TYPE,
		FONTUNDERLINEPERIOD_TYPE,
		FONTWEIGHT_TYPE,
		FRACTION_TYPE,
		HALIGN_TYPE,
		HAND_TYPE,
		IFEMPTY_TYPE,
		IMAGINGBBOX_TYPE,
		JOIN_TYPE,
		LAYOUT_TYPE,
		LINEAR_TYPE,
		LINEEND_TYPE,
		LOGTO_TYPE,
		MATCH_TYPE,
		MESSAGETYPE_TYPE,
		MODE_TYPE,
		NODEPRESENCE_TYPE,
		OPEN_TYPE,
		OPERATION_TYPE,
		ORDER_TYPE,
		ORIENTATION_TYPE,
		OUTPUTTO_TYPE,
		OVERRIDE_TYPE,
		PATTERN_TYPE,
		PRESENCE_TYPE,
		RADIAL_TYPE,
		RELATION_TYPE,
		SCRIPTMODEL_TYPE,
		SELECT_TYPE,
		SEVERITY_TYPE,
		SHAPE_TYPE,
		SLOPE_TYPE,
		SPLITBIAS_TYPE,
		STROKE_TYPE,
		STYLETYPE_TYPE,
		SUBFORMBREAK_TYPE,
		SUBFORMKEEP_TYPE,
		SUBMITFORMAT_TYPE,
		TEST_TYPE,
		TRANSFERENCODING_TYPE,
		TRAYIN_TYPE,
		TRAYOUT_TYPE,
		UNIT_TYPE,
		UNSIGN_TYPE,
		VALIGN_TYPE,
		WHITESPACE_TYPE,
		PLACEMENT_TYPE,
		DESTINATION_TYPE,
		DB_TYPE,
		CMDTYPE_TYPE,
		CURSORTYPE_TYPE,
		CURSORLOCATION_TYPE,
		LOCKTYPE_TYPE,
		INCREMENTALLOAD_TYPE,
		BOFACTION_TYPE,
		EOFACTION_TYPE,
		NODETYPE_TYPE,
		ACTIVITY_TYPE,
		FORMAT_TYPE,
		NULLTYPE_TYPE,
		ASPECT_TYPE,
		OUTPUTTYPE_TYPE,
		CALENDARSYMBOLS_TYPE,
		DATETIMESYMBOLS_TYPE,
		NUMBERPATTERN_TYPE,
		NUMBERSYMBOL_TYPE,
		CURRENCYSYMBOL_TYPE,
		PARITY_TYPE,
		TEXTLOCATION_TYPE,
		CHECKSUM_TYPE,
		SIGNATURETYPE_TYPE,
		BORDERBREAK_TYPE,
		SUPPORT_TYPE,
		SCOPE_TYPE,
		XDCLAYOUT_TYPE,
		RUNAT_TYPE,
		PRIORITY_TYPE,
		USAGE_TYPE,
		EXECUTETYPE_TYPE,
		DATA_TYPE,
		DATAPREP_TYPE,
		SIGNOPERATION_TYPE,
		REQUIREMENT_TYPE,
		COMMITON_TYPE,
		DYNAMICRENDER_TYPE,
		BATCHFORMAT_TYPE,
		RENDERPOLICY_TYPE,
		WRITINGSCRIPT_TYPE,
		TAGGEDMODE_TYPE,
		RUNSCRIPTS_TYPE,
		MANIFESTACTION_TYPE,
		MDPSIGNATURETYPE_TYPE,
		MDPPERMISSIONS_TYPE,
		PAGESETRELATION_TYPE,
		PAGEPOSITION_TYPE,
		ODDOREVEN_TYPE,
		BLANKORNOTBLANK_TYPE,
		SCROLLPOLICY_TYPE,
		BASEPROFILE_TYPE,
		DUPLEXOPTION_TYPE,
		MARK_TYPE,
		HIGHLIGHT_TYPE,
		RESTORESTATE_TYPE,
		PAGINATION_TYPE,
		JOGOPTION_TYPE,
		ADDREVOCATIONINFO_TYPE,
		UPSMODE_TYPE,
		SOURCEBELOW_TYPE,
		SOURCEABOVE_TYPE,
		OUTPUTBELOW_TYPE,
		COMPRESSSCOPE_TYPE,
		STAPLEMODE_TYPE,
		PDFACONFORMANCE_TYPE,
		OVERPRINT_TYPE,
		GENERICFAMILY_TYPE,
		KERNINGMODE_TYPE,
		PICKER_TYPE,
		PAGINATIONOVERRIDE_TYPE,
		VALIDATIONMESSAGING_TYPE,
		EVENTLISTEN_TYPE,
		PRINTSCALING_TYPE,
		DUPLEXIMPOSITION_TYPE,
		MERGEMODE_TYPE,
		CREDENTIALPOLICY_TYPE
	};
}

